/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.wsrp.producer.config.impl;

import java.util.ArrayList;
import java.util.List;
import org.gatein.common.util.ParameterValidation;
import org.gatein.wsrp.SupportsLastModified;
import org.gatein.wsrp.producer.config.ProducerConfiguration;
import org.gatein.wsrp.producer.config.ProducerConfigurationChangeListener;
import org.gatein.wsrp.producer.config.ProducerRegistrationRequirements;
import org.gatein.wsrp.producer.config.impl.ProducerRegistrationRequirementsImpl;
import org.oasis.wsrp.v2.CookieProtocol;

public class ProducerConfigurationImpl
extends SupportsLastModified
implements ProducerConfiguration {
    private ProducerRegistrationRequirements requirements;
    private boolean strictMode = true;
    private List<ProducerConfigurationChangeListener> listeners = new ArrayList<ProducerConfigurationChangeListener>(7);
    private int sessionExpirationTime = 300000;
    private CookieProtocol requiresInitCookie = CookieProtocol.NONE;

    @Override
    public ProducerRegistrationRequirements getRegistrationRequirements() {
        if (this.requirements == null) {
            this.requirements = new ProducerRegistrationRequirementsImpl(false, false, false);
        }
        return this.requirements;
    }

    @Override
    public boolean isUsingStrictMode() {
        return this.strictMode;
    }

    @Override
    public void setUsingStrictMode(boolean strict) {
        if (this.modifyNowIfNeeded(this.strictMode, strict)) {
            this.strictMode = strict;
            for (ProducerConfigurationChangeListener listener : this.listeners) {
                listener.usingStrictModeChangedTo(strict);
            }
        }
    }

    @Override
    public void addChangeListener(ProducerConfigurationChangeListener listener) {
        ParameterValidation.throwIllegalArgExceptionIfNull((Object)listener, (String)"ProducerConfigurationChangeListener");
        this.listeners.add(listener);
    }

    @Override
    public void removeChangeListener(ProducerConfigurationChangeListener listener) {
        ParameterValidation.throwIllegalArgExceptionIfNull((Object)listener, (String)"ProducerConfigurationChangeListener");
        this.listeners.remove(listener);
    }

    @Override
    public List<ProducerConfigurationChangeListener> getChangeListeners() {
        return this.listeners;
    }

    @Override
    public void setRegistrationRequirements(ProducerRegistrationRequirements requirements) {
        if (this.modifyNowIfNeeded(this.requirements, requirements)) {
            this.requirements = requirements;
        }
    }

    @Override
    public CookieProtocol getRequiresInitCookie() {
        return this.requiresInitCookie;
    }

    @Override
    public void setRequiresInitCookie(CookieProtocol requiresInitCookie) {
        if (this.modifyNowIfNeeded(this.requiresInitCookie, requiresInitCookie)) {
            this.requiresInitCookie = requiresInitCookie;
        }
    }

    @Override
    public int getSessionExpirationTime() {
        return this.sessionExpirationTime;
    }

    @Override
    public void setSessionExpirationTime(int sessionExpirationTime) {
        if (this.modifyNowIfNeeded(this.sessionExpirationTime, sessionExpirationTime)) {
            this.sessionExpirationTime = sessionExpirationTime;
        }
    }

    @Override
    public long getLastModified() {
        long original = super.getLastModified();
        long requirementsLastModified = this.requirements.getLastModified();
        if (requirementsLastModified > original) {
            this.setLastModified(requirementsLastModified);
        }
        return super.getLastModified();
    }
}

