/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.wsrp.producer.config.impl;

import com.google.common.base.Function;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.QName;
import org.gatein.common.util.ParameterValidation;
import org.gatein.registration.RegistrationPolicy;
import org.gatein.registration.RegistrationPolicyChangeListener;
import org.gatein.registration.RegistrationPropertyChangeListener;
import org.gatein.registration.policies.DefaultRegistrationPolicy;
import org.gatein.registration.policies.DefaultRegistrationPropertyValidator;
import org.gatein.registration.policies.RegistrationPolicyWrapper;
import org.gatein.registration.policies.RegistrationPropertyValidator;
import org.gatein.wsrp.SupportsLastModified;
import org.gatein.wsrp.WSRPConstants;
import org.gatein.wsrp.api.plugins.PluginsAccess;
import org.gatein.wsrp.producer.config.ProducerRegistrationRequirements;
import org.gatein.wsrp.registration.RegistrationPropertyDescription;
import org.gatein.wsrp.registration.ValueChangeListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProducerRegistrationRequirementsImpl
extends SupportsLastModified
implements ProducerRegistrationRequirements {
    private static final Logger log = LoggerFactory.getLogger(ProducerRegistrationRequirementsImpl.class);
    public static final Function<Class<? extends RegistrationPolicy>, String> CLASS_TO_NAME_FUNCTION = new Function<Class<? extends RegistrationPolicy>, String>(){

        public String apply(Class<? extends RegistrationPolicy> aClass) {
            return aClass.getSimpleName();
        }
    };
    private boolean requiresRegistration;
    private boolean fullServiceDescriptionRequiresRegistration;
    private transient RegistrationPolicy policy;
    private String policyClassName;
    private String validatorClassName;
    private Map<QName, RegistrationPropertyDescription> registrationProperties;
    private Set<RegistrationPropertyChangeListener> propertyChangeListeners = new HashSet<RegistrationPropertyChangeListener>(3);
    private Set<RegistrationPolicyChangeListener> policyChangeListeners = new HashSet<RegistrationPolicyChangeListener>(3);

    public ProducerRegistrationRequirementsImpl(boolean requiresMarshalling, boolean requiresRegistration, boolean fullServiceDescriptionRequiresRegistration) {
        this();
        this.requiresRegistration = requiresRegistration;
        this.fullServiceDescriptionRequiresRegistration = fullServiceDescriptionRequiresRegistration;
        this.modifyNow();
    }

    public ProducerRegistrationRequirementsImpl() {
        this.registrationProperties = new HashMap<QName, RegistrationPropertyDescription>(7);
        this.setPolicy(new DefaultRegistrationPolicy());
    }

    public ProducerRegistrationRequirementsImpl(ProducerRegistrationRequirements other) {
        this(false, other.isRegistrationRequired(), other.isRegistrationRequiredForFullDescription());
        this.setPolicy(other.getPolicy());
        Set<Map.Entry<QName, RegistrationPropertyDescription>> otherProps = other.getRegistrationProperties().entrySet();
        this.registrationProperties = new HashMap<QName, RegistrationPropertyDescription>(otherProps.size());
        for (Map.Entry<QName, RegistrationPropertyDescription> entry : otherProps) {
            this.registrationProperties.put(entry.getKey(), new RegistrationPropertyDescription(entry.getValue()));
        }
        this.setLastModified(other.getLastModified());
    }

    @Override
    public void setRegistrationProperties(Collection<RegistrationPropertyDescription> regProps) {
        HashSet<RegistrationPropertyDescription> newProps;
        HashSet<RegistrationPropertyDescription> original = new HashSet<RegistrationPropertyDescription>(this.registrationProperties.values());
        if (this.modifyNowIfNeeded(original, newProps = new HashSet<RegistrationPropertyDescription>(regProps))) {
            this.registrationProperties.clear();
            for (RegistrationPropertyDescription propertyDescription : regProps) {
                this.addRegistrationProperty(new RegistrationPropertyDescription(propertyDescription));
            }
            this.notifyRegistrationPropertyChangeListeners();
        }
    }

    @Override
    public boolean isRegistrationRequired() {
        return this.requiresRegistration;
    }

    @Override
    public void setRegistrationRequired(boolean requiresRegistration) {
        if (this.modifyNowIfNeeded(this.requiresRegistration, requiresRegistration)) {
            if (this.requiresRegistration && !requiresRegistration) {
                this.clearRegistrationProperties();
            }
            this.requiresRegistration = requiresRegistration;
        }
    }

    @Override
    public boolean isRegistrationRequiredForFullDescription() {
        return this.fullServiceDescriptionRequiresRegistration;
    }

    @Override
    public void setRegistrationRequiredForFullDescription(boolean fullServiceDescriptionRequiresRegistration) {
        if (this.modifyNowIfNeeded(this.fullServiceDescriptionRequiresRegistration, fullServiceDescriptionRequiresRegistration)) {
            this.fullServiceDescriptionRequiresRegistration = fullServiceDescriptionRequiresRegistration;
        }
    }

    @Override
    public Map<QName, RegistrationPropertyDescription> getRegistrationProperties() {
        return Collections.unmodifiableMap(this.registrationProperties);
    }

    @Override
    public void addRegistrationProperty(RegistrationPropertyDescription propertyDescription) {
        ParameterValidation.throwIllegalArgExceptionIfNull((Object)propertyDescription, (String)"PropertyDescription");
        QName name = propertyDescription.getName();
        ParameterValidation.throwIllegalArgExceptionIfNull((Object)name, (String)"Property name");
        RegistrationPropertyDescription old = this.registrationProperties.put(name, propertyDescription);
        if (this.modifyNowIfNeeded(old, propertyDescription)) {
            propertyDescription.setValueChangeListener((ValueChangeListener)this);
            this.notifyRegistrationPropertyChangeListeners();
        }
    }

    @Override
    public RegistrationPropertyDescription addEmptyRegistrationProperty(String name) {
        ParameterValidation.throwIllegalArgExceptionIfNull((Object)name, (String)"Property name");
        RegistrationPropertyDescription reg = new RegistrationPropertyDescription(name, WSRPConstants.XSD_STRING);
        this.addRegistrationProperty(reg);
        return reg;
    }

    @Override
    public boolean acceptValueFor(QName propertyName, Object value) {
        ParameterValidation.throwIllegalArgExceptionIfNull((Object)propertyName, (String)"Property name");
        return true;
    }

    @Override
    public boolean acceptValueFor(String propertyName, Object value) {
        return this.acceptValueFor(QName.valueOf(propertyName), value);
    }

    @Override
    public RegistrationPropertyDescription getRegistrationPropertyWith(String name) {
        ParameterValidation.throwIllegalArgExceptionIfNullOrEmpty((String)name, (String)"Property name", null);
        return this.getRegistrationPropertyWith(QName.valueOf(name));
    }

    @Override
    public RegistrationPropertyDescription getRegistrationPropertyWith(QName name) {
        ParameterValidation.throwIllegalArgExceptionIfNull((Object)name, (String)"Property name");
        return this.registrationProperties.get(name);
    }

    private RegistrationPropertyDescription getPropertyDescription(QName propertyName) {
        RegistrationPropertyDescription description = this.registrationProperties.get(propertyName);
        if (description != null) {
            return new RegistrationPropertyDescription(description);
        }
        throw new IllegalArgumentException("Unknown property name '" + propertyName + "'");
    }

    @Override
    public RegistrationPropertyDescription removeRegistrationProperty(QName propertyName) {
        ParameterValidation.throwIllegalArgExceptionIfNull((Object)propertyName, (String)"Property name");
        RegistrationPropertyDescription prop = this.registrationProperties.remove(propertyName);
        if (this.modifyNowIfNeeded(null, prop)) {
            this.notifyRegistrationPropertyChangeListeners();
        }
        return prop;
    }

    @Override
    public void clearRegistrationProperties() {
        this.registrationProperties.clear();
        this.modifyNow();
        this.notifyRegistrationPropertyChangeListeners();
    }

    @Override
    public RegistrationPropertyDescription removeRegistrationProperty(String propertyName) {
        return this.removeRegistrationProperty(QName.valueOf(propertyName));
    }

    public void valueHasChanged(RegistrationPropertyDescription originatingProperty, Object oldValue, Object newValue, boolean isName) {
        this.modifyNow();
        this.notifyRegistrationPropertyChangeListeners();
        if (isName && oldValue instanceof QName) {
            this.propertyHasBeenRenamed(originatingProperty, (QName)oldValue);
        }
    }

    @Override
    public void notifyRegistrationPropertyChangeListeners() {
        Map<QName, RegistrationPropertyDescription> newRegistrationProperties = Collections.unmodifiableMap(this.registrationProperties);
        for (RegistrationPropertyChangeListener listener : this.propertyChangeListeners) {
            listener.propertiesHaveChanged(newRegistrationProperties);
        }
    }

    @Override
    public void clearRegistrationPropertyChangeListeners() {
        this.propertyChangeListeners.clear();
    }

    @Override
    public void addRegistrationPropertyChangeListener(RegistrationPropertyChangeListener listener) {
        ParameterValidation.throwIllegalArgExceptionIfNull((Object)listener, (String)"RegistrationPropertyChangeListener");
        this.propertyChangeListeners.add(listener);
    }

    @Override
    public void removeRegistrationPropertyChangeListener(RegistrationPropertyChangeListener listener) {
        ParameterValidation.throwIllegalArgExceptionIfNull((Object)listener, (String)"RegistrationPropertyChangeListener");
        this.propertyChangeListeners.remove(listener);
    }

    @Override
    public Set<RegistrationPropertyChangeListener> getPropertyChangeListeners() {
        return this.propertyChangeListeners;
    }

    @Override
    public void addRegistrationPolicyChangeListener(RegistrationPolicyChangeListener listener) {
        ParameterValidation.throwIllegalArgExceptionIfNull((Object)listener, (String)"RegistrationPolicyChangeListener");
        this.policyChangeListeners.add(listener);
    }

    @Override
    public void removeRegistrationPolicyChangeListener(RegistrationPolicyChangeListener listener) {
        ParameterValidation.throwIllegalArgExceptionIfNull((Object)listener, (String)"RegistrationPolicyChangeListener");
        this.policyChangeListeners.remove(listener);
    }

    @Override
    public void clearRegistrationPolicyChangeListeners() {
        this.policyChangeListeners.clear();
    }

    public void notifyRegistrationPolicyChangeListeners() {
        for (RegistrationPolicyChangeListener listener : this.policyChangeListeners) {
            listener.policyUpdatedTo(this.policy);
        }
    }

    @Override
    public Set<RegistrationPolicyChangeListener> getPolicyChangeListeners() {
        return this.policyChangeListeners;
    }

    @Override
    public void setPolicy(RegistrationPolicy policy) {
        if (this.modifyNowIfNeeded(this.policy, policy)) {
            if (policy == null) {
                log.debug("Specified RegistrationPolicy was null, using the default one instead.");
                policy = new DefaultRegistrationPolicy();
            }
            this.policy = RegistrationPolicyWrapper.wrap(policy);
            this.policyClassName = policy.getClassName();
            if ("org.gatein.registration.policies.DefaultRegistrationPolicy".equals(this.policyClassName)) {
                DefaultRegistrationPolicy registrationPolicy = (DefaultRegistrationPolicy)RegistrationPolicyWrapper.unwrap(policy);
                this.validatorClassName = registrationPolicy.getValidator().getClass().getName();
            } else {
                this.validatorClassName = null;
            }
            this.notifyRegistrationPolicyChangeListeners();
        }
    }

    @Override
    public RegistrationPolicy getPolicy() {
        this.reloadPolicyFrom(this.policyClassName, this.validatorClassName);
        return this.policy;
    }

    @Override
    public void reloadPolicyFrom(String policyClassName, String validatorClassName) {
        if (this.policy == null || this.requiresRegistration && (!this.policy.getClassName().equals(policyClassName) || this.isCurrentValidatorClassDifferentFrom(validatorClassName))) {
            if (policyClassName != null && !"org.gatein.registration.policies.DefaultRegistrationPolicy".equals(policyClassName)) {
                log.debug("Trying to use registration policy: " + policyClassName);
                this.setPolicy((RegistrationPolicy)PluginsAccess.getPlugins().createPluginInstance(policyClassName, RegistrationPolicy.class));
            } else {
                RegistrationPropertyValidator validator;
                log.debug("Using default registration policy: org.gatein.registration.policies.DefaultRegistrationPolicy");
                if (validatorClassName != null && validatorClassName.length() > 0 && !"org.gatein.registration.policies.DefaultRegistrationPropertyValidator".equals(validatorClassName)) {
                    log.debug("Trying to use registration property validator: " + validatorClassName);
                    validator = (RegistrationPropertyValidator)PluginsAccess.getPlugins().createPluginInstance(validatorClassName, RegistrationPropertyValidator.class);
                } else {
                    log.debug("Using default registration property validator: org.gatein.registration.policies.DefaultRegistrationPropertyValidator");
                    validator = new DefaultRegistrationPropertyValidator();
                }
                DefaultRegistrationPolicy delegate = new DefaultRegistrationPolicy();
                delegate.setValidator(validator);
                this.setPolicy(delegate);
            }
            this.modifyNow();
        }
    }

    @Override
    public List<String> getAvailableRegistrationPolicies() {
        return PluginsAccess.getPlugins().getPluginImplementationNames(RegistrationPolicy.class, "org.gatein.registration.policies.DefaultRegistrationPolicy");
    }

    @Override
    public List<String> getAvailableRegistrationPropertyValidators() {
        return PluginsAccess.getPlugins().getPluginImplementationNames(RegistrationPropertyValidator.class, "org.gatein.registration.policies.DefaultRegistrationPropertyValidator");
    }

    private boolean isCurrentValidatorClassDifferentFrom(String validatorClassName) {
        return this.policy instanceof DefaultRegistrationPolicy && !((DefaultRegistrationPolicy)this.policy).getValidator().getClass().getCanonicalName().equals(validatorClassName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void propertyHasBeenRenamed(RegistrationPropertyDescription propertyDescription, QName oldName) {
        ParameterValidation.throwIllegalArgExceptionIfNull((Object)propertyDescription, (String)"RegistrationPropertyDescription");
        ParameterValidation.throwIllegalArgExceptionIfNull((Object)oldName, (String)"property old name");
        if (this.registrationProperties.containsKey(oldName)) {
            ProducerRegistrationRequirementsImpl producerRegistrationRequirementsImpl = this;
            synchronized (producerRegistrationRequirementsImpl) {
                this.registrationProperties.remove(oldName);
                this.registrationProperties.put(propertyDescription.getName(), propertyDescription);
                this.modifyNow();
            }
        }
    }

    public void setPolicyClassName(String policyClassName) {
        this.policyClassName = policyClassName;
        this.setValidatorClassName(null);
    }

    @Override
    public String getPolicyClassName() {
        if (this.policyClassName == null) {
            return "org.gatein.registration.policies.DefaultRegistrationPolicy";
        }
        return this.policyClassName;
    }

    public void setValidatorClassName(String validatorClassName) {
        this.validatorClassName = validatorClassName;
    }

    public String getValidatorClassName() {
        return this.validatorClassName;
    }
}

