/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.wsrp.producer.config.impl.xml;

import java.util.Locale;
import javax.xml.namespace.QName;
import org.gatein.registration.RegistrationPolicy;
import org.gatein.registration.policies.DefaultRegistrationPolicy;
import org.gatein.registration.policies.RegistrationPolicyWrapper;
import org.gatein.wsrp.WSRPUtils;
import org.gatein.wsrp.producer.config.ProducerRegistrationRequirements;
import org.gatein.wsrp.producer.config.impl.ProducerConfigurationImpl;
import org.gatein.wsrp.producer.config.impl.ProducerRegistrationRequirementsImpl;
import org.gatein.wsrp.registration.LocalizedString;
import org.gatein.wsrp.registration.RegistrationPropertyDescription;
import org.jboss.xb.binding.MarshallingContext;
import org.jboss.xb.binding.ObjectModelProvider;

public class ProducerConfigurationProvider
implements ObjectModelProvider {
    public Object getRoot(Object o, MarshallingContext marshallingContext, String s, String s1) {
        return o;
    }

    public Object getChildren(ProducerConfigurationImpl configuration, String namespaceUri, String localName) {
        if ("registration-configuration".equals(localName)) {
            ProducerRegistrationRequirements registrationRequirements = configuration.getRegistrationRequirements();
            if (registrationRequirements != null && registrationRequirements.isRegistrationRequired()) {
                return registrationRequirements;
            }
        } else if ("producer-configuration".equals(localName)) {
            return configuration;
        }
        return null;
    }

    public Object getChildren(ProducerRegistrationRequirementsImpl regReq, String namespaceUri, String localName) {
        if ("registration-property-description".equals(localName)) {
            return regReq.getRegistrationProperties().values();
        }
        return null;
    }

    public Object getAttributeValue(ProducerConfigurationImpl configuration, String namespaceUri, String localName) {
        if ("useStrictMode".equals(localName)) {
            return configuration.isUsingStrictMode();
        }
        return null;
    }

    public Object getAttributeValue(ProducerRegistrationRequirementsImpl regReq, String namespaceUri, String localName) {
        if ("fullServiceDescriptionRequiresRegistration".equals(localName)) {
            return regReq.isRegistrationRequiredForFullDescription();
        }
        return null;
    }

    public Object getElementValue(ProducerRegistrationRequirementsImpl regReq, String namespaceUri, String localName) {
        String value = null;
        if ("registration-policy".equals(localName)) {
            RegistrationPolicy policy = regReq.getPolicy();
            if (policy != null) {
                value = policy.getClassName();
            }
        } else if ("registration-property-validator".equals(localName)) {
            RegistrationPolicy policy = RegistrationPolicyWrapper.unwrap(regReq.getPolicy());
            if (policy instanceof DefaultRegistrationPolicy) {
                DefaultRegistrationPolicy defaultRegistrationPolicy = (DefaultRegistrationPolicy)policy;
                value = defaultRegistrationPolicy.getValidator().getClass().getName();
            }
        } else {
            value = null;
        }
        return value;
    }

    public Object getElementValue(RegistrationPropertyDescription propertyDescription, String namespaceUri, String localName) {
        QName value = null;
        if ("name".equals(localName)) {
            value = propertyDescription.getName();
        } else if ("type".equals(localName)) {
            value = propertyDescription.getType();
        } else if ("label".equals(localName)) {
            value = this.getLocalizedStringOrNull(propertyDescription.getLabel());
        } else if ("hint".equals(localName)) {
            value = this.getLocalizedStringOrNull(propertyDescription.getHint());
        } else if ("description".equals(localName)) {
            value = this.getLocalizedStringOrNull(propertyDescription.getDescription());
        }
        return value;
    }

    private LocalizedString getLocalizedStringOrNull(LocalizedString string) {
        if (string != null) {
            String value = string.getValue();
            if (value == null || value.length() == 0) {
                return null;
            }
            return string;
        }
        return null;
    }

    public Object getAttributeValue(LocalizedString localizedString, String namespaceUri, String localName) {
        String value = null;
        if ("lang".equals(localName)) {
            value = WSRPUtils.toString((Locale)localizedString.getLocale());
        } else if ("resourceName".equals(localName)) {
            value = localizedString.getResourceName();
        }
        return value;
    }

    public Object getElementValue(LocalizedString localizedString, String namespaceUri, String localName) {
        return localizedString.getValue();
    }
}

