/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.wsrp.producer.config.impl.xml;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import javax.xml.parsers.ParserConfigurationException;
import org.gatein.wsrp.producer.config.ProducerConfiguration;
import org.gatein.wsrp.producer.config.impl.AbstractProducerConfigurationService;
import org.gatein.wsrp.producer.config.impl.ProducerConfigurationImpl;
import org.gatein.wsrp.producer.config.impl.xml.ProducerConfigurationFactory;
import org.gatein.wsrp.producer.config.impl.xml.ProducerConfigurationProvider;
import org.jboss.xb.binding.ObjectModelFactory;
import org.jboss.xb.binding.ObjectModelProvider;
import org.jboss.xb.binding.Unmarshaller;
import org.jboss.xb.binding.UnmarshallerFactory;
import org.jboss.xb.binding.XercesXsMarshaller;
import org.jboss.xb.binding.sunday.unmarshalling.DefaultSchemaResolver;
import org.jboss.xb.binding.sunday.unmarshalling.SchemaBindingResolver;
import org.xml.sax.SAXException;

public class SimpleXMLProducerConfigurationService
extends AbstractProducerConfigurationService {
    protected static final String PRODUCER_NAMESPACE = "http://www.gatein.org/xml/ns/gatein_wsrp_producer_1_0";
    protected static final String PRODUCER_XSD = "gatein_wsrp_producer_1_0.xsd";
    protected static DefaultSchemaResolver RESOLVER = new DefaultSchemaResolver();
    protected InputStream inputStream;
    private static File tmp;

    public SimpleXMLProducerConfigurationService() {
    }

    public SimpleXMLProducerConfigurationService(InputStream inputStream) {
        this.inputStream = inputStream;
    }

    public void setInputStream(InputStream inputStream) {
        this.inputStream = inputStream;
    }

    @Override
    public void loadConfiguration() throws Exception {
        if (this.inputStream != null) {
            Unmarshaller unmarshaller = UnmarshallerFactory.newInstance().newUnmarshaller();
            ProducerConfigurationFactory factory = new ProducerConfigurationFactory();
            this.configuration.set((ProducerConfiguration)unmarshaller.unmarshal(this.inputStream, (ObjectModelFactory)factory, null));
        }
        this.configuration.compareAndSet(null, new ProducerConfigurationImpl());
    }

    @Override
    public void saveConfiguration() throws Exception {
        this.saveConfigurationTo(tmp);
    }

    public URL getConfigurationURL() {
        try {
            return tmp.toURI().toURL();
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }

    protected void saveConfigurationTo(File config) throws IOException, SAXException, ParserConfigurationException {
        StringWriter xmlOutput = new StringWriter();
        InputStream is = Thread.currentThread().getContextClassLoader().getResourceAsStream("xsd/gatein_wsrp_producer_1_0.xsd");
        InputStreamReader xsReader = new InputStreamReader(is);
        XercesXsMarshaller marshaller = new XercesXsMarshaller();
        marshaller.setSchemaResolver((SchemaBindingResolver)RESOLVER);
        marshaller.addRootElement(PRODUCER_NAMESPACE, "", "producer-configuration");
        marshaller.declareNamespace("wpc", PRODUCER_NAMESPACE);
        marshaller.declareNamespace("xsi", "http://www.w3.org/2001/XMLSchema-instance");
        marshaller.addAttribute("xsi", "schemaLocation", "string", "http://www.gatein.org/xml/ns/gatein_wsrp_producer_1_0 http://www.jboss.org/portal/xsd/gatein_wsrp_producer_1_0.xsd");
        ProducerConfigurationProvider provider = new ProducerConfigurationProvider();
        marshaller.setProperty("org.jboss.xml.binding.marshalling.indent", "true");
        marshaller.marshal((Reader)xsReader, (ObjectModelProvider)provider, (Object)this.configuration, (Writer)xmlOutput);
        ((Reader)xsReader).close();
        config.createNewFile();
        BufferedWriter configFile = new BufferedWriter(new FileWriter(config));
        configFile.write(xmlOutput.toString());
        ((Writer)configFile).flush();
        ((Writer)configFile).close();
    }

    static {
        RESOLVER.setCacheResolvedSchemas(true);
        RESOLVER.addSchemaLocation("http://www.w3.org/XML/1998/namespace", "xsd/xml.xsd");
        RESOLVER.addSchemaLocation(PRODUCER_NAMESPACE, "xsd/gatein_wsrp_producer_1_0.xsd");
        try {
            tmp = File.createTempFile("producer-configuration", "xml");
            tmp.deleteOnExit();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

