/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.wsrp.producer.handlers;

import java.util.Collections;
import java.util.List;
import javax.portlet.PortletModeException;
import javax.portlet.WindowStateException;
import org.gatein.pc.api.PortletInvokerException;
import org.gatein.pc.api.invocation.PortletInvocation;
import org.gatein.pc.api.invocation.response.ContentResponse;
import org.gatein.pc.api.invocation.response.ErrorResponse;
import org.gatein.pc.api.invocation.response.FragmentResponse;
import org.gatein.pc.api.invocation.response.HTTPRedirectionResponse;
import org.gatein.pc.api.invocation.response.PortletInvocationResponse;
import org.gatein.pc.api.invocation.response.UpdateNavigationalStateResponse;
import org.gatein.pc.portlet.state.producer.PortletStateChangeRequiredException;
import org.gatein.registration.Registration;
import org.gatein.registration.RegistrationLocal;
import org.gatein.wsrp.api.extensions.InvocationHandlerDelegate;
import org.gatein.wsrp.api.servlet.ServletAccess;
import org.gatein.wsrp.producer.MarkupInterface;
import org.gatein.wsrp.producer.Utils;
import org.gatein.wsrp.producer.WSRPProducerImpl;
import org.gatein.wsrp.producer.handlers.ServiceHandler;
import org.gatein.wsrp.producer.handlers.processors.ProcessorFactory;
import org.gatein.wsrp.producer.handlers.processors.RequestProcessor;
import org.gatein.wsrp.spec.v2.WSRP2ExceptionFactory;
import org.oasis.wsrp.v2.AccessDenied;
import org.oasis.wsrp.v2.BlockingInteractionResponse;
import org.oasis.wsrp.v2.Extension;
import org.oasis.wsrp.v2.GetMarkup;
import org.oasis.wsrp.v2.GetResource;
import org.oasis.wsrp.v2.HandleEvents;
import org.oasis.wsrp.v2.HandleEventsResponse;
import org.oasis.wsrp.v2.InconsistentParameters;
import org.oasis.wsrp.v2.InitCookie;
import org.oasis.wsrp.v2.InvalidCookie;
import org.oasis.wsrp.v2.InvalidHandle;
import org.oasis.wsrp.v2.InvalidRegistration;
import org.oasis.wsrp.v2.InvalidSession;
import org.oasis.wsrp.v2.InvalidUserCategory;
import org.oasis.wsrp.v2.MarkupResponse;
import org.oasis.wsrp.v2.MissingParameters;
import org.oasis.wsrp.v2.ModifyRegistrationRequired;
import org.oasis.wsrp.v2.OperationFailed;
import org.oasis.wsrp.v2.OperationNotSupported;
import org.oasis.wsrp.v2.PerformBlockingInteraction;
import org.oasis.wsrp.v2.PortletStateChangeRequired;
import org.oasis.wsrp.v2.ReleaseSessions;
import org.oasis.wsrp.v2.ResourceResponse;
import org.oasis.wsrp.v2.ResourceSuspended;
import org.oasis.wsrp.v2.UnsupportedLocale;
import org.oasis.wsrp.v2.UnsupportedMimeType;
import org.oasis.wsrp.v2.UnsupportedMode;
import org.oasis.wsrp.v2.UnsupportedWindowState;

public class MarkupHandler
extends ServiceHandler
implements MarkupInterface {
    public MarkupHandler(WSRPProducerImpl producer) {
        super(producer);
    }

    @Override
    public MarkupResponse getMarkup(GetMarkup getMarkup) throws AccessDenied, InconsistentParameters, InvalidCookie, InvalidHandle, InvalidRegistration, InvalidSession, InvalidUserCategory, MissingParameters, ModifyRegistrationRequired, OperationFailed, ResourceSuspended, UnsupportedLocale, UnsupportedMimeType, UnsupportedMode, UnsupportedWindowState {
        try {
            return (MarkupResponse)this.invoke(getMarkup);
        }
        catch (PortletStateChangeRequired portletStateChangeRequired) {
            throw (OperationFailed)WSRP2ExceptionFactory.throwWSException(OperationFailed.class, (String)"Shouldn't happen", (Throwable)portletStateChangeRequired);
        }
        catch (OperationNotSupported operationNotSupported) {
            throw (OperationFailed)WSRP2ExceptionFactory.throwWSException(OperationFailed.class, (String)"Shouldn't happen", (Throwable)operationNotSupported);
        }
    }

    @Override
    public ResourceResponse getResource(GetResource getResource) throws AccessDenied, InconsistentParameters, InvalidCookie, InvalidHandle, InvalidRegistration, InvalidSession, InvalidUserCategory, MissingParameters, ModifyRegistrationRequired, OperationFailed, OperationNotSupported, ResourceSuspended, UnsupportedLocale, UnsupportedMimeType, UnsupportedMode, UnsupportedWindowState {
        try {
            return (ResourceResponse)this.invoke(getResource);
        }
        catch (PortletStateChangeRequired portletStateChangeRequired) {
            throw (OperationFailed)WSRP2ExceptionFactory.throwWSException(OperationFailed.class, (String)"Shouldn't happen", (Throwable)portletStateChangeRequired);
        }
    }

    @Override
    public BlockingInteractionResponse performBlockingInteraction(PerformBlockingInteraction performBlockingInteraction) throws AccessDenied, InconsistentParameters, InvalidCookie, InvalidHandle, InvalidRegistration, InvalidSession, InvalidUserCategory, MissingParameters, ModifyRegistrationRequired, OperationFailed, PortletStateChangeRequired, ResourceSuspended, UnsupportedLocale, UnsupportedMimeType, UnsupportedMode, UnsupportedWindowState {
        try {
            return (BlockingInteractionResponse)this.invoke(performBlockingInteraction);
        }
        catch (OperationNotSupported operationNotSupported) {
            throw (OperationFailed)WSRP2ExceptionFactory.throwWSException(OperationFailed.class, (String)"Shouldn't happen", (Throwable)operationNotSupported);
        }
    }

    @Override
    public List<Extension> releaseSessions(ReleaseSessions releaseSessions) throws AccessDenied, InvalidRegistration, MissingParameters, ModifyRegistrationRequired, OperationFailed, OperationNotSupported, ResourceSuspended {
        Utils.throwOperationFaultOnSessionOperation();
        return null;
    }

    @Override
    public List<Extension> initCookie(InitCookie initCookie) throws AccessDenied, InvalidRegistration, ModifyRegistrationRequired, OperationFailed, OperationNotSupported, ResourceSuspended {
        WSRP2ExceptionFactory.throwOperationFailedIfValueIsMissing((Object)initCookie, (String)"InitCookie");
        this.producer.getRegistrationOrFailIfInvalid(initCookie.getRegistrationContext());
        String sessionId = ServletAccess.getRequest().getSession().getId();
        log.debug("Got init cookie operation, created a session with id " + sessionId);
        return Collections.emptyList();
    }

    @Override
    public HandleEventsResponse handleEvents(HandleEvents handleEvents) throws AccessDenied, InconsistentParameters, InvalidCookie, InvalidHandle, InvalidRegistration, InvalidSession, InvalidUserCategory, MissingParameters, ModifyRegistrationRequired, OperationFailed, OperationNotSupported, PortletStateChangeRequired, ResourceSuspended, UnsupportedLocale, UnsupportedMimeType, UnsupportedMode, UnsupportedWindowState {
        return (HandleEventsResponse)this.invoke(handleEvents);
    }

    private <Request, Response> Response invoke(Request request) throws OperationFailed, ModifyRegistrationRequired, InvalidRegistration, UnsupportedMimeType, MissingParameters, UnsupportedLocale, InvalidHandle, UnsupportedWindowState, UnsupportedMode, PortletStateChangeRequired, OperationNotSupported {
        PortletInvocationResponse response;
        RequestProcessor requestProcessor = ProcessorFactory.getProcessorFor(this.producer, request);
        String handle = requestProcessor.getPortletContext().getPortletHandle();
        String invocationType = request.getClass().getSimpleName();
        try {
            log.debug(invocationType + " on portlet '" + handle + "'");
            Registration registration = this.producer.getRegistrationOrFailIfInvalid(requestProcessor.getRegistrationContext());
            RegistrationLocal.setRegistration(registration);
            PortletInvocation invocation = requestProcessor.getInvocation();
            InvocationHandlerDelegate delegate = InvocationHandlerDelegate.producerDelegate();
            if (delegate != null) {
                delegate.processInvocation(invocation);
            }
            response = this.producer.getPortletInvoker().invoke(invocation);
            if (delegate != null) {
                delegate.processInvocationResponse(response, invocation);
            }
            log.debug(invocationType + " done");
        }
        catch (PortletStateChangeRequiredException e) {
            throw (PortletStateChangeRequired)((Object)WSRP2ExceptionFactory.throwWSException(PortletStateChangeRequired.class, (String)e.getLocalizedMessage(), (Throwable)e));
        }
        catch (PortletInvokerException e) {
            throw (OperationFailed)WSRP2ExceptionFactory.throwWSException(OperationFailed.class, (String)("Could not perform " + invocationType + " on portlet '" + handle + "'"), (Throwable)e);
        }
        this.checkForError(response);
        return requestProcessor.processResponse(response);
    }

    private void checkForError(PortletInvocationResponse response) throws UnsupportedMode, OperationFailed, UnsupportedWindowState {
        if (response instanceof ErrorResponse) {
            ErrorResponse errorResult = (ErrorResponse)response;
            Throwable cause = errorResult.getCause();
            if (cause instanceof PortletModeException) {
                throw (UnsupportedMode)WSRP2ExceptionFactory.throwWSException(UnsupportedMode.class, (String)("Unsupported mode: " + ((PortletModeException)cause).getMode()), null);
            }
            if (cause instanceof WindowStateException) {
                throw (UnsupportedWindowState)WSRP2ExceptionFactory.throwWSException(UnsupportedWindowState.class, (String)("Unsupported window state: " + ((WindowStateException)cause).getState()), null);
            }
            throw (OperationFailed)WSRP2ExceptionFactory.throwWSException(OperationFailed.class, (String)errorResult.getMessage(), (Throwable)cause);
        }
        if (!(response instanceof HTTPRedirectionResponse || response instanceof FragmentResponse || response instanceof UpdateNavigationalStateResponse || response instanceof ContentResponse)) {
            throw (OperationFailed)WSRP2ExceptionFactory.throwWSException(OperationFailed.class, (String)("Unsupported result type: " + response.getClass().getName()), null);
        }
    }
}

