/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.wsrp.producer.handlers.processors;

import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import org.gatein.pc.api.Mode;
import org.gatein.pc.api.Portlet;
import org.gatein.pc.api.WindowState;
import org.gatein.wsrp.WSRPUtils;
import org.oasis.wsrp.v2.MarkupType;

class MarkupRequest {
    private String mode;
    private String windowState;
    private MarkupType markupType;
    private String characterSet;
    private Portlet portlet;
    private static final String CHARSET_SEPARATOR = "; charset=";

    public MarkupRequest(MarkupType markupType, String mode, String windowState, String characterSet, Portlet portlet) {
        this.characterSet = characterSet;
        this.markupType = markupType;
        this.mode = mode;
        this.windowState = windowState;
        this.portlet = portlet;
    }

    public String getMediaTypeWithCharset() {
        return this.getMediaType() + CHARSET_SEPARATOR + this.getCharacterSet();
    }

    public String getMediaType() {
        return this.markupType.getMimeType();
    }

    public String getLocale() {
        List locales = this.markupType.getLocales();
        if (locales != null && !locales.isEmpty()) {
            return (String)locales.get(0);
        }
        return WSRPUtils.toString((Locale)Locale.ENGLISH);
    }

    public String getMode() {
        return this.mode;
    }

    public String getWindowState() {
        return this.windowState;
    }

    public MarkupType getMarkupType() {
        return this.markupType;
    }

    public String getCharacterSet() {
        return this.characterSet;
    }

    public Portlet getPortlet() {
        return this.portlet;
    }

    public Set<Mode> getSupportedModes() {
        List modes = this.markupType.getModes();
        HashSet<Mode> result = new HashSet<Mode>(modes.size());
        for (String mode : modes) {
            result.add(WSRPUtils.getJSR168PortletModeFromWSRPName((String)mode));
        }
        return result;
    }

    public Set<WindowState> getSupportedWindowStates() {
        List states = this.markupType.getWindowStates();
        HashSet<WindowState> result = new HashSet<WindowState>(states.size());
        for (String state : states) {
            result.add(WSRPUtils.getJSR168WindowStateFromWSRPName((String)state));
        }
        return result;
    }
}

