/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.wsrp.producer.handlers.processors;

import java.util.List;
import org.gatein.common.net.URLTools;
import org.gatein.common.util.MultiValuedPropertyMap;
import org.gatein.common.util.ParameterValidation;
import org.gatein.pc.api.invocation.PortletInvocation;
import org.gatein.pc.api.invocation.response.ContentResponse;
import org.gatein.pc.api.invocation.response.PortletInvocationResponse;
import org.gatein.pc.api.invocation.response.ResponseProperties;
import org.gatein.wsrp.MIMEUtils;
import org.gatein.wsrp.WSRPTypeFactory;
import org.gatein.wsrp.WSRPUtils;
import org.gatein.wsrp.api.servlet.ServletAccess;
import org.gatein.wsrp.payload.PayloadUtils;
import org.gatein.wsrp.producer.handlers.processors.ProducerHelper;
import org.gatein.wsrp.producer.handlers.processors.RequestProcessor;
import org.gatein.wsrp.producer.handlers.processors.WSRPPortletInvocationContext;
import org.oasis.wsrp.v2.InvalidHandle;
import org.oasis.wsrp.v2.InvalidRegistration;
import org.oasis.wsrp.v2.MimeResponse;
import org.oasis.wsrp.v2.MissingParameters;
import org.oasis.wsrp.v2.ModifyRegistrationRequired;
import org.oasis.wsrp.v2.OperationFailed;
import org.oasis.wsrp.v2.OperationNotSupported;
import org.oasis.wsrp.v2.UnsupportedLocale;
import org.oasis.wsrp.v2.UnsupportedMimeType;
import org.oasis.wsrp.v2.UnsupportedMode;
import org.oasis.wsrp.v2.UnsupportedWindowState;
import org.w3c.dom.Element;

abstract class MimeResponseProcessor<Request, LocalMimeResponse extends MimeResponse, Response>
extends RequestProcessor<Request, Response> {
    private static final String EMPTY = "";

    protected MimeResponseProcessor(ProducerHelper producer, Request request) throws InvalidRegistration, InvalidHandle, UnsupportedLocale, UnsupportedMimeType, UnsupportedWindowState, OperationFailed, MissingParameters, UnsupportedMode, ModifyRegistrationRequired, OperationNotSupported {
        super(producer, request);
    }

    @Override
    PortletInvocation initInvocation(WSRPPortletInvocationContext context) {
        return this.internalInitInvocation(context);
    }

    protected String processFragmentString(String renderString) {
        if (!ParameterValidation.isNullOrEmpty((String)renderString) && WSRPUtils.getPropertyAccessor().isURLRewritingActive()) {
            return URLTools.replaceURLsBy((String)renderString, (URLTools.URLReplacementGenerator)new WSRPUtils.AbsoluteURLReplacementGenerator(ServletAccess.getRequest()));
        }
        return renderString;
    }

    @Override
    protected Response internalProcessResponse(PortletInvocationResponse response) {
        ResponseProperties properties;
        ContentResponse content = (ContentResponse)response;
        String itemString = null;
        byte[] itemBinary = null;
        String contentType = content.getContentType();
        Boolean requiresRewriting = Boolean.FALSE;
        switch (content.getType()) {
            case 1: {
                itemString = this.processFragmentString(content.getChars());
                requiresRewriting = Boolean.TRUE;
                break;
            }
            case 2: {
                itemBinary = content.getBytes();
                if (!MIMEUtils.needsRewriting((String)contentType)) break;
                requiresRewriting = Boolean.TRUE;
                break;
            }
            case 0: {
                itemString = EMPTY;
                contentType = this.markupRequest.getMediaType();
            }
        }
        MimeResponse mimeResponse = WSRPTypeFactory.createMimeResponse((String)contentType, (String)itemString, (byte[])itemBinary, this.getReifiedClass());
        mimeResponse.setLocale(this.markupRequest.getLocale());
        Boolean useCachedItem = false;
        mimeResponse.setRequiresRewriting(requiresRewriting);
        mimeResponse.setUseCachedItem(useCachedItem);
        String ccppProfileWarning = null;
        mimeResponse.setCcppProfileWarning(ccppProfileWarning);
        int expires = content.getCacheControl().getExpirationSecs();
        if (expires != 0) {
            if (expires < 0) {
                expires = -1;
            }
            mimeResponse.setCacheControl(WSRPTypeFactory.createCacheControl((int)expires, (String)"wsrp:perUser"));
        }
        if ((properties = content.getProperties()) != null) {
            this.populateClientAttributesWith(mimeResponse, properties.getTransportHeaders());
            this.populateClientAttributesWith(mimeResponse, properties.getMarkupHeaders());
        }
        this.additionallyProcessIfNeeded(mimeResponse, response);
        return this.createResponse(mimeResponse);
    }

    private <T> void populateClientAttributesWith(LocalMimeResponse mimeResponse, MultiValuedPropertyMap<T> transportHeaders) {
        for (String key : transportHeaders.keySet()) {
            List values = transportHeaders.getValues(key);
            for (Object value : values) {
                String valueAsString;
                if (value instanceof Element) {
                    Element element = (Element)value;
                    valueAsString = PayloadUtils.outputToXML((Element)element);
                } else {
                    valueAsString = value.toString();
                }
                mimeResponse.getClientAttributes().add(WSRPTypeFactory.createNamedString((String)key, (String)valueAsString));
            }
        }
    }

    protected abstract Response createResponse(LocalMimeResponse var1);

    protected abstract Class<LocalMimeResponse> getReifiedClass();

    protected void additionallyProcessIfNeeded(LocalMimeResponse mimeResponse, PortletInvocationResponse response) {
    }

    protected abstract PortletInvocation internalInitInvocation(WSRPPortletInvocationContext var1);
}

