/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.wsrp.producer.handlers.processors;

import org.gatein.wsrp.producer.handlers.processors.ActionRequestProcessor;
import org.gatein.wsrp.producer.handlers.processors.EventRequestProcessor;
import org.gatein.wsrp.producer.handlers.processors.ProducerHelper;
import org.gatein.wsrp.producer.handlers.processors.RenderRequestProcessor;
import org.gatein.wsrp.producer.handlers.processors.RequestProcessor;
import org.gatein.wsrp.producer.handlers.processors.ResourceRequestProcessor;
import org.gatein.wsrp.spec.v2.WSRP2ExceptionFactory;
import org.oasis.wsrp.v2.GetMarkup;
import org.oasis.wsrp.v2.GetResource;
import org.oasis.wsrp.v2.HandleEvents;
import org.oasis.wsrp.v2.InvalidHandle;
import org.oasis.wsrp.v2.InvalidRegistration;
import org.oasis.wsrp.v2.MissingParameters;
import org.oasis.wsrp.v2.ModifyRegistrationRequired;
import org.oasis.wsrp.v2.OperationFailed;
import org.oasis.wsrp.v2.OperationNotSupported;
import org.oasis.wsrp.v2.PerformBlockingInteraction;
import org.oasis.wsrp.v2.UnsupportedLocale;
import org.oasis.wsrp.v2.UnsupportedMimeType;
import org.oasis.wsrp.v2.UnsupportedMode;
import org.oasis.wsrp.v2.UnsupportedWindowState;

public class ProcessorFactory {
    public static <Request, Response> RequestProcessor<Request, Response> getProcessorFor(ProducerHelper producer, Request request) throws OperationFailed, UnsupportedMode, InvalidHandle, MissingParameters, UnsupportedMimeType, UnsupportedWindowState, InvalidRegistration, ModifyRegistrationRequired, UnsupportedLocale, OperationNotSupported {
        RequestProcessor processor;
        if (request instanceof GetMarkup) {
            processor = new RenderRequestProcessor(producer, (GetMarkup)request);
        } else if (request instanceof PerformBlockingInteraction) {
            processor = new ActionRequestProcessor(producer, (PerformBlockingInteraction)request);
        } else if (request instanceof HandleEvents) {
            try {
                processor = new EventRequestProcessor(producer, (HandleEvents)request);
            }
            catch (OperationNotSupported operationNotSupported) {
                throw (OperationFailed)WSRP2ExceptionFactory.createWSException(OperationFailed.class, (String)"Couldn't initiate EventRequestProcessor", (Throwable)operationNotSupported);
            }
        } else if (request instanceof GetResource) {
            processor = new ResourceRequestProcessor(producer, (GetResource)request);
        } else {
            throw new IllegalArgumentException("Unknown request type: " + request.getClass().getSimpleName());
        }
        return processor;
    }
}

