/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.wsrp.producer.handlers.processors;

import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import org.gatein.common.util.ParameterValidation;
import org.gatein.pc.api.Mode;
import org.gatein.pc.api.PortletContext;
import org.gatein.pc.api.StateString;
import org.gatein.pc.api.invocation.response.UpdateNavigationalStateResponse;
import org.gatein.wsrp.WSRPTypeFactory;
import org.gatein.wsrp.WSRPUtils;
import org.gatein.wsrp.producer.handlers.processors.ProducerHelper;
import org.gatein.wsrp.producer.handlers.processors.RequestProcessor;
import org.oasis.wsrp.v2.InvalidHandle;
import org.oasis.wsrp.v2.InvalidRegistration;
import org.oasis.wsrp.v2.MissingParameters;
import org.oasis.wsrp.v2.ModifyRegistrationRequired;
import org.oasis.wsrp.v2.NavigationalContext;
import org.oasis.wsrp.v2.OperationFailed;
import org.oasis.wsrp.v2.OperationNotSupported;
import org.oasis.wsrp.v2.UnsupportedLocale;
import org.oasis.wsrp.v2.UnsupportedMimeType;
import org.oasis.wsrp.v2.UnsupportedMode;
import org.oasis.wsrp.v2.UnsupportedWindowState;
import org.oasis.wsrp.v2.UpdateResponse;

abstract class UpdateNavigationalStateResponseProcessor<Request, Response>
extends RequestProcessor<Request, Response> {
    public UpdateNavigationalStateResponseProcessor(ProducerHelper producer, Request request) throws InvalidRegistration, InvalidHandle, UnsupportedLocale, UnsupportedMimeType, UnsupportedWindowState, OperationFailed, MissingParameters, UnsupportedMode, ModifyRegistrationRequired, OperationNotSupported {
        super(producer, request);
    }

    protected String getNewStateOrNull(UpdateNavigationalStateResponse renderResult, boolean forMode) {
        Mode state = forMode ? renderResult.getMode() : renderResult.getWindowState();
        return state != null ? state.toString() : null;
    }

    protected UpdateResponse createUpdateResponse(UpdateNavigationalStateResponse stateResponse) {
        UpdateResponse updateResponse = WSRPTypeFactory.createUpdateResponse();
        updateResponse.setNewMode(WSRPUtils.convertJSR168PortletModeNameToWSRPName((String)this.getNewStateOrNull(stateResponse, true)));
        updateResponse.setNewWindowState(WSRPUtils.convertJSR168WindowStateNameToWSRPName((String)this.getNewStateOrNull(stateResponse, false)));
        NavigationalContext navigationalContext = WSRPTypeFactory.createNavigationalContextOrNull((StateString)stateResponse.getNavigationalState(), (Map)stateResponse.getPublicNavigationalStateUpdates());
        updateResponse.setNavigationalContext(navigationalContext);
        List events = stateResponse.getEvents();
        if (ParameterValidation.existsAndIsNotEmpty((Collection)events)) {
            for (UpdateNavigationalStateResponse.Event event : events) {
                updateResponse.getEvents().add(WSRPTypeFactory.createEvent((QName)event.getName(), (Serializable)event.getPayload()));
            }
        }
        if (this.instanceContext.wasModified()) {
            org.oasis.wsrp.v2.PortletContext updatedPortletContext = WSRPUtils.convertToWSRPPortletContext((PortletContext)this.instanceContext.getPortletContext());
            updateResponse.setPortletContext(updatedPortletContext);
        }
        return updateResponse;
    }
}

