/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.wsrp.producer.resources;

import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.gatein.common.util.ParameterValidation;
import org.gatein.wsrp.ResourceServingUtil;
import org.gatein.wsrp.producer.ProducerHolder;
import org.gatein.wsrp.producer.v2.WSRP2Producer;
import org.oasis.wsrp.v2.GetResource;
import org.oasis.wsrp.v2.ResourceContext;
import org.oasis.wsrp.v2.ResourceResponse;

public class ResourceServingServlet
extends HttpServlet {
    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        WSRP2Producer producer = ProducerHolder.getProducer();
        GetResource getResource = ResourceServingUtil.decode((HttpServletRequest)req);
        try {
            ResourceResponse resource = producer.getResource(getResource);
            ResourceContext resourceContext = resource.getResourceContext();
            byte[] itemBinary = resourceContext.getItemBinary();
            String itemString = resourceContext.getItemString();
            String mimeType = resourceContext.getMimeType();
            if (!ParameterValidation.isNullOrEmpty((String)mimeType)) {
                resp.setContentType(mimeType);
            }
            if (itemBinary != null && itemBinary.length > 0) {
                resp.getOutputStream().write(itemBinary);
            }
            if (!ParameterValidation.isNullOrEmpty((String)itemString)) {
                resp.getWriter().write(itemString);
            }
        }
        catch (Exception exception) {
            throw new ServletException("Couldn't get resource " + getResource.getResourceParams().getResourceID() + " for portlet " + getResource.getPortletContext(), (Throwable)exception);
        }
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.doGet(req, resp);
    }
}

