/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.wsrp.wss.cxf;

import java.io.File;
import java.io.FileInputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Utils {
    private static Logger log = LoggerFactory.getLogger(Utils.class);
    public static final String WS_SECURITY_CONF_DIR_NAME = "ws-security";
    public static final String CONSUMER_CONF_DIR_NAME = "consumer";
    public static final String PRODUCER_CONF_DIR_NAME = "producer";
    public static final String WSS4J_ININTERCEPTOR_PROPERTY_FILE = "WSS4JInInterceptor.properties";
    public static final String WSS4J_OUTINTERCEPTOR_PROPERTY_FILE = "WSS4JOutInterceptor.properties";

    public static Map<String, Object> getCXFConfigProperties(String path) {
        String interceptorPropertyFileName = Utils.getCXFWSSecurityConfigDir() + File.separator + path;
        try {
            HashMap<String, Object> outProperties = new HashMap<String, Object>();
            File interceptorPropertyFile = new File(interceptorPropertyFileName);
            if (interceptorPropertyFile.exists()) {
                Properties properties = new Properties();
                properties.load(new FileInputStream(interceptorPropertyFile));
                for (String propName : properties.stringPropertyNames()) {
                    outProperties.put(propName, properties.get(propName));
                }
            } else {
                log.debug("The interceptor property file (" + interceptorPropertyFileName + ") does not exist.");
                return null;
            }
            return outProperties;
        }
        catch (Exception e) {
            log.error("Exception occured trying to read the interceptor property file (" + interceptorPropertyFileName + ").", (Throwable)e);
            return null;
        }
    }

    protected static String getCXFWSSecurityConfigDir() {
        return org.gatein.wsrp.cxf.Utils.getWSRPCXFConfigDirectory() + File.separator + WS_SECURITY_CONF_DIR_NAME;
    }
}

