/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.wsrp.wss.cxf.consumer;

import java.io.File;
import java.util.Map;
import org.apache.cxf.endpoint.Client;
import org.apache.cxf.frontend.ClientProxy;
import org.apache.cxf.ws.security.wss4j.WSS4JInInterceptor;
import org.apache.cxf.ws.security.wss4j.WSS4JOutInterceptor;
import org.gatein.wci.security.Credentials;
import org.gatein.wsrp.wss.CustomizePortListener;
import org.gatein.wsrp.wss.WebServiceSecurityFactory;
import org.gatein.wsrp.wss.credentials.CredentialsAccessor;
import org.gatein.wsrp.wss.cxf.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CXFCustomizePortListener
implements CustomizePortListener {
    private static Logger log = LoggerFactory.getLogger(CXFCustomizePortListener.class);
    protected static String GTN_CURRENT_USER = "gtn.current.user";
    protected static String GTN_USERNAME_TOKEN_IF_AUTHENTICATED = "gtn.UsernameToken.ifCurrentUserAuthenticated";
    protected static String GTN_NO_USER = "gtn.no.user";

    public void customizePort(Object service) {
        log.debug("Customizing the port for the wsrp cxf client.");
        Client client = ClientProxy.getClient((Object)service);
        Map<String, Object> inPropertyMap = this.getWSS4JInInterceptorProperties();
        Map<String, Object> outPropertyMap = this.getWSS4JOutInterceptorProperties();
        if (inPropertyMap != null && this.handleSpecialProperties(inPropertyMap)) {
            WSS4JInInterceptor inInterceptor = new WSS4JInInterceptor(inPropertyMap);
            client.getInInterceptors().add(inInterceptor);
        }
        if (outPropertyMap != null && this.handleSpecialProperties(outPropertyMap)) {
            WSS4JOutInterceptor outInterceptor = new WSS4JOutInterceptor(outPropertyMap);
            client.getOutInterceptors().add(outInterceptor);
        }
    }

    protected Map<String, Object> getWSS4JInInterceptorProperties() {
        String wss4jInInterceptorConfigPath = "consumer" + File.separator + "WSS4JInInterceptor.properties";
        Map<String, Object> inInterceptorProperties = Utils.getCXFConfigProperties(wss4jInInterceptorConfigPath);
        if (inInterceptorProperties == null) {
            log.debug("The WSS4JInInterceptor configuration file could not be found. No WSS4JInInterceptor will be added to the wsrp consumer.");
        }
        return inInterceptorProperties;
    }

    protected Map<String, Object> getWSS4JOutInterceptorProperties() {
        String wss4jOutInterceptorConfigPath = "consumer" + File.separator + "WSS4JOutInterceptor.properties";
        Map<String, Object> outInterceptorProperties = Utils.getCXFConfigProperties(wss4jOutInterceptorConfigPath);
        if (outInterceptorProperties == null) {
            log.debug("The WSS4JOutInterceptor configuration file could not be found. No WSS4JOutInterceptor will be added to the wsrp consumer.");
        }
        return outInterceptorProperties;
    }

    protected boolean handleSpecialProperties(Map<String, Object> propertyMap) {
        return this.handleUserAuthentication(propertyMap);
    }

    protected boolean handleUserAuthentication(Map<String, Object> propertyMap) {
        if (propertyMap.containsKey("user") && propertyMap.get("user").equals(GTN_CURRENT_USER)) {
            CredentialsAccessor credentialsAccessor = WebServiceSecurityFactory.getInstance().getCredentialsAccessor();
            if (credentialsAccessor != null && credentialsAccessor.getCredentials() != null) {
                Credentials credentials = credentialsAccessor.getCredentials();
                propertyMap.put("user", credentials.getUsername());
                String actionProperty = (String)propertyMap.get("action");
                if (actionProperty != null && actionProperty.contains(GTN_USERNAME_TOKEN_IF_AUTHENTICATED)) {
                    actionProperty = credentials.getPassword() != null ? actionProperty.replace(GTN_USERNAME_TOKEN_IF_AUTHENTICATED, "UsernameToken") : actionProperty.replace(GTN_USERNAME_TOKEN_IF_AUTHENTICATED, "UsernameTokenNoPassword");
                    propertyMap.put("action", actionProperty);
                }
            } else {
                propertyMap.put("user", GTN_NO_USER);
                String actionProperty = (String)propertyMap.get("action");
                if (actionProperty != null && actionProperty.contains(GTN_USERNAME_TOKEN_IF_AUTHENTICATED)) {
                    actionProperty = actionProperty.replace(GTN_USERNAME_TOKEN_IF_AUTHENTICATED, "");
                }
                propertyMap.put("action", actionProperty);
                if (actionProperty.trim().isEmpty()) {
                    return false;
                }
            }
        }
        return true;
    }
}

