/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.wsrp.wss.cxf.producer;

import java.security.Principal;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.security.auth.Subject;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import org.apache.cxf.binding.soap.SoapMessage;
import org.apache.cxf.interceptor.Fault;
import org.apache.ws.security.WSSecurityEngineResult;
import org.apache.ws.security.WSUsernameTokenPrincipal;
import org.jboss.wsf.stack.cxf.security.authentication.SubjectCreatingInterceptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GTNSubjectCreatingInterceptor
extends SubjectCreatingInterceptor {
    private static Logger log = LoggerFactory.getLogger(GTNSubjectCreatingInterceptor.class);
    private static final String USERNAME_TOKEN_IFAVAILABLE = "gtn.UsernameToken.ifAvailable";
    protected boolean gtnUsernameTokenIfAvailable = false;
    private WSUsernameTokenPrincipal wsUsernameTokenPrincipal = null;

    public GTNSubjectCreatingInterceptor() {
        this(new HashMap<String, Object>());
    }

    public GTNSubjectCreatingInterceptor(Map<String, Object> properties) {
        super(properties);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleMessage(SoapMessage msg) throws Fault {
        String actionProperty = (String)this.getProperties().get("action");
        if (actionProperty.contains(USERNAME_TOKEN_IFAVAILABLE)) {
            this.gtnUsernameTokenIfAvailable = true;
            this.setProperty("action", actionProperty.replace(USERNAME_TOKEN_IFAVAILABLE, "UsernameToken"));
        }
        try {
            super.handleMessage(msg);
        }
        finally {
            if (this.gtnUsernameTokenIfAvailable) {
                this.setProperty("action", actionProperty);
            }
        }
        if (this.wsUsernameTokenPrincipal != null) {
            HttpServletRequest request = (HttpServletRequest)msg.get((Object)"HTTP.REQUEST");
            String username = this.wsUsernameTokenPrincipal.getName();
            String password = this.wsUsernameTokenPrincipal.getPassword();
            this.wsUsernameTokenPrincipal = null;
            try {
                if (request.getRemoteUser() == null) {
                    request.login(username, password);
                }
            }
            catch (ServletException e) {
                e.printStackTrace();
            }
        }
    }

    public Subject createSubject(String name, String password, boolean isDigest, String nonce, String created) {
        Subject originalSubject = super.createSubject(name, password, isDigest, nonce, created);
        Set<Principal> principals = originalSubject.getPrincipals();
        if (principals.iterator().next().getName() != name) {
            Principal namePrincipal = null;
            for (Principal principal : principals) {
                if (!principal.getName().equals(name)) continue;
                namePrincipal = principal;
                break;
            }
            if (namePrincipal != null) {
                principals.remove(namePrincipal);
                LinkedHashSet<Principal> newPrincipals = new LinkedHashSet<Principal>();
                newPrincipals.add(namePrincipal);
                newPrincipals.addAll(principals);
                originalSubject.getPrincipals().clear();
                originalSubject.getPrincipals().addAll(newPrincipals);
            }
        }
        return originalSubject;
    }

    protected boolean checkReceiverResultsAnyOrder(List<WSSecurityEngineResult> wsResults, List<Integer> actions) {
        this.wsUsernameTokenPrincipal = null;
        if (this.gtnUsernameTokenIfAvailable) {
            boolean foundUsernameTokenResult = false;
            for (WSSecurityEngineResult wsResult : wsResults) {
                Integer actInt = (Integer)wsResult.get((Object)"action");
                if (actInt != 1) continue;
                foundUsernameTokenResult = true;
                Object principal = wsResult.get((Object)"principal");
                if (principal == null || !(principal instanceof WSUsernameTokenPrincipal)) break;
                this.wsUsernameTokenPrincipal = (WSUsernameTokenPrincipal)principal;
                break;
            }
            if (foundUsernameTokenResult && !actions.contains(1)) {
                actions.add(1);
            } else if (!foundUsernameTokenResult && actions.contains(1)) {
                actions.remove(actions.indexOf(1));
            }
        }
        return super.checkReceiverResults(wsResults, actions);
    }
}

