/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.wsrp.wss.cxf.producer;

import java.io.File;
import java.util.Map;
import org.apache.cxf.Bus;
import org.apache.cxf.endpoint.Server;
import org.apache.cxf.feature.AbstractFeature;
import org.apache.cxf.ws.security.wss4j.WSS4JInInterceptor;
import org.apache.cxf.ws.security.wss4j.WSS4JOutInterceptor;
import org.gatein.wsrp.wss.cxf.Utils;
import org.gatein.wsrp.wss.cxf.producer.GTNSubjectCreatingInterceptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WSRPWSSecurityFeature
extends AbstractFeature {
    private static Logger log = LoggerFactory.getLogger(WSRPWSSecurityFeature.class);
    protected static String GTN_SCI_INTERCEPTOR_CONFIG_FILE = "GTNSubjectCreatingInterceptor.properties";

    public WSRPWSSecurityFeature() {
        log.debug("WSRPWSSecurityFeature Constructed");
    }

    public void initialize(Server server, Bus bus) {
        System.out.println("WSRPWSSecurityFeature initialize(Server server, Bus bus)");
        Map<String, Object> inPropertyMap = this.getWSS4JInInterceptorProperties();
        Map<String, Object> outPropertyMap = this.getWSS4JOutInterceptorProperties();
        Map<String, Object> sciPropertyMap = this.getGTNSubjectCreatingInterceptorProperties();
        if (sciPropertyMap != null) {
            GTNSubjectCreatingInterceptor sci = new GTNSubjectCreatingInterceptor(sciPropertyMap);
            server.getEndpoint().getInInterceptors().add(sci);
        }
        if (inPropertyMap != null) {
            WSS4JInInterceptor inInterceptor = new WSS4JInInterceptor(inPropertyMap);
            server.getEndpoint().getInInterceptors().add(inInterceptor);
        }
        if (outPropertyMap != null) {
            WSS4JOutInterceptor outInterceptor = new WSS4JOutInterceptor(outPropertyMap);
            server.getEndpoint().getOutInterceptors().add(outInterceptor);
        }
    }

    protected Map<String, Object> getWSS4JInInterceptorProperties() {
        String wss4jInInterceptorConfigPath = "producer" + File.separator + "WSS4JInInterceptor.properties";
        Map<String, Object> inInterceptorProperties = Utils.getCXFConfigProperties(wss4jInInterceptorConfigPath);
        if (inInterceptorProperties == null) {
            log.debug("The WSS4JInInterceptor configuration file could not be found. No WSS4JInInterceptor will be added to the wsrp producer.");
        }
        return inInterceptorProperties;
    }

    protected Map<String, Object> getWSS4JOutInterceptorProperties() {
        String wss4jOutInterceptorConfigPath = "producer" + File.separator + "WSS4JOutInterceptor.properties";
        Map<String, Object> outInterceptorProperties = Utils.getCXFConfigProperties(wss4jOutInterceptorConfigPath);
        if (outInterceptorProperties == null) {
            log.debug("The WSS4JOutInterceptor configuration file could not be found. No WSS4JOutInterceptor will be added to the wsrp producer.");
        }
        return outInterceptorProperties;
    }

    protected Map<String, Object> getGTNSubjectCreatingInterceptorProperties() {
        String gtnSCInterceptorConfigPath = "producer" + File.separator + GTN_SCI_INTERCEPTOR_CONFIG_FILE;
        Map<String, Object> interceptorProperties = Utils.getCXFConfigProperties(gtnSCInterceptorConfigPath);
        if (interceptorProperties == null) {
            log.debug("The GTNSubjectCreatingInterceptor configuration file could not be found. No GTNSubjectCreatingInterceptor will be added to the wsrp producer.");
        }
        return interceptorProperties;
    }
}

