/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.wsrp.wss.cxf.consumer;

import java.io.IOException;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.UnsupportedCallbackException;
import org.apache.ws.security.WSPasswordCallback;
import org.gatein.wci.security.Credentials;
import org.gatein.wsrp.wss.CredentialsAccess;
import org.gatein.wsrp.wss.credentials.CredentialsAccessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CurrentUserPasswordCallback
implements CallbackHandler {
    private static Logger log = LoggerFactory.getLogger(CurrentUserPasswordCallback.class);

    @Override
    public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
        for (Callback callback : callbacks) {
            WSPasswordCallback wspasswordCallBack;
            if (!(callback instanceof WSPasswordCallback) || (wspasswordCallBack = (WSPasswordCallback)callback).getUsage() != 2) continue;
            CredentialsAccessor credentialsAccessor = CredentialsAccess.getInstance().getCredentialsAccessor();
            if (credentialsAccessor != null && credentialsAccessor.getCredentials() != null) {
                Credentials credentials = credentialsAccessor.getCredentials();
                if (credentials.getUsername().equals(wspasswordCallBack.getIdentifier())) {
                    wspasswordCallBack.setPassword(credentials.getPassword());
                    continue;
                }
                log.warn("The username in the callback does not match the currently authenticated user. Password not added to callback.");
                continue;
            }
            log.warn("Could not find credentials to put in WS-Security header");
        }
    }
}

