/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.wsrp.wss.cxf;

import java.io.File;
import java.io.FileInputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.gatein.wsrp.cxf.CXFConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WSSConfiguration {
    private static Logger log = LoggerFactory.getLogger(WSSConfiguration.class);
    public static final String WS_SECURITY_CONF_DIR_NAME = "ws-security";
    public static final String CONSUMER_CONF_DIR_NAME = "consumer";
    public static final String PRODUCER_CONF_DIR_NAME = "producer";
    public static final String WSS4J_ININTERCEPTOR_PROPERTY_FILE = "WSS4JInInterceptor.properties";
    public static final String WSS4J_OUTINTERCEPTOR_PROPERTY_FILE = "WSS4JOutInterceptor.properties";
    private static final File CXF_WSS_CONFIG_DIR = new File(CXFConfiguration.GATEIN_WSRP_CXF_CONF_DIR, "ws-security");

    public static Map<String, Object> getWSS4JInterceptorConfiguration(boolean consumer, boolean in) {
        return WSSConfiguration.getCXFConfiguration(consumer, in ? WSS4J_ININTERCEPTOR_PROPERTY_FILE : WSS4J_OUTINTERCEPTOR_PROPERTY_FILE, in ? "In" : "Out");
    }

    public static Map<String, Object> getCXFConfiguration(boolean consumer, String fileName, String interceptorName) {
        String path = (consumer ? CONSUMER_CONF_DIR_NAME : PRODUCER_CONF_DIR_NAME) + File.separatorChar + fileName;
        File interceptorPropertyFile = new File(CXF_WSS_CONFIG_DIR, path);
        try {
            HashMap<String, Object> outProperties = new HashMap<String, Object>();
            if (interceptorPropertyFile.exists()) {
                Properties properties = new Properties();
                properties.load(new FileInputStream(interceptorPropertyFile));
                for (String propName : properties.stringPropertyNames()) {
                    outProperties.put(propName, properties.get(propName));
                }
            } else {
                log.debug("The interceptor property file (" + interceptorPropertyFile + ") does not exist. No " + interceptorName + " interceptors will be added to the WSRP " + (consumer ? "Consumers." : "Producer."));
                return null;
            }
            return outProperties;
        }
        catch (Exception e) {
            log.error("Exception occurred trying to read the interceptor property file (" + interceptorPropertyFile + ").", (Throwable)e);
            return null;
        }
    }
}

