/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.wsrp.wss.cxf.consumer;

import java.util.Map;
import org.apache.cxf.endpoint.Client;
import org.apache.cxf.frontend.ClientProxy;
import org.apache.cxf.ws.security.wss4j.WSS4JInInterceptor;
import org.apache.cxf.ws.security.wss4j.WSS4JOutInterceptor;
import org.gatein.wci.security.Credentials;
import org.gatein.wsrp.services.PortCustomizer;
import org.gatein.wsrp.wss.CredentialsAccess;
import org.gatein.wsrp.wss.credentials.CredentialsAccessor;
import org.gatein.wsrp.wss.cxf.WSSConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CXFPortCustomizer
implements PortCustomizer {
    private static final Logger log = LoggerFactory.getLogger(CXFPortCustomizer.class);
    protected static final String GTN_CURRENT_USER = "gtn.current.user";
    protected static final String GTN_USERNAME_TOKEN_IF_AUTHENTICATED = "gtn.UsernameToken.ifCurrentUserAuthenticated";
    protected static final String GTN_NO_USER = "gtn.no.user";

    public void customizePort(Object service) {
        log.debug("Customizing the port for the WSRP CXF client.");
        Client client = ClientProxy.getClient((Object)service);
        Map<String, Object> inPropertyMap = WSSConfiguration.getWSS4JInterceptorConfiguration(true, true);
        Map<String, Object> outPropertyMap = WSSConfiguration.getWSS4JInterceptorConfiguration(true, false);
        if (inPropertyMap != null && this.handleSpecialProperties(inPropertyMap)) {
            WSS4JInInterceptor inInterceptor = new WSS4JInInterceptor(inPropertyMap);
            client.getInInterceptors().add(inInterceptor);
        }
        if (outPropertyMap != null && this.handleSpecialProperties(outPropertyMap)) {
            WSS4JOutInterceptor outInterceptor = new WSS4JOutInterceptor(outPropertyMap);
            client.getOutInterceptors().add(outInterceptor);
        }
    }

    public boolean isWSSFocused() {
        return true;
    }

    protected boolean handleSpecialProperties(Map<String, Object> propertyMap) {
        return this.handleUserAuthentication(propertyMap);
    }

    protected boolean handleUserAuthentication(Map<String, Object> propertyMap) {
        Object userValue = propertyMap.get("user");
        if (GTN_CURRENT_USER.equals(userValue)) {
            CredentialsAccessor credentialsAccessor = CredentialsAccess.getInstance().getCredentialsAccessor();
            if (credentialsAccessor != null && credentialsAccessor.getCredentials() != null) {
                Credentials credentials = credentialsAccessor.getCredentials();
                propertyMap.put("user", credentials.getUsername());
                String actionProperty = (String)propertyMap.get("action");
                if (actionProperty != null && actionProperty.contains(GTN_USERNAME_TOKEN_IF_AUTHENTICATED)) {
                    actionProperty = credentials.getPassword() != null ? actionProperty.replace(GTN_USERNAME_TOKEN_IF_AUTHENTICATED, "UsernameToken") : actionProperty.replace(GTN_USERNAME_TOKEN_IF_AUTHENTICATED, "UsernameTokenNoPassword");
                    propertyMap.put("action", actionProperty);
                }
            } else {
                propertyMap.put("user", GTN_NO_USER);
                String actionProperty = (String)propertyMap.get("action");
                if (actionProperty != null) {
                    if (actionProperty.contains(GTN_USERNAME_TOKEN_IF_AUTHENTICATED)) {
                        actionProperty = actionProperty.replace(GTN_USERNAME_TOKEN_IF_AUTHENTICATED, "");
                    }
                    propertyMap.put("action", actionProperty);
                    if (actionProperty.trim().isEmpty()) {
                        return false;
                    }
                }
            }
        }
        return true;
    }
}

