/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.wsrp.wss.cxf.consumer;

import java.util.Collection;
import javax.xml.namespace.QName;
import org.apache.cxf.endpoint.Client;
import org.apache.cxf.frontend.ClientProxy;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.message.Message;
import org.apache.cxf.phase.AbstractPhaseInterceptor;
import org.apache.cxf.ws.policy.AbstractPolicyInterceptorProvider;
import org.apache.cxf.ws.policy.AssertionInfo;
import org.apache.cxf.ws.policy.AssertionInfoMap;
import org.apache.cxf.ws.policy.PolicyInterceptorProvider;
import org.apache.cxf.ws.policy.PolicyInterceptorProviderRegistry;
import org.gatein.wsrp.services.PortCustomizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BEAPolicyIgnoringPortCustomizer
implements PortCustomizer {
    private static final Logger log = LoggerFactory.getLogger(BEAPolicyIgnoringPortCustomizer.class);
    public static final String IGNORE_BEA_POLICY_PROPERTY_NAME = "org.gatein.wsrp.consumer.ignoreDefaultBEAPolicy";
    private static final QName BEA_DEFAULT_POLICY = new QName("http://www.bea.com/wls90/security/policy", "Identity");
    private static final IgnorableAssertionsInterceptor IGNORABLE_ASSERTIONS_INTERCEPTOR = new IgnorableAssertionsInterceptor();
    private static final IgnorablePolicyInterceptorProvider IGNORABLE_POLICY_INTERCEPTOR_PROVIDER = new IgnorablePolicyInterceptorProvider();
    private static boolean ignore = true;

    public void customizePort(Object service) {
        if (ignore) {
            log.debug("Injecting interceptor to ignore BEA WebLogic 10's default WS-Policy.");
            Client client = ClientProxy.getClient((Object)service);
            PolicyInterceptorProviderRegistry providerRegistry = (PolicyInterceptorProviderRegistry)client.getBus().getExtension(PolicyInterceptorProviderRegistry.class);
            providerRegistry.register((PolicyInterceptorProvider)IGNORABLE_POLICY_INTERCEPTOR_PROVIDER);
        }
    }

    public boolean isWSSFocused() {
        return false;
    }

    static {
        String ignoreProperty = System.getProperty(IGNORE_BEA_POLICY_PROPERTY_NAME);
        if (ignoreProperty != null && !ignoreProperty.isEmpty()) {
            ignore = Boolean.parseBoolean(ignoreProperty);
        }
    }

    private static class IgnorableAssertionsInterceptor
    extends AbstractPhaseInterceptor<Message> {
        public IgnorableAssertionsInterceptor() {
            super("post-logical");
        }

        public void handleMessage(Message message) throws Fault {
            AssertionInfoMap aim = (AssertionInfoMap)message.get(AssertionInfoMap.class);
            Collection ais = aim.getAssertionInfo(BEA_DEFAULT_POLICY);
            log.info("Ignoring " + BEA_DEFAULT_POLICY);
            if (null != ais) {
                for (AssertionInfo ai : ais) {
                    ai.setAsserted(true);
                }
            }
        }
    }

    private static class IgnorablePolicyInterceptorProvider
    extends AbstractPolicyInterceptorProvider {
        public IgnorablePolicyInterceptorProvider() {
            super(BEA_DEFAULT_POLICY);
            this.getInInterceptors().add(IGNORABLE_ASSERTIONS_INTERCEPTOR);
            this.getOutInterceptors().add(IGNORABLE_ASSERTIONS_INTERCEPTOR);
            this.getInFaultInterceptors().add(IGNORABLE_ASSERTIONS_INTERCEPTOR);
            this.getOutFaultInterceptors().add(IGNORABLE_ASSERTIONS_INTERCEPTOR);
        }
    }
}

