/*
 * Decompiled with CFR 0.152.
 */
package org.gaul.httpbin;

import java.net.URI;
import java.util.Objects;
import org.eclipse.jetty.server.ConnectionFactory;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.HttpConnectionFactory;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.gaul.httpbin.HttpBinHandler;

public final class HttpBin {
    private final Server server;

    public HttpBin(URI endpoint) throws Exception {
        this(endpoint, new HttpBinHandler());
    }

    public HttpBin(URI endpoint, HttpBinHandler handler) throws Exception {
        Objects.requireNonNull(endpoint);
        this.server = new Server();
        HttpConnectionFactory httpConnectionFactory = new HttpConnectionFactory();
        ServerConnector connector = new ServerConnector(this.server, new ConnectionFactory[]{httpConnectionFactory});
        connector.setHost(endpoint.getHost());
        connector.setPort(endpoint.getPort());
        this.server.addConnector((Connector)connector);
        this.server.setHandler((Handler)handler);
    }

    public void start() throws Exception {
        this.server.start();
    }

    public void stop() throws Exception {
        this.server.stop();
    }

    public int getPort() {
        return ((ServerConnector)this.server.getConnectors()[0]).getLocalPort();
    }
}

