/*
 * Decompiled with CFR 0.152.
 */
package org.gaul.modernizer_maven_plugin;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.StringUtils;
import org.gaul.modernizer_maven_plugin.Modernizer;
import org.gaul.modernizer_maven_plugin.SuppressModernizerAnnotationDetector;
import org.gaul.modernizer_maven_plugin.Utils;
import org.gaul.modernizer_maven_plugin.Violation;
import org.gaul.modernizer_maven_plugin.ViolationOccurrence;
import org.xml.sax.SAXException;

@Mojo(name="modernizer", defaultPhase=LifecyclePhase.PROCESS_TEST_CLASSES, threadSafe=true)
public final class ModernizerMojo
extends AbstractMojo {
    private static final String CLASSPATH_PREFIX = "classpath:";
    @Parameter(defaultValue="${project}", readonly=true)
    private MavenProject project;
    @Parameter(property="project.build.sourceDirectory")
    private File sourceDirectory;
    @Parameter(property="project.build.testSourceDirectory")
    private File testSourceDirectory;
    @Parameter(property="project.build.outputDirectory")
    private File outputDirectory;
    @Parameter(property="project.build.testOutputDirectory")
    private File testOutputDirectory;
    @Parameter(property="modernizer.javaVersion")
    private String javaVersion;
    @Parameter(defaultValue="true", property="modernizer.failOnViolations")
    protected boolean failOnViolations = true;
    @Parameter(defaultValue="true", property="modernizer.includeTestClasses")
    protected boolean includeTestClasses = true;
    @Parameter(property="modernizer.violationsFile")
    protected String violationsFile = "classpath:/modernizer.xml";
    @Parameter(property="modernizer.violationsFiles")
    protected List<String> violationsFiles = Collections.emptyList();
    @Parameter(property="modernizer.exclusionsFile")
    private String exclusionsFile;
    @Parameter(defaultValue="error", property="modernizer.violationLogLevel")
    private String violationLogLevel;
    @Parameter
    protected Set<String> exclusions = new HashSet<String>();
    @Parameter
    protected Set<String> exclusionPatterns = new HashSet<String>();
    @Parameter
    protected Set<String> ignorePackages = new HashSet<String>();
    @Parameter
    protected Set<String> ignoreClassNamePatterns = new HashSet<String>();
    private Modernizer modernizer;
    @Parameter(defaultValue="false", property="modernizer.skip")
    protected boolean skip = false;

    public void execute() throws MojoExecutionException {
        if (this.skip) {
            this.getLog().info((CharSequence)"Skipping modernizer execution!");
            return;
        }
        if (StringUtils.isEmpty((String)this.javaVersion)) {
            throw new MojoExecutionException("javaVersion is not set but is required for execution.");
        }
        Map<String, Violation> allViolations = ModernizerMojo.parseViolations(this.violationsFile);
        for (String violationsFilePath : this.violationsFiles) {
            allViolations.putAll(ModernizerMojo.parseViolations(violationsFilePath));
        }
        HashSet<String> allExclusions = new HashSet<String>();
        allExclusions.addAll(this.exclusions);
        if (this.exclusionsFile != null) {
            allExclusions.addAll(this.readExclusionsFile(this.exclusionsFile));
        }
        HashSet<Pattern> allExclusionPatterns = new HashSet<Pattern>();
        for (String string : this.exclusionPatterns) {
            try {
                allExclusionPatterns.add(Pattern.compile(string));
            }
            catch (PatternSyntaxException pse) {
                throw new MojoExecutionException("Invalid exclusion pattern", (Exception)pse);
            }
        }
        HashSet<Pattern> allIgnoreFullClassNamePatterns = new HashSet<Pattern>();
        for (String pattern : this.ignoreClassNamePatterns) {
            try {
                allIgnoreFullClassNamePatterns.add(Pattern.compile(pattern));
            }
            catch (PatternSyntaxException pse) {
                throw new MojoExecutionException("Invalid exclusion pattern", (Exception)pse);
            }
        }
        HashSet<String> hashSet = new HashSet<String>();
        try {
            hashSet.addAll(SuppressModernizerAnnotationDetector.detect(this.outputDirectory));
            if (this.includeTestClasses) {
                hashSet.addAll(SuppressModernizerAnnotationDetector.detect(this.testOutputDirectory));
            }
        }
        catch (IOException e) {
            throw new MojoExecutionException("Error reading suppressions", (Exception)e);
        }
        this.modernizer = new Modernizer(this.javaVersion, allViolations, allExclusions, allExclusionPatterns, this.ignorePackages, hashSet, allIgnoreFullClassNamePatterns);
        try {
            long count = this.recurseFiles(this.outputDirectory);
            if (this.includeTestClasses) {
                count += this.recurseFiles(this.testOutputDirectory);
            }
            if (this.failOnViolations && count != 0L) {
                throw new MojoExecutionException("Found " + count + " violations");
            }
        }
        catch (IOException ioe) {
            throw new MojoExecutionException("Error reading Java classes", (Exception)ioe);
        }
    }

    private static Map<String, Violation> parseViolations(String violationsFilePath) throws MojoExecutionException {
        Object file;
        InputStream is;
        if (violationsFilePath.startsWith(CLASSPATH_PREFIX)) {
            String classpath = violationsFilePath.substring(CLASSPATH_PREFIX.length());
            Utils.checkArgument(classpath.startsWith("/"), String.format("Only absolute classpath references are allowed, got [%s]", classpath));
            is = Modernizer.class.getResourceAsStream(classpath);
        } else {
            file = new File(violationsFilePath);
            try {
                is = new FileInputStream((File)file);
            }
            catch (FileNotFoundException fnfe) {
                throw new MojoExecutionException("Error opening violation file: " + file, (Exception)fnfe);
            }
        }
        try {
            file = Modernizer.parseFromXml(is);
            return file;
        }
        catch (IOException ioe) {
            throw new MojoExecutionException("Error reading violation data", (Exception)ioe);
        }
        catch (ParserConfigurationException pce) {
            throw new MojoExecutionException("Error parsing violation data", (Exception)pce);
        }
        catch (SAXException saxe) {
            throw new MojoExecutionException("Error parsing violation data", (Exception)saxe);
        }
        finally {
            Utils.closeQuietly(is);
        }
    }

    private Collection<String> readExclusionsFile(String exclusionsFilePath) throws MojoExecutionException {
        Collection<String> collection;
        InputStream is = null;
        try {
            File file = new File(exclusionsFilePath);
            is = file.exists() ? new FileInputStream(exclusionsFilePath) : ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream(exclusionsFilePath);
            if (is == null) {
                throw new MojoExecutionException("Could not find exclusion file: " + exclusionsFilePath);
            }
            collection = Utils.filterCommentLines(Utils.readAllLines(is));
        }
        catch (IOException ioe) {
            try {
                throw new MojoExecutionException("Error reading exclusion file: " + exclusionsFilePath, (Exception)ioe);
            }
            catch (Throwable throwable) {
                Utils.closeQuietly(is);
                throw throwable;
            }
        }
        Utils.closeQuietly(is);
        return collection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long recurseFiles(File file) throws IOException {
        long count;
        block11: {
            block10: {
                count = 0L;
                if (!file.exists()) {
                    return count;
                }
                if (!file.isDirectory()) break block10;
                String[] children = file.list();
                if (children == null) break block11;
                for (String child : children) {
                    count += this.recurseFiles(new File(file, child));
                }
                break block11;
            }
            if (file.getPath().endsWith(".class")) {
                FileInputStream is = new FileInputStream(file);
                try {
                    Collection<ViolationOccurrence> occurrences = this.modernizer.check(is);
                    for (ViolationOccurrence occurrence : occurrences) {
                        String name = file.getPath();
                        if (name.startsWith(this.outputDirectory.getPath())) {
                            name = this.sourceDirectory.getPath() + name.substring(this.outputDirectory.getPath().length());
                            name = name.substring(0, name.length() - ".class".length()) + ".java";
                        } else if (name.startsWith(this.testOutputDirectory.getPath())) {
                            name = this.testSourceDirectory.getPath() + name.substring(this.testOutputDirectory.getPath().length());
                            name = name.substring(0, name.length() - ".class".length()) + ".java";
                        }
                        this.emitViolation(name, occurrence);
                        ++count;
                    }
                }
                finally {
                    Utils.closeQuietly(is);
                }
            }
        }
        return count;
    }

    private void emitViolation(String name, ViolationOccurrence occurrence) {
        String message = name + ":" + occurrence.getLineNumber() + ": " + occurrence.getViolation().getComment();
        if (this.violationLogLevel.equals("error")) {
            this.getLog().error((CharSequence)message);
        } else if (this.violationLogLevel.equals("warn")) {
            this.getLog().warn((CharSequence)message);
        } else if (this.violationLogLevel.equals("info")) {
            this.getLog().info((CharSequence)message);
        } else if (this.violationLogLevel.equals("debug")) {
            this.getLog().debug((CharSequence)message);
        } else {
            throw new IllegalStateException("unexpected log level, was: " + this.violationLogLevel);
        }
    }
}

