/*
 * Decompiled with CFR 0.152.
 */
package org.gaul.modernizer_maven_plugin;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import java.util.stream.Stream;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.gaul.modernizer_maven_plugin.Modernizer;
import org.gaul.modernizer_maven_plugin.SuppressGeneratedAnnotationDetector;
import org.gaul.modernizer_maven_plugin.SuppressModernizerAnnotationDetector;
import org.gaul.modernizer_maven_plugin.Utils;
import org.gaul.modernizer_maven_plugin.Violation;
import org.gaul.modernizer_maven_plugin.ViolationOccurrence;
import org.gaul.modernizer_maven_plugin.output.CodeClimateOutputer;
import org.gaul.modernizer_maven_plugin.output.LoggerOutputer;
import org.gaul.modernizer_maven_plugin.output.OutputEntry;
import org.gaul.modernizer_maven_plugin.output.OutputFormat;
import org.gaul.modernizer_maven_plugin.output.Outputer;
import org.xml.sax.SAXException;

@Mojo(name="modernizer", defaultPhase=LifecyclePhase.PROCESS_TEST_CLASSES, threadSafe=true)
public final class ModernizerMojo
extends AbstractMojo {
    private static final String CLASSPATH_PREFIX = "classpath:";
    @Parameter(defaultValue="${project}", readonly=true)
    private MavenProject project;
    @Parameter(property="project.build.sourceDirectory")
    private File sourceDirectory;
    @Parameter(property="project.build.testSourceDirectory")
    private File testSourceDirectory;
    @Parameter(property="project.build.outputDirectory")
    private File outputDirectory;
    @Parameter(property="project.build.testOutputDirectory")
    private File testOutputDirectory;
    @Parameter(property="modernizer.javaVersion")
    private String javaVersion;
    @Parameter(defaultValue="true", property="modernizer.failOnViolations")
    protected boolean failOnViolations = true;
    @Parameter(defaultValue="true", property="modernizer.includeTestClasses")
    protected boolean includeTestClasses = true;
    @Parameter(property="modernizer.violationsFile")
    protected String violationsFile = "classpath:/modernizer.xml";
    @Parameter(property="modernizer.violationsFiles")
    protected List<String> violationsFiles = Collections.emptyList();
    @Parameter(property="modernizer.exclusionsFile")
    private String exclusionsFile;
    @Parameter(defaultValue="CONSOLE", property="modernizer.outputFormat")
    private OutputFormat outputFormat;
    @Parameter(property="modernizer.outputFile")
    private String outputFile;
    @Parameter(defaultValue="MINOR", property="modernizer.codeclimateSeverity")
    private CodeClimateOutputer.Severity codeClimateSeverity;
    @Parameter(defaultValue="error", property="modernizer.violationLogLevel")
    private String violationLogLevel;
    @Parameter(defaultValue="true", property="modernizer.ignoreGeneratedClasses")
    private Boolean ignoreGeneratedClasses;
    @Parameter
    protected Set<String> exclusions = new HashSet<String>();
    @Parameter
    protected Set<String> exclusionPatterns = new HashSet<String>();
    @Parameter
    protected Set<String> ignorePackages = new HashSet<String>();
    @Parameter
    protected Set<String> ignoreClassNamePatterns = new HashSet<String>();
    private Modernizer modernizer;
    @Parameter(defaultValue="false", property="modernizer.skip")
    protected boolean skip = false;
    private List<OutputEntry> outputEntries = new ArrayList<OutputEntry>();

    public void execute() throws MojoExecutionException {
        long count;
        if (this.skip) {
            this.getLog().info((CharSequence)"Skipping modernizer execution!");
            return;
        }
        if (this.javaVersion == null || this.javaVersion.isEmpty()) {
            throw new MojoExecutionException("javaVersion is not set but is required for execution.");
        }
        Map<String, Violation> allViolations = ModernizerMojo.parseViolations(this.violationsFile);
        for (String violationsFilePath : this.violationsFiles) {
            allViolations.putAll(ModernizerMojo.parseViolations(violationsFilePath));
        }
        HashSet<String> allExclusions = new HashSet<String>();
        allExclusions.addAll(this.exclusions);
        if (this.exclusionsFile != null) {
            allExclusions.addAll(this.readExclusionsFile(this.exclusionsFile));
        }
        HashSet<Pattern> allExclusionPatterns = new HashSet<Pattern>();
        for (String string : this.exclusionPatterns) {
            try {
                allExclusionPatterns.add(Pattern.compile(string));
            }
            catch (PatternSyntaxException pse) {
                throw new MojoExecutionException("Invalid exclusion pattern", (Exception)pse);
            }
        }
        HashSet<Pattern> allIgnoreFullClassNamePatterns = new HashSet<Pattern>();
        for (String pattern : this.ignoreClassNamePatterns) {
            try {
                allIgnoreFullClassNamePatterns.add(Pattern.compile(pattern));
            }
            catch (PatternSyntaxException pse) {
                throw new MojoExecutionException("Invalid exclusion pattern", (Exception)pse);
            }
        }
        HashSet<String> hashSet = new HashSet<String>();
        try {
            Set<String> ignore;
            hashSet.addAll(SuppressModernizerAnnotationDetector.detect(this.outputDirectory.toPath()));
            if (this.ignoreGeneratedClasses.booleanValue()) {
                ignore = SuppressGeneratedAnnotationDetector.detect(this.outputDirectory.toPath());
                if (this.getLog().isDebugEnabled()) {
                    this.getLog().debug((CharSequence)"The following generated classes will be ignored");
                    for (String s : ignore) {
                        this.getLog().debug((CharSequence)s);
                    }
                }
                hashSet.addAll(ignore);
            }
            if (this.includeTestClasses) {
                hashSet.addAll(SuppressModernizerAnnotationDetector.detect(this.testOutputDirectory.toPath()));
                if (this.ignoreGeneratedClasses.booleanValue()) {
                    ignore = SuppressGeneratedAnnotationDetector.detect(this.testOutputDirectory.toPath());
                    if (this.getLog().isDebugEnabled()) {
                        this.getLog().debug((CharSequence)"The following generated test classes will be ignored");
                        for (String s : ignore) {
                            this.getLog().debug((CharSequence)s);
                        }
                    }
                    hashSet.addAll(ignore);
                }
            }
        }
        catch (IOException e) {
            throw new MojoExecutionException("Error reading suppressions", (Exception)e);
        }
        this.modernizer = new Modernizer(this.javaVersion, allViolations, allExclusions, allExclusionPatterns, this.ignorePackages, hashSet, allIgnoreFullClassNamePatterns);
        try {
            count = this.recurseFiles(this.outputDirectory.toPath());
            if (this.includeTestClasses) {
                count += this.recurseFiles(this.testOutputDirectory.toPath());
            }
        }
        catch (IOException ioe) {
            throw new MojoExecutionException("Error reading Java classes", (Exception)ioe);
        }
        try {
            this.buildOutputer().output(this.outputEntries);
        }
        catch (IOException ioe) {
            throw new MojoExecutionException("Error outputting violations", (Exception)ioe);
        }
        if (this.failOnViolations && count != 0L) {
            throw new MojoExecutionException("Found " + count + " violations");
        }
    }

    private static Map<String, Violation> parseViolations(String violationsFilePath) throws MojoExecutionException {
        Object path;
        InputStream is;
        if (violationsFilePath.startsWith(CLASSPATH_PREFIX)) {
            String classpath = violationsFilePath.substring(CLASSPATH_PREFIX.length());
            Utils.checkArgument(classpath.startsWith("/"), String.format("Only absolute classpath references are allowed, got [%s]", classpath));
            is = Modernizer.class.getResourceAsStream(classpath);
        } else {
            path = FileSystems.getDefault().getPath(violationsFilePath, new String[0]);
            try {
                is = Files.newInputStream((Path)path, new OpenOption[0]);
            }
            catch (IOException fnfe) {
                throw new MojoExecutionException("Error opening violation file: " + path, (Exception)fnfe);
            }
        }
        try {
            path = Modernizer.parseFromXml(is);
            return path;
        }
        catch (IOException ioe) {
            throw new MojoExecutionException("Error reading violation data", (Exception)ioe);
        }
        catch (ParserConfigurationException pce) {
            throw new MojoExecutionException("Error parsing violation data", (Exception)pce);
        }
        catch (SAXException saxe) {
            throw new MojoExecutionException("Error parsing violation data", (Exception)saxe);
        }
        finally {
            Utils.closeQuietly(is);
        }
    }

    private Collection<String> readExclusionsFile(String exclusionsFilePath) throws MojoExecutionException {
        Collection<String> collection;
        InputStream is = null;
        try {
            Path path = FileSystems.getDefault().getPath(exclusionsFilePath, new String[0]);
            is = Files.exists(path, new LinkOption[0]) ? Files.newInputStream(path, new OpenOption[0]) : ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream(exclusionsFilePath);
            if (is == null) {
                throw new MojoExecutionException("Could not find exclusion file: " + exclusionsFilePath);
            }
            collection = Utils.filterCommentLines(Utils.readAllLines(is));
        }
        catch (IOException ioe) {
            try {
                throw new MojoExecutionException("Error reading exclusion file: " + exclusionsFilePath, (Exception)ioe);
            }
            catch (Throwable throwable) {
                Utils.closeQuietly(is);
                throw throwable;
            }
        }
        Utils.closeQuietly(is);
        return collection;
    }

    private long recurseFiles(Path path) throws IOException {
        long count = 0L;
        if (!Files.exists(path, new LinkOption[0])) {
            return count;
        }
        if (Files.isDirectory(path, new LinkOption[0])) {
            Stream<Path> stream = Files.list(path);
            Iterable children = stream::iterator;
            for (Path child : children) {
                count += this.recurseFiles(path.resolve(child));
            }
        } else if (path.toString().endsWith(".class")) {
            try (InputStream is = Files.newInputStream(path, new OpenOption[0]);){
                Collection<ViolationOccurrence> occurrences = this.modernizer.check(is);
                for (ViolationOccurrence occurrence : occurrences) {
                    String name = path.toString();
                    if (name.startsWith(this.outputDirectory.getPath())) {
                        name = this.sourceDirectory.getPath() + name.substring(this.outputDirectory.getPath().length());
                        name = name.substring(0, name.length() - ".class".length()) + ".java";
                    } else if (name.startsWith(this.testOutputDirectory.getPath())) {
                        name = this.testSourceDirectory.getPath() + name.substring(this.testOutputDirectory.getPath().length());
                        name = name.substring(0, name.length() - ".class".length()) + ".java";
                    }
                    this.outputEntries.add(new OutputEntry(name, occurrence));
                    ++count;
                }
            }
        }
        return count;
    }

    private Outputer buildOutputer() throws MojoExecutionException {
        String baseDir = this.project.getBuild().getDirectory();
        if (Objects.requireNonNull(this.outputFormat) == OutputFormat.CONSOLE) {
            return new LoggerOutputer(this.getLog(), this.violationLogLevel);
        }
        if (this.outputFormat == OutputFormat.CODE_CLIMATE) {
            return new CodeClimateOutputer(baseDir + "/" + "code-quality.json", this.codeClimateSeverity);
        }
        throw new MojoExecutionException("Invalid output format: " + (Object)((Object)this.outputFormat));
    }
}

