/*
 * Decompiled with CFR 0.152.
 */
package org.gaul.modernizer_maven_plugin.output;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.gaul.modernizer_maven_plugin.Violation;
import org.gaul.modernizer_maven_plugin.output.OutputEntry;
import org.gaul.modernizer_maven_plugin.output.Outputer;

public final class CodeClimateOutputer
implements Outputer {
    public static final String DEFAULT_FILENAME = "code-quality.json";
    private final String outputFile;
    private final Severity severity;

    public CodeClimateOutputer(String outputFile, Severity severity) {
        this.outputFile = outputFile;
        this.severity = severity;
    }

    @Override
    public void output(List<OutputEntry> entries) throws IOException {
        ArrayList<Entry> toOutput = new ArrayList<Entry>(entries.size());
        for (OutputEntry entry : entries) {
            Location location = new Location(entry.getFileName(), new Location.Lines(entry.getOccurrence().getLineNumber()));
            Violation violation = entry.getOccurrence().getViolation();
            toOutput.add(new Entry(violation.getComment(), violation.getName(), Integer.toString(entry.hashCode()), this.severity, location));
        }
        TypeToken<List<Entry>> type = new TypeToken<List<Entry>>(){};
        try (OutputStreamWriter writer = new OutputStreamWriter(Files.newOutputStream(Paths.get(this.outputFile, new String[0]), new OpenOption[0]), StandardCharsets.UTF_8);){
            new Gson().toJson(toOutput, type.getType(), (Appendable)writer);
        }
    }

    public static enum Severity {
        INFO,
        MINOR,
        MAJOR,
        CRITICAL,
        BLOCKER;

    }

    private static final class Location {
        private final String path;
        private final Lines lines;

        private Location(String path, Lines lines) {
            this.path = path;
            this.lines = lines;
        }

        public String getPath() {
            return this.path;
        }

        public Lines getLines() {
            return this.lines;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof Location)) {
                return false;
            }
            Location location = (Location)o;
            return Objects.equals(this.path, location.path) && Objects.equals(this.lines, location.lines);
        }

        public int hashCode() {
            return Objects.hash(this.path, this.lines);
        }

        public String toString() {
            return "Location{path='" + this.path + '\'' + ", lines=" + this.lines + '}';
        }

        private static final class Lines {
            private final int begin;

            private Lines(int begin) {
                this.begin = begin;
            }

            public int getBegin() {
                return this.begin;
            }

            public boolean equals(Object o) {
                if (this == o) {
                    return true;
                }
                if (!(o instanceof Lines)) {
                    return false;
                }
                Lines lines = (Lines)o;
                return this.begin == lines.begin;
            }

            public int hashCode() {
                return Objects.hash(this.begin);
            }

            public String toString() {
                return "Lines{begin=" + this.begin + '}';
            }
        }
    }

    private static final class Entry {
        private final String description;
        private final String checkName;
        private final String fingerprint;
        private final Severity severity;
        private final Location location;

        private Entry(String description, String checkName, String fingerprint, Severity severity, Location location) {
            this.description = description;
            this.checkName = checkName;
            this.fingerprint = fingerprint;
            this.severity = severity;
            this.location = location;
        }

        public String getDescription() {
            return this.description;
        }

        public String getCheckName() {
            return this.checkName;
        }

        public String getFingerprint() {
            return this.fingerprint;
        }

        public Severity getSeverity() {
            return this.severity;
        }

        public Location getLocation() {
            return this.location;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof Entry)) {
                return false;
            }
            Entry that = (Entry)o;
            return Objects.equals(this.description, that.description) && Objects.equals(this.checkName, that.checkName) && Objects.equals(this.fingerprint, that.fingerprint) && this.severity == that.severity && Objects.equals(this.location, that.location);
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.description, this.checkName, this.fingerprint, this.severity, this.location});
        }

        public String toString() {
            return "CodeClimateEntry{description='" + this.description + '\'' + ", checkName='" + this.checkName + '\'' + ", fingerprint='" + this.fingerprint + '\'' + ", severity=" + (Object)((Object)this.severity) + ", location=" + this.location + '}';
        }
    }
}

