/*
 * Decompiled with CFR 0.152.
 */
package org.gaul.s3proxy;

import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class CrossOriginResourceSharing {
    private static final String HEADER_VALUE_SEPARATOR = ", ";
    private static final String ALLOW_ANY_HEADER = "*";
    private static final Logger logger = LoggerFactory.getLogger(CrossOriginResourceSharing.class);
    private final String allowedMethodsRaw;
    private final String allowedHeadersRaw;
    private final Set<Pattern> allowedOrigins;
    private final Set<String> allowedMethods;
    private final Set<String> allowedHeaders;

    protected CrossOriginResourceSharing() {
        this(Lists.newArrayList((Object[])new String[]{".*"}), Lists.newArrayList((Object[])new String[]{"GET", "PUT", "POST"}), Lists.newArrayList((Object[])new String[]{ALLOW_ANY_HEADER}));
    }

    protected CrossOriginResourceSharing(Collection<String> allowedOrigins, Collection<String> allowedMethods, Collection<String> allowedHeaders) {
        HashSet<Pattern> allowedPattern = new HashSet<Pattern>();
        if (allowedOrigins != null) {
            for (String origin : allowedOrigins) {
                allowedPattern.add(Pattern.compile(origin, 2));
            }
        }
        this.allowedOrigins = ImmutableSet.copyOf(allowedPattern);
        this.allowedMethods = allowedMethods == null ? ImmutableSet.of() : ImmutableSet.copyOf(allowedMethods);
        this.allowedMethodsRaw = Joiner.on((String)HEADER_VALUE_SEPARATOR).join(this.allowedMethods);
        this.allowedHeaders = allowedHeaders == null ? ImmutableSet.of() : ImmutableSet.copyOf(allowedHeaders);
        this.allowedHeadersRaw = Joiner.on((String)HEADER_VALUE_SEPARATOR).join(this.allowedHeaders);
        logger.info("CORS allowed origins: {}", allowedOrigins);
        logger.info("CORS allowed methods: {}", allowedMethods);
        logger.info("CORS allowed headers: {}", allowedHeaders);
    }

    public String getAllowedMethods() {
        return this.allowedMethodsRaw;
    }

    public boolean isOriginAllowed(String origin) {
        if (!Strings.isNullOrEmpty((String)origin)) {
            for (Pattern pattern : this.allowedOrigins) {
                Matcher matcher = pattern.matcher(origin);
                if (!matcher.matches()) continue;
                logger.debug("CORS origin allowed: {}", (Object)origin);
                return true;
            }
        }
        logger.debug("CORS origin not allowed: {}", (Object)origin);
        return false;
    }

    public boolean isMethodAllowed(String method) {
        if (!Strings.isNullOrEmpty((String)method) && this.allowedMethods.contains(method)) {
            logger.debug("CORS method allowed: {}", (Object)method);
            return true;
        }
        logger.debug("CORS method not allowed: {}", (Object)method);
        return false;
    }

    public boolean isEveryHeaderAllowed(String headers) {
        boolean result = false;
        if (!Strings.isNullOrEmpty((String)headers)) {
            if (this.allowedHeadersRaw.equals(ALLOW_ANY_HEADER)) {
                result = true;
            } else {
                String header;
                Iterator iterator = Splitter.on((String)HEADER_VALUE_SEPARATOR).split((CharSequence)headers).iterator();
                while (iterator.hasNext() && (result = this.allowedHeaders.contains(header = (String)iterator.next()))) {
                }
            }
        }
        if (result) {
            logger.debug("CORS headers allowed: {}", (Object)headers);
        } else {
            logger.debug("CORS headers not allowed: {}", (Object)headers);
        }
        return result;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || !(object instanceof CrossOriginResourceSharing)) {
            return false;
        }
        CrossOriginResourceSharing that = (CrossOriginResourceSharing)object;
        return this.allowedOrigins.equals(that.allowedOrigins) && this.allowedMethodsRaw.equals(that.allowedMethodsRaw) && this.allowedHeadersRaw.equals(that.allowedHeadersRaw);
    }

    public int hashCode() {
        return Objects.hash(this.allowedOrigins, this.allowedMethodsRaw, this.allowedHeadersRaw);
    }
}

