/*
 * Decompiled with CFR 0.152.
 */
package org.gaul.s3proxy;

import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.common.io.Files;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.Console;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.gaul.s3proxy.AuthenticationType;
import org.gaul.s3proxy.BlobStoreLocator;
import org.gaul.s3proxy.EventualBlobStore;
import org.gaul.s3proxy.NullBlobStore;
import org.gaul.s3proxy.ReadOnlyBlobStore;
import org.gaul.s3proxy.S3Proxy;
import org.jclouds.ContextBuilder;
import org.jclouds.JcloudsVersion;
import org.jclouds.blobstore.BlobStore;
import org.jclouds.blobstore.BlobStoreContext;
import org.jclouds.concurrent.DynamicExecutors;
import org.jclouds.concurrent.config.ExecutorServiceModule;
import org.jclouds.logging.slf4j.config.SLF4JLoggingModule;
import org.jclouds.openstack.swift.v1.blobstore.RegionScopedBlobStoreContext;
import org.kohsuke.args4j.CmdLineException;
import org.kohsuke.args4j.CmdLineParser;
import org.kohsuke.args4j.Option;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Main {
    private static final Logger logger = LoggerFactory.getLogger(Main.class);

    private Main() {
        throw new AssertionError((Object)"intentionally not implemented");
    }

    public static void main(String[] args) throws Exception {
        S3Proxy s3Proxy;
        Console console = System.console();
        if (console == null) {
            System.setErr(Main.createLoggerErrorPrintStream());
        }
        Options options = new Options();
        CmdLineParser parser = new CmdLineParser((Object)options);
        try {
            parser.parseArgument(args);
        }
        catch (CmdLineException cle) {
            Main.usage(parser);
        }
        if (options.version) {
            System.err.println(Main.class.getPackage().getImplementationVersion());
            System.exit(0);
        } else if (options.propertiesFiles.isEmpty()) {
            Main.usage(parser);
        }
        S3Proxy.Builder s3ProxyBuilder = null;
        ThreadFactory factory = new ThreadFactoryBuilder().setNameFormat("user thread %d").setThreadFactory(Executors.defaultThreadFactory()).build();
        ExecutorService executorService = DynamicExecutors.newScalingThreadPool((int)1, (int)20, (long)60000L, (ThreadFactory)factory);
        ImmutableMap.Builder locators = ImmutableMap.builder();
        for (File propertiesFile : options.propertiesFiles) {
            Properties properties = new Properties();
            try (FileInputStream is = new FileInputStream(propertiesFile);){
                properties.load(is);
            }
            properties.putAll((Map<?, ?>)System.getProperties());
            BlobStore blobStore = Main.createBlobStore(properties, executorService);
            blobStore = Main.parseMiddlewareProperties(blobStore, executorService, properties);
            String s3ProxyAuthorizationString = properties.getProperty("s3proxy.authorization");
            if (AuthenticationType.fromString(s3ProxyAuthorizationString) != AuthenticationType.NONE) {
                String localIdentity = properties.getProperty("s3proxy.identity");
                String localCredential = properties.getProperty("s3proxy.credential");
                locators.put((Object)localIdentity, (Object)Maps.immutableEntry((Object)localCredential, (Object)blobStore));
            }
            S3Proxy.Builder s3ProxyBuilder2 = S3Proxy.Builder.fromProperties(properties).blobStore(blobStore);
            if (s3ProxyBuilder != null && !s3ProxyBuilder.equals(s3ProxyBuilder2)) {
                System.err.println("Multiple configurations require identical s3proxy properties");
                System.exit(1);
            }
            s3ProxyBuilder = s3ProxyBuilder2;
        }
        try {
            s3Proxy = s3ProxyBuilder.build();
        }
        catch (IllegalArgumentException | IllegalStateException e) {
            System.err.println(e.getMessage());
            System.exit(1);
            throw e;
        }
        ImmutableMap locator = locators.build();
        if (!locator.isEmpty()) {
            s3Proxy.setBlobStoreLocator(new BlobStoreLocator((Map)locator){
                final /* synthetic */ Map val$locator;
                {
                    this.val$locator = map;
                }

                @Override
                public Map.Entry<String, BlobStore> locateBlobStore(String identity, String container, String blob) {
                    if (identity == null) {
                        if (this.val$locator.size() == 1) {
                            return (Map.Entry)this.val$locator.entrySet().iterator().next().getValue();
                        }
                        throw new IllegalArgumentException("cannot use anonymous access with multiple backends");
                    }
                    return (Map.Entry)this.val$locator.get(identity);
                }
            });
        }
        try {
            s3Proxy.start();
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
            System.exit(1);
        }
    }

    private static BlobStore parseMiddlewareProperties(BlobStore blobStore, ExecutorService executorService, Properties properties) throws IOException {
        String readOnlyBlobStore;
        String nullBlobStore;
        Properties altProperties = new Properties();
        for (Map.Entry<Object, Object> entry : properties.entrySet()) {
            String key = (String)entry.getKey();
            if (!key.startsWith("alt.")) continue;
            key = key.substring("alt.".length());
            altProperties.put(key, (String)entry.getValue());
        }
        String eventualConsistency = properties.getProperty("s3proxy.eventual-consistency");
        if ("true".equalsIgnoreCase(eventualConsistency)) {
            BlobStore altBlobStore = Main.createBlobStore(altProperties, executorService);
            int delay = Integer.parseInt(properties.getProperty("s3proxy.eventual-consistency.delay", "5"));
            double probability = Double.parseDouble(properties.getProperty("s3proxy.eventual-consistency.probability", "1.0"));
            System.err.println("Emulating eventual consistency with delay " + delay + " seconds and probability " + probability * 100.0 + "%");
            blobStore = EventualBlobStore.newEventualBlobStore(blobStore, altBlobStore, Executors.newScheduledThreadPool(1), delay, TimeUnit.SECONDS, probability);
        }
        if ("true".equalsIgnoreCase(nullBlobStore = properties.getProperty("s3proxy.null-blobstore"))) {
            System.err.println("Using null storage backend");
            blobStore = NullBlobStore.newNullBlobStore(blobStore);
        }
        if ("true".equalsIgnoreCase(readOnlyBlobStore = properties.getProperty("s3proxy.read-only-blobstore"))) {
            System.err.println("Using read-only storage backend");
            blobStore = ReadOnlyBlobStore.newReadOnlyBlobStore(blobStore);
        }
        return blobStore;
    }

    private static PrintStream createLoggerErrorPrintStream() {
        return new PrintStream(System.err){
            private final StringBuilder builder = new StringBuilder();

            @Override
            @SuppressFBWarnings(value={"SLF4J_SIGN_ONLY_FORMAT"})
            public void print(String string) {
                logger.error("{}", (Object)string);
            }

            @Override
            public void write(byte[] buf, int off, int len) {
                for (int i = off; i < len; ++i) {
                    char ch = (char)buf[i];
                    if (ch == '\n') {
                        if (this.builder.length() == 0) continue;
                        this.print(this.builder.toString());
                        this.builder.setLength(0);
                        continue;
                    }
                    this.builder.append(ch);
                }
            }
        };
    }

    private static BlobStore createBlobStore(Properties properties, ExecutorService executorService) throws IOException {
        BlobStoreContext context;
        String provider = properties.getProperty("jclouds.provider");
        String identity = properties.getProperty("jclouds.identity");
        String credential = properties.getProperty("jclouds.credential");
        String endpoint = properties.getProperty("jclouds.endpoint");
        properties.remove("jclouds.endpoint");
        String region = properties.getProperty("jclouds.region");
        if (provider == null) {
            System.err.println("Properties file must contain: jclouds.provider");
            System.exit(1);
        }
        if (provider.equals("filesystem") || provider.equals("transient")) {
            identity = Strings.nullToEmpty((String)identity);
            credential = Strings.nullToEmpty((String)credential);
        } else if (provider.equals("google-cloud-storage")) {
            File credentialFile = new File(credential);
            if (credentialFile.exists()) {
                credential = Files.asCharSource((File)credentialFile, (Charset)StandardCharsets.UTF_8).read();
            }
            properties.remove("jclouds.credential");
        }
        if (identity == null || credential == null) {
            System.err.println("Properties file must contain: jclouds.identity and jclouds.credential");
            System.exit(1);
        }
        properties.setProperty("jclouds.user-agent", String.format("s3proxy/%s jclouds/%s java/%s", Main.class.getPackage().getImplementationVersion(), JcloudsVersion.get(), System.getProperty("java.version")));
        ContextBuilder builder = ContextBuilder.newBuilder((String)provider).credentials(identity, credential).modules((Iterable)ImmutableList.of((Object)new SLF4JLoggingModule(), (Object)new ExecutorServiceModule(executorService))).overrides(properties);
        if (!Strings.isNullOrEmpty((String)endpoint)) {
            builder = builder.endpoint(endpoint);
        }
        BlobStore blobStore = (context = (BlobStoreContext)builder.build(BlobStoreContext.class)) instanceof RegionScopedBlobStoreContext && region != null ? ((RegionScopedBlobStoreContext)context).getBlobStore(region) : context.getBlobStore();
        return blobStore;
    }

    private static void usage(CmdLineParser parser) {
        System.err.println("Usage: s3proxy [options...]");
        parser.printUsage((OutputStream)System.err);
        System.exit(1);
    }

    private static final class Options {
        @Option(name="--properties", usage="S3Proxy configuration (required, multiple allowed)")
        private List<File> propertiesFiles = new ArrayList<File>();
        @Option(name="--version", usage="display version")
        private boolean version;

        private Options() {
        }
    }
}

