/*
 * Decompiled with CFR 0.152.
 */
package org.gaul.s3proxy;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.hash.HashCode;
import com.google.common.io.ByteSource;
import com.google.common.io.ByteStreams;
import com.google.common.primitives.Longs;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import javax.annotation.Nullable;
import org.jclouds.blobstore.BlobStore;
import org.jclouds.blobstore.domain.Blob;
import org.jclouds.blobstore.domain.BlobMetadata;
import org.jclouds.blobstore.domain.MultipartPart;
import org.jclouds.blobstore.domain.MultipartUpload;
import org.jclouds.blobstore.domain.PageSet;
import org.jclouds.blobstore.domain.StorageMetadata;
import org.jclouds.blobstore.domain.internal.MutableStorageMetadataImpl;
import org.jclouds.blobstore.domain.internal.PageSetImpl;
import org.jclouds.blobstore.options.GetOptions;
import org.jclouds.blobstore.options.PutOptions;
import org.jclouds.blobstore.util.ForwardingBlobStore;
import org.jclouds.io.Payload;
import org.jclouds.io.payloads.ByteSourcePayload;

final class NullBlobStore
extends ForwardingBlobStore {
    private NullBlobStore(BlobStore blobStore) {
        super(blobStore);
    }

    static BlobStore newNullBlobStore(BlobStore blobStore) {
        return new NullBlobStore(blobStore);
    }

    @Nullable
    public BlobMetadata blobMetadata(String container, String name) {
        Blob blob = this.getBlob(container, name);
        if (blob == null) {
            return null;
        }
        return blob.getMetadata();
    }

    @Nullable
    public Blob getBlob(String container, String name) {
        return this.getBlob(container, name, GetOptions.NONE);
    }

    @Nullable
    public Blob getBlob(String container, String name, GetOptions options) {
        byte[] array;
        Blob blob = super.getBlob(container, name, options);
        if (blob == null) {
            return null;
        }
        try (InputStream is = blob.getPayload().openStream();){
            array = ByteStreams.toByteArray((InputStream)is);
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
        long length = Longs.fromByteArray((byte[])array);
        ByteSourcePayload payload = new ByteSourcePayload(new NullByteSource().slice(0L, length));
        payload.setContentMetadata(blob.getPayload().getContentMetadata());
        payload.getContentMetadata().setContentLength(Long.valueOf(length));
        payload.getContentMetadata().setContentMD5((HashCode)null);
        blob.setPayload((Payload)payload);
        blob.getMetadata().setSize(Long.valueOf(length));
        return blob;
    }

    public PageSet<? extends StorageMetadata> list(String container) {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        PageSet pageSet = super.list(container);
        for (StorageMetadata sm : pageSet) {
            MutableStorageMetadataImpl msm = new MutableStorageMetadataImpl(sm);
            msm.setSize(Long.valueOf(0L));
            builder.add((Object)msm);
        }
        return new PageSetImpl((Iterable)builder.build(), pageSet.getNextMarker());
    }

    public String putBlob(String containerName, Blob blob) {
        return this.putBlob(containerName, blob, (PutOptions)PutOptions.NONE);
    }

    public String putBlob(String containerName, Blob blob, PutOptions options) {
        long length;
        try (InputStream is = blob.getPayload().openStream();){
            length = ByteStreams.copy((InputStream)is, (OutputStream)ByteStreams.nullOutputStream());
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
        byte[] array = Longs.toByteArray((long)length);
        ByteSourcePayload payload = new ByteSourcePayload(ByteSource.wrap((byte[])array));
        payload.setContentMetadata(blob.getPayload().getContentMetadata());
        payload.getContentMetadata().setContentLength(Long.valueOf(array.length));
        payload.getContentMetadata().setContentMD5((HashCode)null);
        blob.setPayload((Payload)payload);
        return super.putBlob(containerName, blob, options);
    }

    public String completeMultipartUpload(MultipartUpload mpu, List<MultipartPart> parts) {
        long length = 0L;
        for (MultipartPart part : parts) {
            length += part.partSize();
            super.removeBlob(mpu.containerName(), mpu.id() + "-" + part.partNumber());
        }
        byte[] array = Longs.toByteArray((long)length);
        ByteSourcePayload payload = new ByteSourcePayload(ByteSource.wrap((byte[])array));
        payload.getContentMetadata().setContentLength(Long.valueOf(array.length));
        super.abortMultipartUpload(mpu);
        MultipartUpload mpu2 = super.initiateMultipartUpload(mpu.containerName(), mpu.blobMetadata(), mpu.putOptions());
        MultipartPart part = super.uploadMultipartPart(mpu2, 1, (Payload)payload);
        return super.completeMultipartUpload(mpu2, (List)ImmutableList.of((Object)part));
    }

    public void abortMultipartUpload(MultipartUpload mpu) {
        for (MultipartPart part : super.listMultipartUpload(mpu)) {
            super.removeBlob(mpu.containerName(), mpu.id() + "-" + part.partNumber());
        }
        super.abortMultipartUpload(mpu);
    }

    public MultipartPart uploadMultipartPart(MultipartUpload mpu, int partNumber, Payload payload) {
        long length;
        try (InputStream is = payload.openStream();){
            length = ByteStreams.copy((InputStream)is, (OutputStream)ByteStreams.nullOutputStream());
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
        byte[] array = Longs.toByteArray((long)length);
        ByteSourcePayload newPayload = new ByteSourcePayload(ByteSource.wrap((byte[])array));
        newPayload.setContentMetadata(payload.getContentMetadata());
        newPayload.getContentMetadata().setContentLength(Long.valueOf(array.length));
        newPayload.getContentMetadata().setContentMD5((HashCode)null);
        Blob blob = this.blobBuilder(mpu.id() + "-" + partNumber).payload((Payload)newPayload).build();
        super.putBlob(mpu.containerName(), blob);
        MultipartPart part = super.uploadMultipartPart(mpu, partNumber, (Payload)newPayload);
        return MultipartPart.create((int)part.partNumber(), (long)length, (String)part.partETag(), (Date)part.lastModified());
    }

    public List<MultipartPart> listMultipartUpload(MultipartUpload mpu) {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (MultipartPart part : super.listMultipartUpload(mpu)) {
            Blob blob = this.getBlob(mpu.containerName(), mpu.id() + "-" + part.partNumber());
            long length = blob.getPayload().getContentMetadata().getContentLength();
            builder.add((Object)MultipartPart.create((int)part.partNumber(), (long)length, (String)part.partETag(), (Date)part.lastModified()));
        }
        return builder.build();
    }

    private static final class NullInputStream
    extends InputStream {
        private boolean closed;

        private NullInputStream() {
        }

        @Override
        public int read() throws IOException {
            if (this.closed) {
                throw new IOException("Stream already closed");
            }
            return 0;
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            if (this.closed) {
                throw new IOException("Stream already closed");
            }
            Arrays.fill(b, off, off + len, (byte)0);
            return len;
        }

        @Override
        public void close() throws IOException {
            super.close();
            this.closed = true;
        }
    }

    private static final class NullByteSource
    extends ByteSource {
        private NullByteSource() {
        }

        public InputStream openStream() throws IOException {
            return new NullInputStream();
        }
    }
}

