/*
 * Decompiled with CFR 0.152.
 */
package org.gaul.shaded.org.eclipse.jetty.server;

import java.io.IOException;
import java.nio.channels.SelectionKey;
import java.nio.channels.SocketChannel;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Executor;
import org.gaul.shaded.org.eclipse.jetty.io.ByteBufferPool;
import org.gaul.shaded.org.eclipse.jetty.io.NetworkTrafficListener;
import org.gaul.shaded.org.eclipse.jetty.io.NetworkTrafficSelectChannelEndPoint;
import org.gaul.shaded.org.eclipse.jetty.io.SelectChannelEndPoint;
import org.gaul.shaded.org.eclipse.jetty.io.SelectorManager;
import org.gaul.shaded.org.eclipse.jetty.server.ConnectionFactory;
import org.gaul.shaded.org.eclipse.jetty.server.HttpConnectionFactory;
import org.gaul.shaded.org.eclipse.jetty.server.Server;
import org.gaul.shaded.org.eclipse.jetty.server.ServerConnector;
import org.gaul.shaded.org.eclipse.jetty.util.ssl.SslContextFactory;
import org.gaul.shaded.org.eclipse.jetty.util.thread.Scheduler;

public class NetworkTrafficServerConnector
extends ServerConnector {
    private final List<NetworkTrafficListener> listeners = new CopyOnWriteArrayList<NetworkTrafficListener>();

    public NetworkTrafficServerConnector(Server server) {
        this(server, null, null, null, 0, 0, new HttpConnectionFactory());
    }

    public NetworkTrafficServerConnector(Server server, ConnectionFactory connectionFactory, SslContextFactory sslContextFactory) {
        super(server, sslContextFactory, connectionFactory);
    }

    public NetworkTrafficServerConnector(Server server, ConnectionFactory connectionFactory) {
        super(server, connectionFactory);
    }

    public NetworkTrafficServerConnector(Server server, Executor executor, Scheduler scheduler, ByteBufferPool pool, int acceptors, int selectors, ConnectionFactory ... factories) {
        super(server, executor, scheduler, pool, acceptors, selectors, factories);
    }

    public NetworkTrafficServerConnector(Server server, SslContextFactory sslContextFactory) {
        super(server, sslContextFactory);
    }

    public void addNetworkTrafficListener(NetworkTrafficListener listener) {
        this.listeners.add(listener);
    }

    public void removeNetworkTrafficListener(NetworkTrafficListener listener) {
        this.listeners.remove(listener);
    }

    @Override
    protected SelectChannelEndPoint newEndPoint(SocketChannel channel, SelectorManager.ManagedSelector selectSet, SelectionKey key) throws IOException {
        NetworkTrafficSelectChannelEndPoint endPoint = new NetworkTrafficSelectChannelEndPoint(channel, selectSet, key, this.getScheduler(), this.getIdleTimeout(), this.listeners);
        return endPoint;
    }
}

