/*
 * Decompiled with CFR 0.152.
 */
package org.gaul.shaded.org.eclipse.jetty.util;

import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.channels.UnresolvedAddressException;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import org.gaul.shaded.org.eclipse.jetty.util.Promise;
import org.gaul.shaded.org.eclipse.jetty.util.log.Log;
import org.gaul.shaded.org.eclipse.jetty.util.log.Logger;
import org.gaul.shaded.org.eclipse.jetty.util.thread.Scheduler;

public interface SocketAddressResolver {
    public void resolve(String var1, int var2, Promise<SocketAddress> var3);

    public static class Async
    implements SocketAddressResolver {
        private static final Logger LOG = Log.getLogger(SocketAddressResolver.class);
        private final Executor executor;
        private final Scheduler scheduler;
        private final long timeout;

        public Async(Executor executor, Scheduler scheduler, long timeout) {
            this.executor = executor;
            this.scheduler = scheduler;
            this.timeout = timeout;
        }

        public Executor getExecutor() {
            return this.executor;
        }

        public Scheduler getScheduler() {
            return this.scheduler;
        }

        public long getTimeout() {
            return this.timeout;
        }

        @Override
        public void resolve(final String host, final int port, final Promise<SocketAddress> promise) {
            this.executor.execute(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    Scheduler.Task task = null;
                    final AtomicBoolean complete = new AtomicBoolean();
                    if (Async.this.timeout > 0L) {
                        final Thread thread = Thread.currentThread();
                        task = Async.this.scheduler.schedule(new Runnable(){

                            @Override
                            public void run() {
                                if (complete.compareAndSet(false, true)) {
                                    promise.failed(new TimeoutException());
                                    thread.interrupt();
                                }
                            }
                        }, Async.this.timeout, TimeUnit.MILLISECONDS);
                    }
                    try {
                        long start = System.nanoTime();
                        InetSocketAddress result = new InetSocketAddress(host, port);
                        long elapsed = System.nanoTime() - start;
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("Resolved {} in {} ms", host, TimeUnit.NANOSECONDS.toMillis(elapsed));
                        }
                        if (complete.compareAndSet(false, true)) {
                            if (result.isUnresolved()) {
                                promise.failed(new UnresolvedAddressException());
                            } else {
                                promise.succeeded(result);
                            }
                        }
                    }
                    catch (Throwable x) {
                        if (complete.compareAndSet(false, true)) {
                            promise.failed(x);
                        }
                    }
                    finally {
                        if (task != null) {
                            task.cancel();
                        }
                        Thread.interrupted();
                    }
                }
            });
        }
    }

    public static class Sync
    implements SocketAddressResolver {
        @Override
        public void resolve(String host, int port, Promise<SocketAddress> promise) {
            try {
                InetSocketAddress result = new InetSocketAddress(host, port);
                if (result.isUnresolved()) {
                    promise.failed(new UnresolvedAddressException());
                } else {
                    promise.succeeded(result);
                }
            }
            catch (Throwable x) {
                promise.failed(x);
            }
        }
    }
}

