/*
 * Decompiled with CFR 0.152.
 */
package org.gaul.s3proxy;

import com.google.common.base.Preconditions;
import com.google.common.collect.BiMap;
import com.google.common.collect.ImmutableBiMap;
import com.google.common.collect.ImmutableList;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.Properties;
import org.jclouds.blobstore.BlobStore;
import org.jclouds.blobstore.domain.Blob;
import org.jclouds.blobstore.domain.BlobMetadata;
import org.jclouds.blobstore.domain.ContainerAccess;
import org.jclouds.blobstore.domain.MultipartPart;
import org.jclouds.blobstore.domain.MultipartUpload;
import org.jclouds.blobstore.domain.PageSet;
import org.jclouds.blobstore.domain.StorageMetadata;
import org.jclouds.blobstore.domain.internal.MutableStorageMetadataImpl;
import org.jclouds.blobstore.domain.internal.PageSetImpl;
import org.jclouds.blobstore.options.CopyOptions;
import org.jclouds.blobstore.options.CreateContainerOptions;
import org.jclouds.blobstore.options.GetOptions;
import org.jclouds.blobstore.options.ListContainerOptions;
import org.jclouds.blobstore.options.PutOptions;
import org.jclouds.blobstore.util.ForwardingBlobStore;
import org.jclouds.domain.Location;
import org.jclouds.io.Payload;

public final class AliasBlobStore
extends ForwardingBlobStore {
    private final BiMap<String, String> aliases;

    private AliasBlobStore(BlobStore delegate, BiMap<String, String> aliases) {
        super(delegate);
        this.aliases = Objects.requireNonNull(aliases);
    }

    static BlobStore newAliasBlobStore(BlobStore delegate, BiMap<String, String> aliases) {
        return new AliasBlobStore(delegate, aliases);
    }

    private MultipartUpload getDelegateMpu(MultipartUpload mpu) {
        return MultipartUpload.create((String)this.getContainer(mpu.containerName()), (String)mpu.blobName(), (String)mpu.id(), (BlobMetadata)mpu.blobMetadata(), (PutOptions)mpu.putOptions());
    }

    public static ImmutableBiMap<String, String> parseAliases(Properties properties) {
        HashMap<String, String> backendBuckets = new HashMap<String, String>();
        for (String key : properties.stringPropertyNames()) {
            if (!key.startsWith("s3proxy.alias-blobstore")) continue;
            String virtualBucket = key.substring("s3proxy.alias-blobstore".length() + 1);
            String backendBucket = properties.getProperty(key);
            Preconditions.checkArgument((!backendBuckets.containsKey(backendBucket) ? 1 : 0) != 0, (String)"Backend bucket %s is aliased twice", (Object)backendBucket);
            backendBuckets.put(backendBucket, virtualBucket);
        }
        return ImmutableBiMap.copyOf(backendBuckets).inverse();
    }

    private String getContainer(String container) {
        return (String)this.aliases.getOrDefault((Object)container, (Object)container);
    }

    public boolean createContainerInLocation(Location location, String container) {
        return this.delegate().createContainerInLocation(location, this.getContainer(container));
    }

    public boolean createContainerInLocation(Location location, String container, CreateContainerOptions options) {
        return this.delegate().createContainerInLocation(location, this.getContainer(container), options);
    }

    public boolean containerExists(String container) {
        return this.delegate().containerExists(this.getContainer(container));
    }

    public ContainerAccess getContainerAccess(String container) {
        return this.delegate().getContainerAccess(this.getContainer(container));
    }

    public void setContainerAccess(String container, ContainerAccess containerAccess) {
        this.delegate().setContainerAccess(this.getContainer(container), containerAccess);
    }

    public PageSet<? extends StorageMetadata> list() {
        PageSet upstream = this.delegate().list();
        ImmutableList.Builder results = new ImmutableList.Builder();
        for (StorageMetadata sm : upstream) {
            if (this.aliases.containsValue((Object)sm.getName())) {
                MutableStorageMetadataImpl bucketAlias = new MutableStorageMetadataImpl();
                bucketAlias.setName((String)this.aliases.inverse().get((Object)sm.getName()));
                bucketAlias.setCreationDate(sm.getCreationDate());
                bucketAlias.setETag(sm.getETag());
                bucketAlias.setId(sm.getProviderId());
                bucketAlias.setLastModified(sm.getLastModified());
                bucketAlias.setLocation(sm.getLocation());
                bucketAlias.setSize(sm.getSize());
                bucketAlias.setTier(sm.getTier());
                bucketAlias.setType((Enum)sm.getType());
                bucketAlias.setUri(sm.getUri());
                bucketAlias.setUserMetadata(sm.getUserMetadata());
                results.add((Object)bucketAlias);
                continue;
            }
            results.add((Object)sm);
        }
        return new PageSetImpl((Iterable)results.build(), upstream.getNextMarker());
    }

    public PageSet<? extends StorageMetadata> list(String container) {
        return this.delegate().list(this.getContainer(container));
    }

    public PageSet<? extends StorageMetadata> list(String container, ListContainerOptions options) {
        return this.delegate().list(this.getContainer(container), options);
    }

    public void clearContainer(String container) {
        this.delegate().clearContainer(this.getContainer(container));
    }

    public void clearContainer(String container, ListContainerOptions options) {
        this.delegate().clearContainer(this.getContainer(container), options);
    }

    public void deleteContainer(String container) {
        this.delegate().deleteContainer(this.getContainer(container));
    }

    public boolean deleteContainerIfEmpty(String container) {
        return this.delegate().deleteContainerIfEmpty(this.getContainer(container));
    }

    public boolean directoryExists(String container, String directory) {
        return this.delegate().directoryExists(this.getContainer(container), directory);
    }

    public void createDirectory(String container, String directory) {
        this.delegate().createDirectory(this.getContainer(container), directory);
    }

    public void deleteDirectory(String container, String directory) {
        this.delegate().deleteDirectory(this.getContainer(container), directory);
    }

    public boolean blobExists(String container, String name) {
        return this.delegate().blobExists(this.getContainer(container), name);
    }

    public BlobMetadata blobMetadata(String container, String name) {
        return this.delegate().blobMetadata(this.getContainer(container), name);
    }

    public Blob getBlob(String containerName, String blobName) {
        return this.delegate().getBlob(this.getContainer(containerName), blobName);
    }

    public Blob getBlob(String containerName, String blobName, GetOptions getOptions) {
        return this.delegate().getBlob(this.getContainer(containerName), blobName, getOptions);
    }

    public String putBlob(String containerName, Blob blob) {
        return this.delegate().putBlob(this.getContainer(containerName), blob);
    }

    public String putBlob(String containerName, Blob blob, PutOptions options) {
        return this.delegate().putBlob(this.getContainer(containerName), blob, options);
    }

    public void removeBlob(String containerName, String blobName) {
        this.delegate().removeBlob(this.getContainer(containerName), blobName);
    }

    public void removeBlobs(String containerName, Iterable<String> blobNames) {
        this.delegate().removeBlobs(this.getContainer(containerName), blobNames);
    }

    public String copyBlob(String fromContainer, String fromName, String toContainer, String toName, CopyOptions options) {
        return this.delegate().copyBlob(this.getContainer(fromContainer), fromName, this.getContainer(toContainer), toName, options);
    }

    public MultipartUpload initiateMultipartUpload(String container, BlobMetadata blobMetadata, PutOptions options) {
        MultipartUpload mpu = this.delegate().initiateMultipartUpload(this.getContainer(container), blobMetadata, options);
        return MultipartUpload.create((String)container, (String)blobMetadata.getName(), (String)mpu.id(), (BlobMetadata)mpu.blobMetadata(), (PutOptions)mpu.putOptions());
    }

    public void abortMultipartUpload(MultipartUpload mpu) {
        this.delegate().abortMultipartUpload(this.getDelegateMpu(mpu));
    }

    public String completeMultipartUpload(MultipartUpload mpu, List<MultipartPart> parts) {
        return this.delegate().completeMultipartUpload(this.getDelegateMpu(mpu), parts);
    }

    public MultipartPart uploadMultipartPart(MultipartUpload mpu, int partNumber, Payload payload) {
        return this.delegate().uploadMultipartPart(this.getDelegateMpu(mpu), partNumber, payload);
    }
}

