/*
 * Decompiled with CFR 0.152.
 */
package org.gaul.s3proxy;

import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.TreeMultimap;
import com.google.common.io.BaseEncoding;
import com.google.common.net.PercentEscaper;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import javax.servlet.http.HttpServletRequest;
import org.gaul.s3proxy.S3AuthorizationHeader;
import org.gaul.s3proxy.S3Exception;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class AwsSignature {
    private static final Logger logger = LoggerFactory.getLogger(AwsSignature.class);
    private static final PercentEscaper AWS_URL_PARAMETER_ESCAPER = new PercentEscaper("-_.~", false);
    private static final Set<String> SIGNED_SUBRESOURCES = ImmutableSet.of((Object)"acl", (Object)"delete", (Object)"lifecycle", (Object)"location", (Object)"logging", (Object)"notification", (Object[])new String[]{"partNumber", "policy", "requestPayment", "response-cache-control", "response-content-disposition", "response-content-encoding", "response-content-language", "response-content-type", "response-expires", "torrent", "uploadId", "uploads", "versionId", "versioning", "versions", "website"});
    private static final Pattern REPEATING_WHITESPACE = Pattern.compile("\\s+");

    private AwsSignature() {
    }

    static String createAuthorizationSignature(HttpServletRequest request, String uri, String credential, boolean queryAuth, boolean bothDateHeader) {
        Mac mac;
        TreeMultimap canonicalizedHeaders = TreeMultimap.create();
        for (String headerName : Collections.list(request.getHeaderNames())) {
            ArrayList headerValues = Collections.list(request.getHeaders(headerName));
            if (!(headerName = headerName.toLowerCase()).startsWith("x-amz-") || bothDateHeader && headerName.equalsIgnoreCase("x-amz-date")) continue;
            if (headerValues.isEmpty()) {
                canonicalizedHeaders.put((Object)headerName, (Object)"");
            }
            Iterator iterator = headerValues.iterator();
            while (iterator.hasNext()) {
                String headerValue = (String)iterator.next();
                canonicalizedHeaders.put((Object)headerName, (Object)Strings.nullToEmpty((String)headerValue));
            }
        }
        StringBuilder builder = new StringBuilder().append(request.getMethod()).append('\n').append(Strings.nullToEmpty((String)request.getHeader("Content-MD5"))).append('\n').append(Strings.nullToEmpty((String)request.getHeader("Content-Type"))).append('\n');
        String expires = request.getParameter("Expires");
        if (queryAuth) {
            builder.append(Strings.nullToEmpty((String)expires));
        } else if (!bothDateHeader) {
            if (canonicalizedHeaders.containsKey((Object)"x-amz-date")) {
                builder.append("");
            } else {
                builder.append(request.getHeader("Date"));
            }
        } else if (!canonicalizedHeaders.containsKey((Object)"x-amz-date")) {
            builder.append(request.getHeader("x-amz-date"));
        }
        builder.append('\n');
        for (Map.Entry entry : canonicalizedHeaders.entries()) {
            builder.append((String)entry.getKey()).append(':').append((String)entry.getValue()).append('\n');
        }
        builder.append(uri);
        int separator = 63;
        ArrayList<String> subresources = Collections.list(request.getParameterNames());
        Collections.sort(subresources);
        for (String subresource : subresources) {
            if (!SIGNED_SUBRESOURCES.contains(subresource)) continue;
            builder.append((char)separator).append(subresource);
            String value = request.getParameter(subresource);
            if (!"".equals(value)) {
                builder.append('=').append(value);
            }
            separator = 38;
        }
        String stringToSign = builder.toString();
        logger.trace("stringToSign: {}", (Object)stringToSign);
        try {
            mac = Mac.getInstance("HmacSHA1");
            mac.init(new SecretKeySpec(credential.getBytes(StandardCharsets.UTF_8), "HmacSHA1"));
        }
        catch (InvalidKeyException | NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
        return Base64.getEncoder().encodeToString(mac.doFinal(stringToSign.getBytes(StandardCharsets.UTF_8)));
    }

    private static byte[] signMessage(byte[] data, byte[] key, String algorithm) throws InvalidKeyException, NoSuchAlgorithmException {
        Mac mac = Mac.getInstance(algorithm);
        mac.init(new SecretKeySpec(key, algorithm));
        return mac.doFinal(data);
    }

    private static String getMessageDigest(byte[] payload, String algorithm) throws NoSuchAlgorithmException {
        MessageDigest md = MessageDigest.getInstance(algorithm);
        byte[] hash = md.digest(payload);
        return BaseEncoding.base16().lowerCase().encode(hash);
    }

    @Nullable
    private static List<String> extractSignedHeaders(String authorization) {
        int index = authorization.indexOf("SignedHeaders=");
        if (index < 0) {
            return null;
        }
        int endSigned = authorization.indexOf(44, index);
        if (endSigned < 0) {
            return null;
        }
        int startHeaders = authorization.indexOf(61, index);
        return Splitter.on((char)';').splitToList((CharSequence)authorization.substring(startHeaders + 1, endSigned));
    }

    private static String buildCanonicalHeaders(HttpServletRequest request, List<String> signedHeaders) {
        ArrayList<String> headers = new ArrayList<String>(signedHeaders.size());
        for (String header : signedHeaders) {
            headers.add(header.toLowerCase());
        }
        Collections.sort(headers);
        StringBuilder headersWithValues = new StringBuilder();
        boolean firstHeader = true;
        for (String header : headers) {
            if (firstHeader) {
                firstHeader = false;
            } else {
                headersWithValues.append('\n');
            }
            headersWithValues.append(header);
            headersWithValues.append(':');
            boolean firstValue = true;
            for (String value : Collections.list(request.getHeaders(header))) {
                if (firstValue) {
                    firstValue = false;
                } else {
                    headersWithValues.append(',');
                }
                value = value.trim();
                if (!value.startsWith("\"")) {
                    value = REPEATING_WHITESPACE.matcher(value).replaceAll(" ");
                }
                headersWithValues.append(value);
            }
        }
        return headersWithValues.toString();
    }

    private static String buildCanonicalQueryString(HttpServletRequest request) throws UnsupportedEncodingException {
        ArrayList<String> parameters = Collections.list(request.getParameterNames());
        Collections.sort(parameters);
        ArrayList<String> queryParameters = new ArrayList<String>();
        for (String key : parameters) {
            if (key.equals("X-Amz-Signature")) continue;
            String value = request.getParameter(key);
            queryParameters.add(AWS_URL_PARAMETER_ESCAPER.escape(key) + "=" + AWS_URL_PARAMETER_ESCAPER.escape(value));
        }
        return Joiner.on((String)"&").join(queryParameters);
    }

    private static String createCanonicalRequest(HttpServletRequest request, String uri, byte[] payload, String hashAlgorithm) throws IOException, NoSuchAlgorithmException {
        String corsMethod;
        String authorizationHeader = request.getHeader("Authorization");
        String xAmzContentSha256 = request.getHeader("x-amz-content-sha256");
        if (xAmzContentSha256 == null) {
            xAmzContentSha256 = request.getParameter("X-Amz-SignedHeaders");
        }
        String digest = authorizationHeader == null ? "UNSIGNED-PAYLOAD" : ("STREAMING-AWS4-HMAC-SHA256-PAYLOAD".equals(xAmzContentSha256) ? "STREAMING-AWS4-HMAC-SHA256-PAYLOAD" : ("UNSIGNED-PAYLOAD".equals(xAmzContentSha256) ? "UNSIGNED-PAYLOAD" : AwsSignature.getMessageDigest(payload, hashAlgorithm)));
        List signedHeaders = authorizationHeader != null ? AwsSignature.extractSignedHeaders(authorizationHeader) : Splitter.on((char)';').splitToList((CharSequence)request.getParameter("X-Amz-SignedHeaders"));
        String method = request.getMethod();
        if ("OPTIONS".equals(method) && (corsMethod = request.getHeader("Access-Control-Request-Method")) != null) {
            method = corsMethod;
        }
        String canonicalRequest = Joiner.on((String)"\n").join((Object)method, (Object)uri, new Object[]{AwsSignature.buildCanonicalQueryString(request), AwsSignature.buildCanonicalHeaders(request, signedHeaders) + "\n", Joiner.on((char)';').join((Iterable)signedHeaders), digest});
        return AwsSignature.getMessageDigest(canonicalRequest.getBytes(StandardCharsets.UTF_8), hashAlgorithm);
    }

    static String createAuthorizationSignatureV4(HttpServletRequest request, S3AuthorizationHeader authHeader, byte[] payload, String uri, String credential) throws InvalidKeyException, IOException, NoSuchAlgorithmException, S3Exception {
        String canonicalRequest = AwsSignature.createCanonicalRequest(request, uri, payload, authHeader.getHashAlgorithm());
        String algorithm = authHeader.getHmacAlgorithm();
        byte[] dateKey = AwsSignature.signMessage(authHeader.getDate().getBytes(StandardCharsets.UTF_8), ("AWS4" + credential).getBytes(StandardCharsets.UTF_8), algorithm);
        byte[] dateRegionKey = AwsSignature.signMessage(authHeader.getRegion().getBytes(StandardCharsets.UTF_8), dateKey, algorithm);
        byte[] dateRegionServiceKey = AwsSignature.signMessage(authHeader.getService().getBytes(StandardCharsets.UTF_8), dateRegionKey, algorithm);
        byte[] signingKey = AwsSignature.signMessage("aws4_request".getBytes(StandardCharsets.UTF_8), dateRegionServiceKey, algorithm);
        String date = request.getHeader("x-amz-date");
        if (date == null) {
            date = request.getParameter("X-Amz-Date");
        }
        String signatureString = "AWS4-HMAC-SHA256\n" + date + "\n" + authHeader.getDate() + "/" + authHeader.getRegion() + "/s3/aws4_request\n" + canonicalRequest;
        byte[] signature = AwsSignature.signMessage(signatureString.getBytes(StandardCharsets.UTF_8), signingKey, algorithm);
        return BaseEncoding.base16().lowerCase().encode(signature);
    }
}

