/*
 * Decompiled with CFR 0.152.
 */
package org.gaul.s3proxy;

import com.google.common.base.Preconditions;
import java.util.Deque;
import java.util.List;
import java.util.Objects;
import java.util.Random;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.jclouds.blobstore.BlobStore;
import org.jclouds.blobstore.domain.Blob;
import org.jclouds.blobstore.domain.BlobMetadata;
import org.jclouds.blobstore.domain.MultipartPart;
import org.jclouds.blobstore.domain.MultipartUpload;
import org.jclouds.blobstore.options.CopyOptions;
import org.jclouds.blobstore.options.CreateContainerOptions;
import org.jclouds.blobstore.options.PutOptions;
import org.jclouds.blobstore.util.ForwardingBlobStore;
import org.jclouds.domain.Location;
import org.jclouds.io.Payload;

final class EventualBlobStore
extends ForwardingBlobStore {
    private final BlobStore writeStore;
    private final ScheduledExecutorService executorService;
    private final Deque<Callable<?>> deque = new ConcurrentLinkedDeque();
    private final int delay;
    private final TimeUnit delayUnit;
    private final double probability;
    private final Random random = new Random();

    private EventualBlobStore(BlobStore writeStore, BlobStore readStore, ScheduledExecutorService executorService, int delay, TimeUnit delayUnit, double probability) {
        super(readStore);
        this.writeStore = Objects.requireNonNull(writeStore);
        this.executorService = Objects.requireNonNull(executorService);
        Preconditions.checkArgument((delay >= 0 ? 1 : 0) != 0, (String)"Delay must be at least zero, was: %s", (int)delay);
        this.delay = delay;
        this.delayUnit = Objects.requireNonNull(delayUnit);
        Preconditions.checkArgument((probability >= 0.0 && probability <= 1.0 ? 1 : 0) != 0, (String)"Probability must be between 0.0 and 1.0, was: %s", (Object)probability);
        this.probability = probability;
    }

    static BlobStore newEventualBlobStore(BlobStore writeStore, BlobStore readStore, ScheduledExecutorService executorService, int delay, TimeUnit delayUnit, double probability) {
        return new EventualBlobStore(writeStore, readStore, executorService, delay, delayUnit, probability);
    }

    public boolean createContainerInLocation(Location location, String container, CreateContainerOptions options) {
        return this.delegate().createContainerInLocation(location, container, options) && this.writeStore.createContainerInLocation(location, container, options);
    }

    public void deleteContainer(String container) {
        this.delegate().deleteContainer(container);
        this.writeStore.deleteContainer(container);
    }

    public boolean deleteContainerIfEmpty(String container) {
        return this.delegate().deleteContainerIfEmpty(container) && this.writeStore.deleteContainerIfEmpty(container);
    }

    public String putBlob(String containerName, Blob blob) {
        return this.putBlob(containerName, blob, (PutOptions)PutOptions.NONE);
    }

    public String putBlob(final String containerName, Blob blob, final PutOptions options) {
        final String nearName = blob.getMetadata().getName();
        String nearETag = this.writeStore.putBlob(containerName, blob, options);
        this.schedule(new Callable<String>(){

            @Override
            public String call() {
                Blob nearBlob = EventualBlobStore.this.writeStore.getBlob(containerName, nearName);
                String farETag = EventualBlobStore.this.delegate().putBlob(containerName, nearBlob, options);
                return farETag;
            }
        });
        return nearETag;
    }

    public void removeBlob(final String containerName, final String blobName) {
        this.writeStore.removeBlob(containerName, blobName);
        this.schedule(new Callable<Void>(){

            @Override
            public Void call() {
                EventualBlobStore.this.delegate().removeBlob(containerName, blobName);
                return null;
            }
        });
    }

    public void removeBlobs(final String containerName, final Iterable<String> blobNames) {
        this.writeStore.removeBlobs(containerName, blobNames);
        this.schedule(new Callable<Void>(){

            @Override
            public Void call() {
                EventualBlobStore.this.delegate().removeBlobs(containerName, blobNames);
                return null;
            }
        });
    }

    public String copyBlob(final String fromContainer, final String fromName, final String toContainer, final String toName, final CopyOptions options) {
        String nearETag = this.writeStore.copyBlob(fromContainer, fromName, toContainer, toName, options);
        this.schedule(new Callable<String>(){

            @Override
            public String call() {
                return EventualBlobStore.this.delegate().copyBlob(fromContainer, fromName, toContainer, toName, options);
            }
        });
        return nearETag;
    }

    public MultipartUpload initiateMultipartUpload(String container, BlobMetadata blobMetadata, PutOptions options) {
        MultipartUpload mpu = this.delegate().initiateMultipartUpload(container, blobMetadata, options);
        return mpu;
    }

    public void abortMultipartUpload(MultipartUpload mpu) {
        this.delegate().abortMultipartUpload(mpu);
    }

    public String completeMultipartUpload(final MultipartUpload mpu, final List<MultipartPart> parts) {
        this.schedule(new Callable<String>(){

            @Override
            public String call() {
                String farETag = EventualBlobStore.this.delegate().completeMultipartUpload(mpu, parts);
                return farETag;
            }
        });
        return "";
    }

    public MultipartPart uploadMultipartPart(MultipartUpload mpu, int partNumber, Payload payload) {
        MultipartPart part = this.delegate().uploadMultipartPart(mpu, partNumber, payload);
        return part;
    }

    private void schedule(Callable<?> callable) {
        if (this.random.nextDouble() < this.probability) {
            this.deque.add(callable);
            this.executorService.schedule(new DequeCallable(), (long)this.delay, this.delayUnit);
        }
    }

    private final class DequeCallable
    implements Callable<Void> {
        private DequeCallable() {
        }

        @Override
        public Void call() throws Exception {
            ((Callable)EventualBlobStore.this.deque.poll()).call();
            return null;
        }
    }
}

