/*
 * Decompiled with CFR 0.152.
 */
package org.gaul.s3proxy;

import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import javax.annotation.Nullable;
import org.gaul.s3proxy.AuthenticationType;

final class S3AuthorizationHeader {
    private static final ImmutableMap<String, String> DIGEST_MAP = ImmutableMap.builder().put((Object)"SHA256", (Object)"SHA-256").put((Object)"SHA1", (Object)"SHA-1").put((Object)"MD5", (Object)"MD5").build();
    private static final String SIGNATURE_FIELD = "Signature=";
    private static final String CREDENTIAL_FIELD = "Credential=";
    private final AuthenticationType authenticationType;
    @Nullable
    private final String hmacAlgorithm;
    @Nullable
    private final String hashAlgorithm;
    @Nullable
    private final String region;
    @Nullable
    private final String date;
    @Nullable
    private final String service;
    private final String identity;
    private final String signature;

    S3AuthorizationHeader(String header) {
        if (header.startsWith("AWS ")) {
            this.authenticationType = AuthenticationType.AWS_V2;
            this.hmacAlgorithm = null;
            this.hashAlgorithm = null;
            this.region = null;
            this.date = null;
            this.service = null;
            List fields = Splitter.on((char)' ').splitToList((CharSequence)header);
            if (fields.size() != 2) {
                throw new IllegalArgumentException("Invalid header");
            }
            List identityTuple = Splitter.on((char)':').splitToList((CharSequence)fields.get(1));
            if (identityTuple.size() != 2) {
                throw new IllegalArgumentException("Invalid header");
            }
            this.identity = (String)identityTuple.get(0);
            this.signature = (String)identityTuple.get(1);
        } else if (header.startsWith("AWS4-HMAC")) {
            this.authenticationType = AuthenticationType.AWS_V4;
            this.signature = S3AuthorizationHeader.extractSignature(header);
            int credentialIndex = header.indexOf(CREDENTIAL_FIELD);
            if (credentialIndex < 0) {
                throw new IllegalArgumentException("Invalid header");
            }
            int credentialEnd = header.indexOf(44, credentialIndex);
            if (credentialEnd < 0) {
                throw new IllegalArgumentException("Invalid header");
            }
            String credential = header.substring(credentialIndex + CREDENTIAL_FIELD.length(), credentialEnd);
            List fields = Splitter.on((char)'/').splitToList((CharSequence)credential);
            if (fields.size() != 5) {
                throw new IllegalArgumentException("Invalid Credential: " + credential);
            }
            this.identity = (String)fields.get(0);
            this.date = (String)fields.get(1);
            this.region = (String)fields.get(2);
            this.service = (String)fields.get(3);
            String awsSignatureVersion = header.substring(0, header.indexOf(32));
            this.hashAlgorithm = (String)DIGEST_MAP.get(Splitter.on((char)'-').splitToList((CharSequence)awsSignatureVersion).get(2));
            this.hmacAlgorithm = "Hmac" + (String)Splitter.on((char)'-').splitToList((CharSequence)awsSignatureVersion).get(2);
        } else {
            throw new IllegalArgumentException("Invalid header");
        }
    }

    public String toString() {
        return "Identity: " + this.identity + "; Signature: " + this.signature + "; HMAC algorithm: " + this.hmacAlgorithm + "; Hash algorithm: " + this.hashAlgorithm + "; region: " + this.region + "; date: " + this.date + "; service " + this.service;
    }

    private static String extractSignature(String header) {
        int signatureIndex = header.indexOf(SIGNATURE_FIELD);
        if (signatureIndex < 0) {
            throw new IllegalArgumentException("Invalid signature");
        }
        int signatureEnd = header.indexOf(44, signatureIndex += SIGNATURE_FIELD.length());
        if (signatureEnd < 0) {
            return header.substring(signatureIndex);
        }
        return header.substring(signatureIndex, signatureEnd);
    }

    public AuthenticationType getAuthenticationType() {
        return this.authenticationType;
    }

    public String getHmacAlgorithm() {
        return this.hmacAlgorithm;
    }

    public String getHashAlgorithm() {
        return this.hashAlgorithm;
    }

    public String getRegion() {
        return this.region;
    }

    public String getDate() {
        return this.date;
    }

    public String getService() {
        return this.service;
    }

    public String getIdentity() {
        return this.identity;
    }

    public String getSignature() {
        return this.signature;
    }
}

