/*
 * Decompiled with CFR 0.152.
 */
package org.gaul.s3proxy;

import com.google.common.base.CaseFormat;
import java.util.Objects;

enum S3ErrorCode {
    ACCESS_DENIED(403, "Forbidden"),
    BAD_DIGEST(400, "Bad Request"),
    BUCKET_ALREADY_EXISTS(403, "The requested bucket name is not available. The bucket namespace is shared by all users of the system. Please select a different name and try again."),
    BUCKET_ALREADY_OWNED_BY_YOU(409, "Your previous request to create the named bucket succeeded and you already own it."),
    BUCKET_NOT_EMPTY(409, "The bucket you tried to delete is not empty"),
    ENTITY_TOO_LARGE(400, "Your proposed upload exceeds the maximum allowed object size."),
    ENTITY_TOO_SMALL(400, "Your proposed upload is smaller than the minimum allowed object size. Each part must be at least 5 MB in size, except the last part."),
    INVALID_ACCESS_KEY_ID(403, "Forbidden"),
    INVALID_ARGUMENT(400, "Bad Request"),
    INVALID_BUCKET_NAME(400, "The specified bucket is not valid."),
    INVALID_CORS_ORIGIN(400, "Insufficient information. Origin request header needed."),
    INVALID_CORS_METHOD(400, "The specified Access-Control-Request-Method is not valid."),
    INVALID_DIGEST(400, "Bad Request"),
    INVALID_LOCATION_CONSTRAINT(400, "The specified location constraint is not valid. For more information about Regions, see How to Select a Region for Your Buckets."),
    INVALID_RANGE(416, "The requested range is not satisfiable"),
    INVALID_PART(400, "One or more of the specified parts could not be found.  The part may not have been uploaded, or the specified entity tag may not match the part's entity tag."),
    INVALID_REQUEST(400, "Bad Request"),
    MALFORMED_X_M_L(400, "The XML you provided was not well-formed or did not validate against our published schema."),
    MAX_MESSAGE_LENGTH_EXCEEDED(400, "Your request was too big."),
    METHOD_NOT_ALLOWED(405, "Method Not Allowed"),
    MISSING_CONTENT_LENGTH(411, "Length Required"),
    NO_SUCH_BUCKET(404, "The specified bucket does not exist"),
    NO_SUCH_KEY(404, "The specified key does not exist."),
    NO_SUCH_POLICY(404, "The specified bucket does not have a bucket policy."),
    NO_SUCH_UPLOAD(404, "Not Found"),
    NOT_IMPLEMENTED(501, "A header you provided implies functionality that is not implemented."),
    PRECONDITION_FAILED(412, "At least one of the preconditions you specified did not hold."),
    REQUEST_TIME_TOO_SKEWED(403, "Forbidden"),
    REQUEST_TIMEOUT(400, "Bad Request"),
    SIGNATURE_DOES_NOT_MATCH(403, "Forbidden"),
    X_AMZ_CONTENT_S_H_A_256_MISMATCH(400, "The provided 'x-amz-content-sha256' header does not match what was computed.");

    private final String errorCode = CaseFormat.UPPER_UNDERSCORE.to(CaseFormat.UPPER_CAMEL, this.name());
    private final int httpStatusCode;
    private final String message;

    private S3ErrorCode(int httpStatusCode, String message) {
        this.httpStatusCode = httpStatusCode;
        this.message = Objects.requireNonNull(message);
    }

    String getErrorCode() {
        return this.errorCode;
    }

    int getHttpStatusCode() {
        return this.httpStatusCode;
    }

    String getMessage() {
        return this.message;
    }

    public String toString() {
        return this.getHttpStatusCode() + " " + this.getErrorCode() + " " + this.getMessage();
    }
}

