/*
 * Decompiled with CFR 0.152.
 */
package org.gaul.s3proxy;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Properties;
import org.gaul.s3proxy.AuthenticationType;
import org.gaul.s3proxy.BlobStoreLocator;
import org.gaul.s3proxy.CrossOriginResourceSharing;
import org.gaul.s3proxy.S3ProxyHandlerJetty;
import org.gaul.shaded.org.eclipse.jetty.http.HttpCompliance;
import org.gaul.shaded.org.eclipse.jetty.server.HttpConfiguration;
import org.gaul.shaded.org.eclipse.jetty.server.HttpConnectionFactory;
import org.gaul.shaded.org.eclipse.jetty.server.Server;
import org.gaul.shaded.org.eclipse.jetty.server.ServerConnector;
import org.gaul.shaded.org.eclipse.jetty.server.handler.ContextHandler;
import org.gaul.shaded.org.eclipse.jetty.util.ssl.SslContextFactory;
import org.gaul.shaded.org.eclipse.jetty.util.thread.QueuedThreadPool;
import org.jclouds.blobstore.BlobStore;

public final class S3Proxy {
    private final Server server;
    private final S3ProxyHandlerJetty handler;
    private final boolean listenHTTP;
    private final boolean listenHTTPS;

    S3Proxy(Builder builder) {
        ServerConnector connector;
        Preconditions.checkArgument((builder.endpoint != null || builder.secureEndpoint != null ? 1 : 0) != 0, (Object)"Must provide endpoint or secure-endpoint");
        if (builder.endpoint != null) {
            Preconditions.checkArgument((boolean)builder.endpoint.getPath().isEmpty(), (String)"endpoint path must be empty, was: %s", (Object)builder.endpoint.getPath());
        }
        if (builder.secureEndpoint != null) {
            Preconditions.checkArgument((boolean)builder.secureEndpoint.getPath().isEmpty(), (String)"secure-endpoint path must be empty, was: %s", (Object)builder.secureEndpoint.getPath());
            Objects.requireNonNull(builder.keyStorePath, "Must provide keyStorePath with HTTPS endpoint");
            Objects.requireNonNull(builder.keyStorePassword, "Must provide keyStorePassword with HTTPS endpoint");
        }
        Preconditions.checkArgument((boolean)(Strings.isNullOrEmpty((String)builder.identity) ^ !Strings.isNullOrEmpty((String)builder.credential)), (Object)"Must provide both identity and credential");
        QueuedThreadPool pool = new QueuedThreadPool(builder.jettyMaxThreads);
        pool.setName("S3Proxy-Jetty");
        this.server = new Server(pool);
        if (builder.servicePath != null && !builder.servicePath.isEmpty()) {
            ContextHandler context = new ContextHandler();
            context.setContextPath(builder.servicePath);
        }
        HttpConnectionFactory httpConnectionFactory = new HttpConnectionFactory(new HttpConfiguration(), HttpCompliance.LEGACY);
        if (builder.endpoint != null) {
            connector = new ServerConnector(this.server, httpConnectionFactory);
            connector.setHost(builder.endpoint.getHost());
            connector.setPort(builder.endpoint.getPort());
            this.server.addConnector(connector);
            this.listenHTTP = true;
        } else {
            this.listenHTTP = false;
        }
        if (builder.secureEndpoint != null) {
            SslContextFactory.Server sslContextFactory = new SslContextFactory.Server();
            sslContextFactory.setKeyStorePath(builder.keyStorePath);
            sslContextFactory.setKeyStorePassword(builder.keyStorePassword);
            connector = new ServerConnector(this.server, sslContextFactory, httpConnectionFactory);
            connector.setHost(builder.secureEndpoint.getHost());
            connector.setPort(builder.secureEndpoint.getPort());
            this.server.addConnector(connector);
            this.listenHTTPS = true;
        } else {
            this.listenHTTPS = false;
        }
        this.handler = new S3ProxyHandlerJetty(builder.blobStore, builder.authenticationType, builder.identity, builder.credential, builder.virtualHost, builder.maxSinglePartObjectSize, builder.v4MaxNonChunkedRequestSize, builder.ignoreUnknownHeaders, builder.corsRules, builder.servicePath, builder.maximumTimeSkew);
        this.server.setHandler(this.handler);
    }

    public static Builder builder() {
        return new Builder();
    }

    public void start() throws Exception {
        this.server.start();
    }

    public void stop() throws Exception {
        this.server.stop();
    }

    public int getPort() {
        if (this.listenHTTP) {
            return ((ServerConnector)this.server.getConnectors()[0]).getLocalPort();
        }
        return -1;
    }

    public int getSecurePort() {
        if (this.listenHTTPS) {
            ServerConnector connector = this.listenHTTP ? (ServerConnector)this.server.getConnectors()[1] : (ServerConnector)this.server.getConnectors()[0];
            return connector.getLocalPort();
        }
        return -1;
    }

    public String getState() {
        return this.server.getState();
    }

    public void setBlobStoreLocator(BlobStoreLocator lookup) {
        this.handler.getHandler().setBlobStoreLocator(lookup);
    }

    public static final class Builder {
        private BlobStore blobStore;
        private URI endpoint;
        private URI secureEndpoint;
        private String servicePath;
        private AuthenticationType authenticationType = AuthenticationType.NONE;
        private String identity;
        private String credential;
        private String keyStorePath;
        private String keyStorePassword;
        private String virtualHost;
        private long maxSinglePartObjectSize = 0x140000000L;
        private long v4MaxNonChunkedRequestSize = 0x2000000L;
        private boolean ignoreUnknownHeaders;
        private CrossOriginResourceSharing corsRules;
        private int jettyMaxThreads = 200;
        private int maximumTimeSkew = 900;

        Builder() {
        }

        public S3Proxy build() {
            return new S3Proxy(this);
        }

        public static Builder fromProperties(Properties properties) throws URISyntaxException {
            String maximumTimeSkew;
            String corsAllowAll;
            String ignoreUnknownHeaders;
            String v4MaxNonChunkedRequestSize;
            String maxSinglePartObjectSize;
            String virtualHost;
            String servicePath;
            String authorizationString;
            Builder builder = new Builder();
            String endpoint = properties.getProperty("s3proxy.endpoint");
            String secureEndpoint = properties.getProperty("s3proxy.secure-endpoint");
            if (endpoint == null && secureEndpoint == null) {
                throw new IllegalArgumentException("Properties file must contain: s3proxy.endpoint or s3proxy.secure-endpoint");
            }
            if (endpoint != null) {
                builder.endpoint(new URI(endpoint));
            }
            if (secureEndpoint != null) {
                builder.secureEndpoint(new URI(secureEndpoint));
            }
            if ((authorizationString = properties.getProperty("s3proxy.authorization")) == null) {
                throw new IllegalArgumentException("Properties file must contain: s3proxy.authorization");
            }
            AuthenticationType authorization = AuthenticationType.fromString(authorizationString);
            String localIdentity = null;
            String localCredential = null;
            switch (authorization) {
                case AWS_V2: 
                case AWS_V4: 
                case AWS_V2_OR_V4: {
                    localIdentity = properties.getProperty("s3proxy.identity");
                    localCredential = properties.getProperty("s3proxy.credential");
                    if (localIdentity != null && localCredential != null) break;
                    throw new IllegalArgumentException("Must specify both s3proxy.identity and s3proxy.credential when using authentication");
                }
                case NONE: {
                    break;
                }
                default: {
                    throw new IllegalArgumentException("s3proxy.authorization invalid value, was: " + (Object)((Object)authorization));
                }
            }
            if (localIdentity != null || localCredential != null) {
                builder.awsAuthentication(authorization, localIdentity, localCredential);
            }
            if ((servicePath = Strings.nullToEmpty((String)properties.getProperty("s3proxy.service-path"))) != null) {
                builder.servicePath(servicePath);
            }
            String keyStorePath = properties.getProperty("s3proxy.keystore-path");
            String keyStorePassword = properties.getProperty("s3proxy.keystore-password");
            if (keyStorePath != null || keyStorePassword != null) {
                builder.keyStore(keyStorePath, keyStorePassword);
            }
            if (!Strings.isNullOrEmpty((String)(virtualHost = properties.getProperty("s3proxy.virtual-host")))) {
                builder.virtualHost(virtualHost);
            }
            if ((maxSinglePartObjectSize = properties.getProperty("s3proxy.max-single-part-object-size")) != null) {
                builder.maxSinglePartObjectSize(Long.parseLong(maxSinglePartObjectSize));
            }
            if ((v4MaxNonChunkedRequestSize = properties.getProperty("s3proxy.v4-max-non-chunked-request-size")) != null) {
                builder.v4MaxNonChunkedRequestSize(Long.parseLong(v4MaxNonChunkedRequestSize));
            }
            if (!Strings.isNullOrEmpty((String)(ignoreUnknownHeaders = properties.getProperty("s3proxy.ignore-unknown-headers")))) {
                builder.ignoreUnknownHeaders(Boolean.parseBoolean(ignoreUnknownHeaders));
            }
            if (!Strings.isNullOrEmpty((String)(corsAllowAll = properties.getProperty("s3proxy.cors-allow-all"))) && Boolean.parseBoolean(corsAllowAll)) {
                builder.corsRules(new CrossOriginResourceSharing());
            } else {
                String corsAllowOrigins = properties.getProperty("s3proxy.cors-allow-origins", "");
                String corsAllowMethods = properties.getProperty("s3proxy.cors-allow-methods", "");
                String corsAllowHeaders = properties.getProperty("s3proxy.cors-allow-headers", "");
                Splitter splitter = Splitter.on((String)" ").trimResults().omitEmptyStrings();
                ArrayList allowedMethods = Lists.newArrayList((Iterable)splitter.split((CharSequence)corsAllowMethods));
                allowedMethods.removeAll(CrossOriginResourceSharing.SUPPORTED_METHODS);
                if (!allowedMethods.isEmpty()) {
                    throw new IllegalArgumentException("s3proxy.cors-allow-methods contains not supported values: " + Joiner.on((String)" ").join((Iterable)allowedMethods));
                }
                builder.corsRules(new CrossOriginResourceSharing(Lists.newArrayList((Iterable)splitter.split((CharSequence)corsAllowOrigins)), Lists.newArrayList((Iterable)splitter.split((CharSequence)corsAllowMethods)), Lists.newArrayList((Iterable)splitter.split((CharSequence)corsAllowHeaders))));
            }
            String jettyMaxThreads = properties.getProperty("s3proxy.jetty.max-threads");
            if (jettyMaxThreads != null) {
                builder.jettyMaxThreads(Integer.parseInt(jettyMaxThreads));
            }
            if ((maximumTimeSkew = properties.getProperty("s3proxy.maximum-timeskew")) != null) {
                builder.maximumTimeSkew(Integer.parseInt(maximumTimeSkew));
            }
            return builder;
        }

        public Builder blobStore(BlobStore blobStore) {
            this.blobStore = Objects.requireNonNull(blobStore);
            return this;
        }

        public Builder endpoint(URI endpoint) {
            this.endpoint = Objects.requireNonNull(endpoint);
            return this;
        }

        public Builder secureEndpoint(URI secureEndpoint) {
            this.secureEndpoint = Objects.requireNonNull(secureEndpoint);
            return this;
        }

        public Builder awsAuthentication(AuthenticationType authenticationType, String identity, String credential) {
            this.authenticationType = authenticationType;
            if (!AuthenticationType.NONE.equals((Object)authenticationType)) {
                this.identity = Objects.requireNonNull(identity);
                this.credential = Objects.requireNonNull(credential);
            }
            return this;
        }

        public Builder keyStore(String keyStorePath, String keyStorePassword) {
            this.keyStorePath = Objects.requireNonNull(keyStorePath);
            this.keyStorePassword = Objects.requireNonNull(keyStorePassword);
            return this;
        }

        public Builder virtualHost(String virtualHost) {
            this.virtualHost = Objects.requireNonNull(virtualHost);
            return this;
        }

        public Builder maxSinglePartObjectSize(long maxSinglePartObjectSize) {
            if (maxSinglePartObjectSize <= 0L) {
                throw new IllegalArgumentException("must be greater than zero, was: " + maxSinglePartObjectSize);
            }
            this.maxSinglePartObjectSize = maxSinglePartObjectSize;
            return this;
        }

        public Builder v4MaxNonChunkedRequestSize(long v4MaxNonChunkedRequestSize) {
            if (v4MaxNonChunkedRequestSize <= 0L) {
                throw new IllegalArgumentException("must be greater than zero, was: " + v4MaxNonChunkedRequestSize);
            }
            this.v4MaxNonChunkedRequestSize = v4MaxNonChunkedRequestSize;
            return this;
        }

        public Builder ignoreUnknownHeaders(boolean ignoreUnknownHeaders) {
            this.ignoreUnknownHeaders = ignoreUnknownHeaders;
            return this;
        }

        public Builder corsRules(CrossOriginResourceSharing corsRules) {
            this.corsRules = corsRules;
            return this;
        }

        public Builder jettyMaxThreads(int jettyMaxThreads) {
            this.jettyMaxThreads = jettyMaxThreads;
            return this;
        }

        public Builder maximumTimeSkew(int maximumTimeSkew) {
            this.maximumTimeSkew = maximumTimeSkew;
            return this;
        }

        public Builder servicePath(String s3ProxyServicePath) {
            String path = Strings.nullToEmpty((String)s3ProxyServicePath);
            if (!path.isEmpty() && !path.startsWith("/")) {
                path = "/" + path;
            }
            this.servicePath = path;
            return this;
        }

        public URI getEndpoint() {
            return this.endpoint;
        }

        public URI getSecureEndpoint() {
            return this.secureEndpoint;
        }

        public String getServicePath() {
            return this.servicePath;
        }

        public String getIdentity() {
            return this.identity;
        }

        public String getCredential() {
            return this.credential;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (!(object instanceof Builder)) {
                return false;
            }
            Builder that = (Builder)object;
            return Objects.equals(this.endpoint, that.endpoint) && Objects.equals(this.secureEndpoint, that.secureEndpoint) && Objects.equals(this.keyStorePath, that.keyStorePath) && Objects.equals(this.keyStorePassword, that.keyStorePassword) && Objects.equals(this.virtualHost, that.virtualHost) && Objects.equals(this.servicePath, that.servicePath) && this.maxSinglePartObjectSize == that.maxSinglePartObjectSize && this.v4MaxNonChunkedRequestSize == that.v4MaxNonChunkedRequestSize && this.ignoreUnknownHeaders == that.ignoreUnknownHeaders && this.corsRules.equals(that.corsRules);
        }

        public int hashCode() {
            return Objects.hash(this.endpoint, this.secureEndpoint, this.keyStorePath, this.keyStorePassword, this.virtualHost, this.servicePath, this.maxSinglePartObjectSize, this.v4MaxNonChunkedRequestSize, this.ignoreUnknownHeaders, this.corsRules);
        }
    }
}

