/*
 * Decompiled with CFR 0.152.
 */
package org.gaul.s3proxy;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.dataformat.xml.XmlMapper;
import com.google.common.base.CharMatcher;
import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.google.common.collect.Streams;
import com.google.common.escape.Escaper;
import com.google.common.hash.HashCode;
import com.google.common.hash.HashFunction;
import com.google.common.hash.Hashing;
import com.google.common.hash.HashingInputStream;
import com.google.common.io.BaseEncoding;
import com.google.common.io.ByteSource;
import com.google.common.io.ByteStreams;
import com.google.common.net.HostAndPort;
import com.google.common.net.PercentEscaper;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.PushbackInputStream;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.nio.file.AccessDeniedException;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TimeZone;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.apache.commons.fileupload.MultipartStream;
import org.gaul.s3proxy.AccessControlPolicy;
import org.gaul.s3proxy.AuthenticationType;
import org.gaul.s3proxy.AwsSignature;
import org.gaul.s3proxy.BlobStoreLocator;
import org.gaul.s3proxy.ChunkedInputStream;
import org.gaul.s3proxy.CompleteMultipartUploadRequest;
import org.gaul.s3proxy.CreateBucketRequest;
import org.gaul.s3proxy.CrossOriginResourceSharing;
import org.gaul.s3proxy.DeleteMultipleObjectsRequest;
import org.gaul.s3proxy.Quirks;
import org.gaul.s3proxy.S3AuthorizationHeader;
import org.gaul.s3proxy.S3ErrorCode;
import org.gaul.s3proxy.S3Exception;
import org.jclouds.blobstore.BlobStore;
import org.jclouds.blobstore.KeyNotFoundException;
import org.jclouds.blobstore.domain.Blob;
import org.jclouds.blobstore.domain.BlobAccess;
import org.jclouds.blobstore.domain.BlobBuilder;
import org.jclouds.blobstore.domain.BlobMetadata;
import org.jclouds.blobstore.domain.ContainerAccess;
import org.jclouds.blobstore.domain.MultipartPart;
import org.jclouds.blobstore.domain.MultipartUpload;
import org.jclouds.blobstore.domain.MutableBlobMetadata;
import org.jclouds.blobstore.domain.PageSet;
import org.jclouds.blobstore.domain.StorageMetadata;
import org.jclouds.blobstore.domain.Tier;
import org.jclouds.blobstore.domain.internal.MutableBlobMetadataImpl;
import org.jclouds.blobstore.options.CopyOptions;
import org.jclouds.blobstore.options.CreateContainerOptions;
import org.jclouds.blobstore.options.GetOptions;
import org.jclouds.blobstore.options.ListContainerOptions;
import org.jclouds.blobstore.options.PutOptions;
import org.jclouds.domain.Location;
import org.jclouds.io.ContentMetadata;
import org.jclouds.io.ContentMetadataBuilder;
import org.jclouds.io.Payload;
import org.jclouds.io.Payloads;
import org.jclouds.io.payloads.InputStreamPayload;
import org.jclouds.rest.AuthorizationException;
import org.jclouds.s3.domain.ObjectMetadata;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class S3ProxyHandler {
    private static final Logger logger = LoggerFactory.getLogger(S3ProxyHandler.class);
    private static final String AWS_XMLNS = "http://s3.amazonaws.com/doc/2006-03-01/";
    private static final String USER_METADATA_PREFIX = "x-amz-meta-";
    private static final String FAKE_OWNER_ID = "75aa57f09aa0c8caeab4f8c24e99d10f8e7faeebf76c078efc7c6caea54ba06a";
    private static final String FAKE_OWNER_DISPLAY_NAME = "CustomersName@amazon.com";
    private static final String FAKE_INITIATOR_ID = "arn:aws:iam::111122223333:user/some-user-11116a31-17b5-4fb7-9df5-b288870f11xx";
    private static final String FAKE_INITIATOR_DISPLAY_NAME = "umat-user-11116a31-17b5-4fb7-9df5-b288870f11xx";
    private static final String FAKE_REQUEST_ID = "4442587FB7D0A2F9";
    private static final CharMatcher VALID_BUCKET_FIRST_CHAR = CharMatcher.inRange((char)'a', (char)'z').or(CharMatcher.inRange((char)'A', (char)'Z')).or(CharMatcher.inRange((char)'0', (char)'9'));
    private static final CharMatcher VALID_BUCKET = VALID_BUCKET_FIRST_CHAR.or(CharMatcher.is((char)'.')).or(CharMatcher.is((char)'_')).or(CharMatcher.is((char)'-'));
    private static final long MAX_MULTIPART_COPY_SIZE = 0x140000000L;
    private static final Set<String> UNSUPPORTED_PARAMETERS = ImmutableSet.of((Object)"accelerate", (Object)"analytics", (Object)"cors", (Object)"inventory", (Object)"lifecycle", (Object)"logging", (Object[])new String[]{"metrics", "notification", "replication", "requestPayment", "restore", "tagging", "torrent", "versioning", "versions", "website"});
    private static final Set<String> SUPPORTED_X_AMZ_HEADERS = ImmutableSet.of((Object)"x-amz-acl", (Object)"x-amz-content-sha256", (Object)"x-amz-copy-source", (Object)"x-amz-copy-source-if-match", (Object)"x-amz-copy-source-if-modified-since", (Object)"x-amz-copy-source-if-none-match", (Object[])new String[]{"x-amz-copy-source-if-unmodified-since", "x-amz-copy-source-range", "x-amz-date", "x-amz-decoded-content-length", "x-amz-metadata-directive", "x-amz-storage-class"});
    private static final Set<String> CANNED_ACLS = ImmutableSet.of((Object)"private", (Object)"public-read", (Object)"public-read-write", (Object)"authenticated-read", (Object)"bucket-owner-read", (Object)"bucket-owner-full-control", (Object[])new String[]{"log-delivery-write"});
    private static final String XML_CONTENT_TYPE = "application/xml";
    private static final String UTF_8 = "UTF-8";
    private static final Escaper urlEscaper = new PercentEscaper("*-./_", false);
    private static final HashFunction MD5 = Hashing.md5();
    private final boolean anonymousIdentity;
    private final AuthenticationType authenticationType;
    private final Optional<String> virtualHost;
    private final long maxSinglePartObjectSize;
    private final long v4MaxNonChunkedRequestSize;
    private final boolean ignoreUnknownHeaders;
    private final CrossOriginResourceSharing corsRules;
    private final String servicePath;
    private final int maximumTimeSkew;
    private final XmlMapper mapper = new XmlMapper();
    private final XMLOutputFactory xmlOutputFactory = XMLOutputFactory.newInstance();
    private BlobStoreLocator blobStoreLocator;
    private final BlobStore defaultBlobStore;
    private final Cache<Map.Entry<String, String>, String> lastKeyToMarker = CacheBuilder.newBuilder().maximumSize(10000L).expireAfterWrite(10L, TimeUnit.MINUTES).build();

    public S3ProxyHandler(final BlobStore blobStore, AuthenticationType authenticationType, final String identity, final String credential, @Nullable String virtualHost, long maxSinglePartObjectSize, long v4MaxNonChunkedRequestSize, boolean ignoreUnknownHeaders, @Nullable CrossOriginResourceSharing corsRules, String servicePath, int maximumTimeSkew) {
        this.corsRules = corsRules != null ? corsRules : new CrossOriginResourceSharing();
        if (authenticationType != AuthenticationType.NONE) {
            this.anonymousIdentity = false;
            this.blobStoreLocator = new BlobStoreLocator(){

                @Override
                @Nullable
                public Map.Entry<String, BlobStore> locateBlobStore(String identityArg, String container, String blob) {
                    if (!identity.equals(identityArg)) {
                        return null;
                    }
                    return Maps.immutableEntry((Object)credential, (Object)blobStore);
                }
            };
        } else {
            this.anonymousIdentity = true;
            final Map.Entry anonymousBlobStore = Maps.immutableEntry(null, (Object)blobStore);
            this.blobStoreLocator = new BlobStoreLocator(){

                @Override
                public Map.Entry<String, BlobStore> locateBlobStore(String identityArg, String container, String blob) {
                    return anonymousBlobStore;
                }
            };
        }
        this.authenticationType = authenticationType;
        this.virtualHost = Optional.ofNullable(virtualHost);
        this.maxSinglePartObjectSize = maxSinglePartObjectSize;
        this.v4MaxNonChunkedRequestSize = v4MaxNonChunkedRequestSize;
        this.ignoreUnknownHeaders = ignoreUnknownHeaders;
        this.defaultBlobStore = blobStore;
        this.xmlOutputFactory.setProperty("javax.xml.stream.isRepairingNamespaces", Boolean.FALSE);
        this.servicePath = Strings.nullToEmpty((String)servicePath);
        this.maximumTimeSkew = maximumTimeSkew;
    }

    private static String getBlobStoreType(BlobStore blobStore) {
        return blobStore.getContext().unwrap().getProviderMetadata().getId();
    }

    private static boolean isValidContainer(String containerName) {
        return containerName != null && containerName.length() >= 3 && containerName.length() <= 255 && !containerName.startsWith(".") && !containerName.endsWith(".") && !S3ProxyHandler.validateIpAddress(containerName) && VALID_BUCKET_FIRST_CHAR.matches(containerName.charAt(0)) && VALID_BUCKET.matchesAllOf((CharSequence)containerName);
    }

    public final void doHandle(HttpServletRequest baseRequest, HttpServletRequest request, HttpServletResponse response, InputStream is) throws IOException, S3Exception {
        BlobStore blobStore;
        String method = request.getMethod();
        String uri = request.getRequestURI();
        String originalUri = request.getRequestURI();
        if (!this.servicePath.isEmpty() && uri.length() > this.servicePath.length()) {
            uri = uri.substring(this.servicePath.length());
        }
        logger.debug("request: {}", (Object)request);
        String hostHeader = request.getHeader("Host");
        if (hostHeader != null && this.virtualHost.isPresent()) {
            hostHeader = HostAndPort.fromString((String)hostHeader).getHost();
            String virtualHostSuffix = "." + this.virtualHost.get();
            if (!hostHeader.equals(this.virtualHost.get())) {
                String bucket;
                if (hostHeader.endsWith(virtualHostSuffix)) {
                    bucket = hostHeader.substring(0, hostHeader.length() - virtualHostSuffix.length());
                    uri = "/" + bucket + uri;
                } else {
                    bucket = hostHeader.toLowerCase();
                    uri = "/" + bucket + uri;
                }
            }
        }
        response.addHeader("x-amz-request-id", FAKE_REQUEST_ID);
        boolean hasDateHeader = false;
        boolean hasXAmzDateHeader = false;
        for (String headerName : Collections.list(request.getHeaderNames())) {
            for (String headerValue : Collections.list(request.getHeaders(headerName))) {
                logger.debug("header: {}: {}", (Object)headerName, (Object)Strings.nullToEmpty((String)headerValue));
            }
            if (headerName.equalsIgnoreCase("Date")) {
                hasDateHeader = true;
                continue;
            }
            if (!headerName.equalsIgnoreCase("x-amz-date") || Strings.isNullOrEmpty((String)request.getHeader("x-amz-date"))) continue;
            hasXAmzDateHeader = true;
        }
        boolean haveBothDateHeader = false;
        if (hasDateHeader && hasXAmzDateHeader) {
            haveBothDateHeader = true;
        }
        if (!this.anonymousIdentity && (method.equals("GET") || method.equals("HEAD") || method.equals("POST") || method.equals("OPTIONS")) && request.getHeader("Authorization") == null && request.getParameter("X-Amz-Algorithm") == null && request.getParameter("AWSAccessKeyId") == null && this.defaultBlobStore != null) {
            this.doHandleAnonymous(request, response, is, uri, this.defaultBlobStore);
            return;
        }
        if (!(this.anonymousIdentity || hasDateHeader || hasXAmzDateHeader || request.getParameter("X-Amz-Date") != null || request.getParameter("Expires") != null)) {
            throw new S3Exception(S3ErrorCode.ACCESS_DENIED, "AWS authentication requires a valid Date or x-amz-date header");
        }
        String requestIdentity = null;
        String headerAuthorization = request.getHeader("Authorization");
        S3AuthorizationHeader authHeader = null;
        boolean presignedUrl = false;
        if (!this.anonymousIdentity) {
            if (Strings.isNullOrEmpty((String)headerAuthorization)) {
                String algorithm = request.getParameter("X-Amz-Algorithm");
                if (algorithm == null) {
                    String identity = request.getParameter("AWSAccessKeyId");
                    String signature = request.getParameter("Signature");
                    if (identity == null || signature == null) {
                        throw new S3Exception(S3ErrorCode.ACCESS_DENIED);
                    }
                    headerAuthorization = "AWS " + identity + ":" + signature;
                    presignedUrl = true;
                } else if (algorithm.equals("AWS4-HMAC-SHA256")) {
                    String credential = request.getParameter("X-Amz-Credential");
                    String signedHeaders = request.getParameter("X-Amz-SignedHeaders");
                    String signature = request.getParameter("X-Amz-Signature");
                    if (credential == null || signedHeaders == null || signature == null) {
                        throw new S3Exception(S3ErrorCode.ACCESS_DENIED);
                    }
                    headerAuthorization = "AWS4-HMAC-SHA256 Credential=" + credential + ", requestSignedHeaders=" + signedHeaders + ", Signature=" + signature;
                    presignedUrl = true;
                } else {
                    throw new IllegalArgumentException("unknown algorithm: " + algorithm);
                }
            }
            try {
                authHeader = new S3AuthorizationHeader(headerAuthorization);
            }
            catch (IllegalArgumentException iae) {
                throw new S3Exception(S3ErrorCode.INVALID_ARGUMENT, (Throwable)iae);
            }
            requestIdentity = authHeader.getIdentity();
        }
        long dateSkew = 0L;
        if (!this.anonymousIdentity) {
            boolean haveDate = true;
            AuthenticationType finalAuthType = null;
            if (authHeader.getAuthenticationType() == AuthenticationType.AWS_V2 && (this.authenticationType == AuthenticationType.AWS_V2 || this.authenticationType == AuthenticationType.AWS_V2_OR_V4)) {
                finalAuthType = AuthenticationType.AWS_V2;
            } else if (authHeader.getAuthenticationType() == AuthenticationType.AWS_V4 && (this.authenticationType == AuthenticationType.AWS_V4 || this.authenticationType == AuthenticationType.AWS_V2_OR_V4)) {
                finalAuthType = AuthenticationType.AWS_V4;
            } else if (this.authenticationType != AuthenticationType.NONE) {
                throw new S3Exception(S3ErrorCode.ACCESS_DENIED);
            }
            if (hasXAmzDateHeader) {
                if (finalAuthType == AuthenticationType.AWS_V2) {
                    dateSkew = request.getDateHeader("x-amz-date");
                    dateSkew /= 1000L;
                } else if (finalAuthType == AuthenticationType.AWS_V4) {
                    dateSkew = S3ProxyHandler.parseIso8601(request.getHeader("x-amz-date"));
                }
            } else if (request.getParameter("X-Amz-Date") != null) {
                String dateString = request.getParameter("X-Amz-Date");
                dateSkew = S3ProxyHandler.parseIso8601(dateString);
            } else if (hasDateHeader) {
                try {
                    dateSkew = request.getDateHeader("Date");
                    dateSkew /= 1000L;
                }
                catch (IllegalArgumentException iae) {
                    try {
                        dateSkew = S3ProxyHandler.parseIso8601(request.getHeader("Date"));
                    }
                    catch (IllegalArgumentException iae2) {
                        throw new S3Exception(S3ErrorCode.ACCESS_DENIED, (Throwable)iae);
                    }
                }
            } else {
                haveDate = false;
            }
            if (haveDate) {
                this.isTimeSkewed(dateSkew);
            }
        }
        String[] path = uri.split("/", 3);
        for (int i = 0; i < path.length; ++i) {
            path[i] = URLDecoder.decode(path[i], UTF_8);
        }
        Map.Entry<String, BlobStore> provider = this.blobStoreLocator.locateBlobStore(requestIdentity, path.length > 1 ? path[1] : null, path.length > 2 ? path[2] : null);
        if (this.anonymousIdentity) {
            blobStore = provider.getValue();
            String contentSha256 = request.getHeader("x-amz-content-sha256");
            if ("STREAMING-AWS4-HMAC-SHA256-PAYLOAD".equals(contentSha256)) {
                is = new ChunkedInputStream(is);
            }
        } else {
            if (requestIdentity == null) {
                throw new S3Exception(S3ErrorCode.ACCESS_DENIED);
            }
            if (provider == null) {
                throw new S3Exception(S3ErrorCode.INVALID_ACCESS_KEY_ID);
            }
            Iterator<String> credential = provider.getKey();
            blobStore = provider.getValue();
            String expiresString = request.getParameter("Expires");
            if (expiresString != null) {
                long expires = Long.parseLong(expiresString);
                long nowSeconds = System.currentTimeMillis() / 1000L;
                if (nowSeconds >= expires) {
                    throw new S3Exception(S3ErrorCode.ACCESS_DENIED, "Request has expired");
                }
                if (expires - nowSeconds > TimeUnit.DAYS.toSeconds(365L)) {
                    throw new S3Exception(S3ErrorCode.ACCESS_DENIED);
                }
            }
            String dateString = request.getParameter("X-Amz-Date");
            expiresString = request.getParameter("X-Amz-Expires");
            if (dateString != null && expiresString != null) {
                long date = S3ProxyHandler.parseIso8601(dateString);
                long expires = Long.parseLong(expiresString);
                long nowSeconds = System.currentTimeMillis() / 1000L;
                if (nowSeconds >= date + expires) {
                    throw new S3Exception(S3ErrorCode.ACCESS_DENIED, "Request has expired");
                }
                if (expires > TimeUnit.DAYS.toSeconds(7L)) {
                    throw new S3Exception(S3ErrorCode.ACCESS_DENIED);
                }
            }
            block4 : switch (authHeader.getAuthenticationType()) {
                case AWS_V2: {
                    switch (this.authenticationType) {
                        case AWS_V2: 
                        case AWS_V2_OR_V4: 
                        case NONE: {
                            break block4;
                        }
                    }
                    throw new S3Exception(S3ErrorCode.ACCESS_DENIED);
                }
                case AWS_V4: {
                    switch (this.authenticationType) {
                        case AWS_V2_OR_V4: 
                        case NONE: 
                        case AWS_V4: {
                            break block4;
                        }
                    }
                    throw new S3Exception(S3ErrorCode.ACCESS_DENIED);
                }
                case NONE: {
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unhandled type: " + (Object)((Object)authHeader.getAuthenticationType()));
                }
            }
            String expectedSignature = null;
            if (authHeader.getHmacAlgorithm() == null) {
                String uriForSigning = presignedUrl ? uri : this.servicePath + uri;
                expectedSignature = AwsSignature.createAuthorizationSignature(request, uriForSigning, credential, presignedUrl, haveBothDateHeader);
            } else {
                String contentSha256 = request.getHeader("x-amz-content-sha256");
                try {
                    byte[] payload;
                    if (request.getParameter("X-Amz-Algorithm") != null) {
                        payload = new byte[]{};
                    } else if ("STREAMING-AWS4-HMAC-SHA256-PAYLOAD".equals(contentSha256)) {
                        payload = new byte[]{};
                        is = new ChunkedInputStream(is);
                    } else if ("UNSIGNED-PAYLOAD".equals(contentSha256)) {
                        payload = new byte[]{};
                    } else {
                        payload = ByteStreams.toByteArray((InputStream)ByteStreams.limit((InputStream)is, (long)(this.v4MaxNonChunkedRequestSize + 1L)));
                        if ((long)payload.length == this.v4MaxNonChunkedRequestSize + 1L) {
                            throw new S3Exception(S3ErrorCode.MAX_MESSAGE_LENGTH_EXCEEDED);
                        }
                        MessageDigest md = MessageDigest.getInstance(authHeader.getHashAlgorithm());
                        byte[] hash = md.digest(payload);
                        if (!contentSha256.equals(BaseEncoding.base16().lowerCase().encode(hash))) {
                            throw new S3Exception(S3ErrorCode.X_AMZ_CONTENT_S_H_A_256_MISMATCH);
                        }
                        is = new ByteArrayInputStream(payload);
                    }
                    String uriForSigning = presignedUrl ? originalUri : this.servicePath + originalUri;
                    expectedSignature = AwsSignature.createAuthorizationSignatureV4(baseRequest, authHeader, payload, uriForSigning, credential);
                }
                catch (InvalidKeyException | NoSuchAlgorithmException e) {
                    throw new S3Exception(S3ErrorCode.INVALID_ARGUMENT, (Throwable)e);
                }
            }
            if (!S3ProxyHandler.constantTimeEquals(expectedSignature, authHeader.getSignature())) {
                throw new S3Exception(S3ErrorCode.SIGNATURE_DOES_NOT_MATCH);
            }
        }
        for (String parameter : Collections.list(request.getParameterNames())) {
            if (!UNSUPPORTED_PARAMETERS.contains(parameter)) continue;
            logger.error("Unknown parameters {} with URI {}", (Object)parameter, (Object)request.getRequestURI());
            throw new S3Exception(S3ErrorCode.NOT_IMPLEMENTED);
        }
        for (String headerName : Collections.list(request.getHeaderNames())) {
            if (this.ignoreUnknownHeaders || !headerName.startsWith("x-amz-") || headerName.startsWith(USER_METADATA_PREFIX) || SUPPORTED_X_AMZ_HEADERS.contains(headerName.toLowerCase())) continue;
            logger.error("Unknown header {} with URI {}", (Object)headerName, (Object)request.getRequestURI());
            throw new S3Exception(S3ErrorCode.NOT_IMPLEMENTED);
        }
        if (!uri.equals("/") && !S3ProxyHandler.isValidContainer(path[1])) {
            if (method.equals("PUT") && (path.length <= 2 || path[2].isEmpty()) && !"".equals(request.getParameter("acl"))) {
                throw new S3Exception(S3ErrorCode.INVALID_BUCKET_NAME);
            }
            throw new S3Exception(S3ErrorCode.NO_SUCH_BUCKET);
        }
        String uploadId = request.getParameter("uploadId");
        switch (method) {
            case "DELETE": {
                if (path.length <= 2 || path[2].isEmpty()) {
                    S3ProxyHandler.handleContainerDelete(response, blobStore, path[1]);
                    return;
                }
                if (uploadId != null) {
                    this.handleAbortMultipartUpload(request, response, blobStore, path[1], path[2], uploadId);
                    return;
                }
                S3ProxyHandler.handleBlobRemove(response, blobStore, path[1], path[2]);
                return;
            }
            case "GET": {
                if (uri.equals("/")) {
                    this.handleContainerList(response, blobStore);
                    return;
                }
                if (path.length <= 2 || path[2].isEmpty()) {
                    if (request.getParameter("acl") != null) {
                        this.handleGetContainerAcl(response, blobStore, path[1]);
                        return;
                    }
                    if (request.getParameter("location") != null) {
                        this.handleContainerLocation(response);
                        return;
                    }
                    if (request.getParameter("policy") != null) {
                        S3ProxyHandler.handleBucketPolicy(blobStore, path[1]);
                        return;
                    }
                    if (request.getParameter("uploads") != null) {
                        this.handleListMultipartUploads(request, response, blobStore, path[1]);
                        return;
                    }
                    this.handleBlobList(request, response, blobStore, path[1]);
                    return;
                }
                if (request.getParameter("acl") != null) {
                    this.handleGetBlobAcl(response, blobStore, path[1], path[2]);
                    return;
                }
                if (uploadId != null) {
                    this.handleListParts(request, response, blobStore, path[1], path[2], uploadId);
                    return;
                }
                this.handleGetBlob(request, response, blobStore, path[1], path[2]);
                return;
            }
            case "HEAD": {
                if (path.length <= 2 || path[2].isEmpty()) {
                    S3ProxyHandler.handleContainerExists(blobStore, path[1]);
                    return;
                }
                S3ProxyHandler.handleBlobMetadata(request, response, blobStore, path[1], path[2]);
                return;
            }
            case "POST": {
                if (request.getParameter("delete") != null) {
                    this.handleMultiBlobRemove(response, is, blobStore, path[1]);
                    return;
                }
                if (request.getParameter("uploads") != null) {
                    this.handleInitiateMultipartUpload(request, response, blobStore, path[1], path[2]);
                    return;
                }
                if (uploadId == null || request.getParameter("partNumber") != null) break;
                this.handleCompleteMultipartUpload(request, response, is, blobStore, path[1], path[2], uploadId);
                return;
            }
            case "PUT": {
                if (path.length <= 2 || path[2].isEmpty()) {
                    if (request.getParameter("acl") != null) {
                        this.handleSetContainerAcl(request, response, is, blobStore, path[1]);
                        return;
                    }
                    this.handleContainerCreate(request, response, is, blobStore, path[1]);
                    return;
                }
                if (uploadId != null) {
                    if (request.getHeader("x-amz-copy-source") != null) {
                        this.handleCopyPart(request, response, blobStore, path[1], path[2], uploadId);
                    } else {
                        this.handleUploadPart(request, response, is, blobStore, path[1], path[2], uploadId);
                    }
                    return;
                }
                if (request.getHeader("x-amz-copy-source") != null) {
                    this.handleCopyBlob(request, response, is, blobStore, path[1], path[2]);
                    return;
                }
                if (request.getParameter("acl") != null) {
                    this.handleSetBlobAcl(request, response, is, blobStore, path[1], path[2]);
                    return;
                }
                this.handlePutBlob(request, response, is, blobStore, path[1], path[2]);
                return;
            }
            case "OPTIONS": {
                this.handleOptionsBlob(request, response, blobStore, path[1]);
                return;
            }
        }
        logger.error("Unknown method {} with URI {}", (Object)method, (Object)request.getRequestURI());
        throw new S3Exception(S3ErrorCode.NOT_IMPLEMENTED);
    }

    private static boolean checkPublicAccess(BlobStore blobStore, String containerName, String blobName) {
        String blobStoreType = S3ProxyHandler.getBlobStoreType(blobStore);
        if (Quirks.NO_BLOB_ACCESS_CONTROL.contains(blobStoreType)) {
            ContainerAccess access = blobStore.getContainerAccess(containerName);
            return access == ContainerAccess.PUBLIC_READ;
        }
        BlobAccess access = blobStore.getBlobAccess(containerName, blobName);
        return access == BlobAccess.PUBLIC_READ;
    }

    private void doHandleAnonymous(HttpServletRequest request, HttpServletResponse response, InputStream is, String uri, BlobStore blobStore) throws IOException, S3Exception {
        String method = request.getMethod();
        String[] path = uri.split("/", 3);
        switch (method) {
            case "GET": {
                if (uri.equals("/")) {
                    throw new S3Exception(S3ErrorCode.ACCESS_DENIED);
                }
                if (path.length <= 2 || path[2].isEmpty()) {
                    String containerName = path[1];
                    ContainerAccess access = blobStore.getContainerAccess(containerName);
                    if (access == ContainerAccess.PRIVATE) {
                        throw new S3Exception(S3ErrorCode.ACCESS_DENIED);
                    }
                    this.handleBlobList(request, response, blobStore, containerName);
                    return;
                }
                String containerName = path[1];
                String blobName = path[2];
                if (!S3ProxyHandler.checkPublicAccess(blobStore, containerName, blobName)) {
                    throw new S3Exception(S3ErrorCode.ACCESS_DENIED);
                }
                this.handleGetBlob(request, response, blobStore, containerName, blobName);
                return;
            }
            case "HEAD": {
                if (path.length <= 2 || path[2].isEmpty()) {
                    String containerName = path[1];
                    ContainerAccess access = blobStore.getContainerAccess(containerName);
                    if (access == ContainerAccess.PRIVATE) {
                        throw new S3Exception(S3ErrorCode.ACCESS_DENIED);
                    }
                    if (!blobStore.containerExists(containerName)) {
                        throw new S3Exception(S3ErrorCode.NO_SUCH_BUCKET);
                    }
                } else {
                    String containerName = path[1];
                    String blobName = path[2];
                    if (!S3ProxyHandler.checkPublicAccess(blobStore, containerName, blobName)) {
                        throw new S3Exception(S3ErrorCode.ACCESS_DENIED);
                    }
                    S3ProxyHandler.handleBlobMetadata(request, response, blobStore, containerName, blobName);
                }
                return;
            }
            case "POST": {
                if (path.length > 2 && !path[2].isEmpty()) break;
                this.handlePostBlob(request, response, is, blobStore, path[1]);
                return;
            }
            case "OPTIONS": {
                if (uri.equals("/")) {
                    throw new S3Exception(S3ErrorCode.ACCESS_DENIED);
                }
                String containerName = path[1];
                ContainerAccess access = blobStore.getContainerAccess(containerName);
                if (access == ContainerAccess.PRIVATE) {
                    throw new S3Exception(S3ErrorCode.ACCESS_DENIED);
                }
                this.handleOptionsBlob(request, response, blobStore, containerName);
                return;
            }
        }
        logger.error("Unknown method {} with URI {}", (Object)method, (Object)request.getRequestURI());
        throw new S3Exception(S3ErrorCode.NOT_IMPLEMENTED);
    }

    private void handleGetContainerAcl(HttpServletResponse response, BlobStore blobStore, String containerName) throws IOException, S3Exception {
        if (!blobStore.containerExists(containerName)) {
            throw new S3Exception(S3ErrorCode.NO_SUCH_BUCKET);
        }
        ContainerAccess access = blobStore.getContainerAccess(containerName);
        response.setCharacterEncoding(UTF_8);
        try (PrintWriter writer = response.getWriter();){
            response.setContentType(XML_CONTENT_TYPE);
            XMLStreamWriter xml = this.xmlOutputFactory.createXMLStreamWriter(writer);
            xml.writeStartDocument();
            xml.writeStartElement("AccessControlPolicy");
            xml.writeDefaultNamespace(AWS_XMLNS);
            S3ProxyHandler.writeOwnerStanza(xml);
            xml.writeStartElement("AccessControlList");
            xml.writeStartElement("Grant");
            xml.writeStartElement("Grantee");
            xml.writeNamespace("xsi", "http://www.w3.org/2001/XMLSchema-instance");
            xml.writeAttribute("xsi:type", "CanonicalUser");
            S3ProxyHandler.writeSimpleElement(xml, "ID", FAKE_OWNER_ID);
            S3ProxyHandler.writeSimpleElement(xml, "DisplayName", FAKE_OWNER_DISPLAY_NAME);
            xml.writeEndElement();
            S3ProxyHandler.writeSimpleElement(xml, "Permission", "FULL_CONTROL");
            xml.writeEndElement();
            if (access == ContainerAccess.PUBLIC_READ) {
                xml.writeStartElement("Grant");
                xml.writeStartElement("Grantee");
                xml.writeNamespace("xsi", "http://www.w3.org/2001/XMLSchema-instance");
                xml.writeAttribute("xsi:type", "Group");
                S3ProxyHandler.writeSimpleElement(xml, "URI", "http://acs.amazonaws.com/groups/global/AllUsers");
                xml.writeEndElement();
                S3ProxyHandler.writeSimpleElement(xml, "Permission", "READ");
                xml.writeEndElement();
            }
            xml.writeEndElement();
            xml.writeEndElement();
            xml.flush();
        }
        catch (XMLStreamException xse) {
            throw new IOException(xse);
        }
    }

    private void handleSetContainerAcl(HttpServletRequest request, HttpServletResponse response, InputStream is, BlobStore blobStore, String containerName) throws IOException, S3Exception {
        ContainerAccess access;
        String cannedAcl = request.getHeader("x-amz-acl");
        if (cannedAcl == null || "private".equalsIgnoreCase(cannedAcl)) {
            access = ContainerAccess.PRIVATE;
        } else if ("public-read".equalsIgnoreCase(cannedAcl)) {
            access = ContainerAccess.PUBLIC_READ;
        } else {
            if (CANNED_ACLS.contains(cannedAcl)) {
                throw new S3Exception(S3ErrorCode.NOT_IMPLEMENTED);
            }
            response.sendError(400);
            return;
        }
        PushbackInputStream pis = new PushbackInputStream(is);
        int ch = pis.read();
        if (ch != -1) {
            pis.unread(ch);
            AccessControlPolicy policy = (AccessControlPolicy)this.mapper.readValue((InputStream)pis, AccessControlPolicy.class);
            String accessString = S3ProxyHandler.mapXmlAclsToCannedPolicy(policy);
            if (accessString.equals("private")) {
                access = ContainerAccess.PRIVATE;
            } else if (accessString.equals("public-read")) {
                access = ContainerAccess.PUBLIC_READ;
            } else {
                throw new S3Exception(S3ErrorCode.NOT_IMPLEMENTED);
            }
        }
        blobStore.setContainerAccess(containerName, access);
    }

    private void handleGetBlobAcl(HttpServletResponse response, BlobStore blobStore, String containerName, String blobName) throws IOException {
        BlobAccess access = blobStore.getBlobAccess(containerName, blobName);
        response.setCharacterEncoding(UTF_8);
        try (PrintWriter writer = response.getWriter();){
            response.setContentType(XML_CONTENT_TYPE);
            XMLStreamWriter xml = this.xmlOutputFactory.createXMLStreamWriter(writer);
            xml.writeStartDocument();
            xml.writeStartElement("AccessControlPolicy");
            xml.writeDefaultNamespace(AWS_XMLNS);
            S3ProxyHandler.writeOwnerStanza(xml);
            xml.writeStartElement("AccessControlList");
            xml.writeStartElement("Grant");
            xml.writeStartElement("Grantee");
            xml.writeNamespace("xsi", "http://www.w3.org/2001/XMLSchema-instance");
            xml.writeAttribute("xsi:type", "CanonicalUser");
            S3ProxyHandler.writeSimpleElement(xml, "ID", FAKE_OWNER_ID);
            S3ProxyHandler.writeSimpleElement(xml, "DisplayName", FAKE_OWNER_DISPLAY_NAME);
            xml.writeEndElement();
            S3ProxyHandler.writeSimpleElement(xml, "Permission", "FULL_CONTROL");
            xml.writeEndElement();
            if (access == BlobAccess.PUBLIC_READ) {
                xml.writeStartElement("Grant");
                xml.writeStartElement("Grantee");
                xml.writeNamespace("xsi", "http://www.w3.org/2001/XMLSchema-instance");
                xml.writeAttribute("xsi:type", "Group");
                S3ProxyHandler.writeSimpleElement(xml, "URI", "http://acs.amazonaws.com/groups/global/AllUsers");
                xml.writeEndElement();
                S3ProxyHandler.writeSimpleElement(xml, "Permission", "READ");
                xml.writeEndElement();
            }
            xml.writeEndElement();
            xml.writeEndElement();
            xml.flush();
        }
        catch (XMLStreamException xse) {
            throw new IOException(xse);
        }
    }

    private void handleSetBlobAcl(HttpServletRequest request, HttpServletResponse response, InputStream is, BlobStore blobStore, String containerName, String blobName) throws IOException, S3Exception {
        BlobAccess access;
        String cannedAcl = request.getHeader("x-amz-acl");
        if (cannedAcl == null || "private".equalsIgnoreCase(cannedAcl)) {
            access = BlobAccess.PRIVATE;
        } else if ("public-read".equalsIgnoreCase(cannedAcl)) {
            access = BlobAccess.PUBLIC_READ;
        } else {
            if (CANNED_ACLS.contains(cannedAcl)) {
                throw new S3Exception(S3ErrorCode.NOT_IMPLEMENTED);
            }
            response.sendError(400);
            return;
        }
        PushbackInputStream pis = new PushbackInputStream(is);
        int ch = pis.read();
        if (ch != -1) {
            pis.unread(ch);
            AccessControlPolicy policy = (AccessControlPolicy)this.mapper.readValue((InputStream)pis, AccessControlPolicy.class);
            String accessString = S3ProxyHandler.mapXmlAclsToCannedPolicy(policy);
            if (accessString.equals("private")) {
                access = BlobAccess.PRIVATE;
            } else if (accessString.equals("public-read")) {
                access = BlobAccess.PUBLIC_READ;
            } else {
                throw new S3Exception(S3ErrorCode.NOT_IMPLEMENTED);
            }
        }
        blobStore.setBlobAccess(containerName, blobName, access);
    }

    private static String mapXmlAclsToCannedPolicy(AccessControlPolicy policy) throws S3Exception {
        if (!policy.owner.id.equals(FAKE_OWNER_ID)) {
            throw new S3Exception(S3ErrorCode.NOT_IMPLEMENTED);
        }
        boolean ownerFullControl = false;
        boolean allUsersRead = false;
        if (policy.aclList != null) {
            for (AccessControlPolicy.AccessControlList.Grant grant : policy.aclList.grants) {
                if (grant.grantee.type.equals("CanonicalUser") && grant.grantee.id.equals(FAKE_OWNER_ID) && grant.permission.equals("FULL_CONTROL")) {
                    ownerFullControl = true;
                    continue;
                }
                if (grant.grantee.type.equals("Group") && grant.grantee.uri.equals("http://acs.amazonaws.com/groups/global/AllUsers") && grant.permission.equals("READ")) {
                    allUsersRead = true;
                    continue;
                }
                throw new S3Exception(S3ErrorCode.NOT_IMPLEMENTED);
            }
        }
        if (ownerFullControl) {
            if (allUsersRead) {
                return "public-read";
            }
            return "private";
        }
        throw new S3Exception(S3ErrorCode.NOT_IMPLEMENTED);
    }

    private void handleContainerList(HttpServletResponse response, BlobStore blobStore) throws IOException {
        PageSet buckets = blobStore.list();
        response.setCharacterEncoding(UTF_8);
        try (PrintWriter writer = response.getWriter();){
            response.setContentType(XML_CONTENT_TYPE);
            XMLStreamWriter xml = this.xmlOutputFactory.createXMLStreamWriter(writer);
            xml.writeStartDocument();
            xml.writeStartElement("ListAllMyBucketsResult");
            xml.writeDefaultNamespace(AWS_XMLNS);
            S3ProxyHandler.writeOwnerStanza(xml);
            xml.writeStartElement("Buckets");
            for (StorageMetadata metadata : buckets) {
                xml.writeStartElement("Bucket");
                S3ProxyHandler.writeSimpleElement(xml, "Name", metadata.getName());
                Date creationDate = metadata.getCreationDate();
                if (creationDate == null) {
                    creationDate = new Date(0L);
                }
                S3ProxyHandler.writeSimpleElement(xml, "CreationDate", blobStore.getContext().utils().date().iso8601DateFormat(creationDate).trim());
                xml.writeEndElement();
            }
            xml.writeEndElement();
            xml.writeEndElement();
            xml.flush();
        }
        catch (XMLStreamException xse) {
            throw new IOException(xse);
        }
    }

    private void handleContainerLocation(HttpServletResponse response) throws IOException {
        response.setCharacterEncoding(UTF_8);
        try (PrintWriter writer = response.getWriter();){
            response.setContentType(XML_CONTENT_TYPE);
            XMLStreamWriter xml = this.xmlOutputFactory.createXMLStreamWriter(writer);
            xml.writeStartDocument();
            xml.writeStartElement("LocationConstraint");
            xml.writeDefaultNamespace(AWS_XMLNS);
            xml.writeEndElement();
            xml.flush();
        }
        catch (XMLStreamException xse) {
            throw new IOException(xse);
        }
    }

    private static void handleBucketPolicy(BlobStore blobStore, String containerName) throws S3Exception {
        if (!blobStore.containerExists(containerName)) {
            throw new S3Exception(S3ErrorCode.NO_SUCH_BUCKET);
        }
        throw new S3Exception(S3ErrorCode.NO_SUCH_POLICY);
    }

    private void handleListMultipartUploads(HttpServletRequest request, HttpServletResponse response, BlobStore blobStore, String container) throws IOException, S3Exception {
        if (request.getParameter("delimiter") != null || request.getParameter("max-uploads") != null || request.getParameter("key-marker") != null || request.getParameter("upload-id-marker") != null) {
            throw new UnsupportedOperationException();
        }
        String encodingType = request.getParameter("encoding-type");
        String prefix = request.getParameter("prefix");
        List uploads = blobStore.listMultipartUploads(container);
        response.setCharacterEncoding(UTF_8);
        try (PrintWriter writer = response.getWriter();){
            response.setContentType(XML_CONTENT_TYPE);
            XMLStreamWriter xml = this.xmlOutputFactory.createXMLStreamWriter(writer);
            xml.writeStartDocument();
            xml.writeStartElement("ListMultipartUploadsResult");
            xml.writeDefaultNamespace(AWS_XMLNS);
            S3ProxyHandler.writeSimpleElement(xml, "Bucket", container);
            xml.writeEmptyElement("KeyMarker");
            xml.writeEmptyElement("UploadIdMarker");
            xml.writeEmptyElement("NextKeyMarker");
            xml.writeEmptyElement("NextUploadIdMarker");
            xml.writeEmptyElement("Delimiter");
            if (Strings.isNullOrEmpty((String)prefix)) {
                xml.writeEmptyElement("Prefix");
            } else {
                S3ProxyHandler.writeSimpleElement(xml, "Prefix", S3ProxyHandler.encodeBlob(encodingType, prefix));
            }
            S3ProxyHandler.writeSimpleElement(xml, "MaxUploads", "1000");
            S3ProxyHandler.writeSimpleElement(xml, "IsTruncated", "false");
            for (MultipartUpload upload : uploads) {
                if (prefix != null && !upload.blobName().startsWith(prefix)) continue;
                xml.writeStartElement("Upload");
                S3ProxyHandler.writeSimpleElement(xml, "Key", upload.blobName());
                S3ProxyHandler.writeSimpleElement(xml, "UploadId", upload.id());
                S3ProxyHandler.writeInitiatorStanza(xml);
                S3ProxyHandler.writeOwnerStanza(xml);
                S3ProxyHandler.writeSimpleElement(xml, "StorageClass", "STANDARD");
                S3ProxyHandler.writeSimpleElement(xml, "Initiated", blobStore.getContext().utils().date().iso8601DateFormat(new Date()));
                xml.writeEndElement();
            }
            xml.writeEndElement();
            xml.flush();
        }
        catch (XMLStreamException xse) {
            throw new IOException(xse);
        }
    }

    private static void handleContainerExists(BlobStore blobStore, String containerName) throws IOException, S3Exception {
        if (!blobStore.containerExists(containerName)) {
            throw new S3Exception(S3ErrorCode.NO_SUCH_BUCKET);
        }
    }

    private void handleContainerCreate(HttpServletRequest request, HttpServletResponse response, InputStream is, BlobStore blobStore, String containerName) throws IOException, S3Exception {
        boolean created;
        String locationString;
        if (containerName.isEmpty()) {
            throw new S3Exception(S3ErrorCode.METHOD_NOT_ALLOWED);
        }
        String contentLengthString = request.getHeader("Content-Length");
        if (contentLengthString != null) {
            long contentLength;
            try {
                contentLength = Long.parseLong(contentLengthString);
            }
            catch (NumberFormatException nfe) {
                throw new S3Exception(S3ErrorCode.INVALID_ARGUMENT, (Throwable)nfe);
            }
            if (contentLength < 0L) {
                throw new S3Exception(S3ErrorCode.INVALID_ARGUMENT);
            }
        }
        try (PushbackInputStream pis = new PushbackInputStream(is);){
            int ch = pis.read();
            if (ch == -1) {
                locationString = null;
            } else {
                pis.unread(ch);
                CreateBucketRequest cbr = (CreateBucketRequest)this.mapper.readValue((InputStream)pis, CreateBucketRequest.class);
                locationString = cbr.locationConstraint;
            }
        }
        Location location = null;
        if (locationString != null) {
            for (Location loc : blobStore.listAssignableLocations()) {
                if (!loc.getId().equalsIgnoreCase(locationString)) continue;
                location = loc;
                break;
            }
            if (location == null) {
                throw new S3Exception(S3ErrorCode.INVALID_LOCATION_CONSTRAINT);
            }
        }
        logger.debug("Creating bucket with location: {}", location);
        CreateContainerOptions options = new CreateContainerOptions();
        String acl = request.getHeader("x-amz-acl");
        if ("public-read".equalsIgnoreCase(acl)) {
            options.publicRead();
        }
        try {
            created = blobStore.createContainerInLocation(location, containerName, options);
        }
        catch (AuthorizationException ae) {
            if (ae.getCause() instanceof AccessDeniedException) {
                throw new S3Exception(S3ErrorCode.ACCESS_DENIED, "Could not create bucket", ae);
            }
            throw new S3Exception(S3ErrorCode.BUCKET_ALREADY_EXISTS, (Throwable)ae);
        }
        if (!created) {
            throw new S3Exception(S3ErrorCode.BUCKET_ALREADY_OWNED_BY_YOU, S3ErrorCode.BUCKET_ALREADY_OWNED_BY_YOU.getMessage(), null, (Map<String, String>)ImmutableMap.of((Object)"BucketName", (Object)containerName));
        }
        response.addHeader("Location", "/" + containerName);
    }

    private static void handleContainerDelete(HttpServletResponse response, BlobStore blobStore, String containerName) throws IOException, S3Exception {
        if (!blobStore.containerExists(containerName)) {
            throw new S3Exception(S3ErrorCode.NO_SUCH_BUCKET);
        }
        String blobStoreType = S3ProxyHandler.getBlobStoreType(blobStore);
        if (blobStoreType.equals("b2")) {
            for (MultipartUpload mpu : blobStore.listMultipartUploads(containerName)) {
                blobStore.abortMultipartUpload(mpu);
            }
        }
        if (!blobStore.deleteContainerIfEmpty(containerName)) {
            throw new S3Exception(S3ErrorCode.BUCKET_NOT_EMPTY);
        }
        response.setStatus(204);
    }

    private void handleBlobList(HttpServletRequest request, HttpServletResponse response, BlobStore blobStore, String containerName) throws IOException, S3Exception {
        String marker;
        String blobStoreType = S3ProxyHandler.getBlobStoreType(blobStore);
        ListContainerOptions options = new ListContainerOptions();
        String encodingType = request.getParameter("encoding-type");
        String delimiter = request.getParameter("delimiter");
        if (delimiter != null) {
            options.delimiter(delimiter);
        } else {
            options.recursive();
        }
        String prefix = request.getParameter("prefix");
        if (prefix != null && !prefix.isEmpty()) {
            options.prefix(prefix);
        }
        boolean isListV2 = false;
        String listType = request.getParameter("list-type");
        String continuationToken = request.getParameter("continuation-token");
        String startAfter = request.getParameter("start-after");
        if (listType == null) {
            marker = request.getParameter("marker");
        } else if (listType.equals("2")) {
            isListV2 = true;
            if (continuationToken != null && startAfter != null) {
                throw new S3Exception(S3ErrorCode.INVALID_ARGUMENT);
            }
            marker = continuationToken != null ? continuationToken : startAfter;
        } else {
            throw new S3Exception(S3ErrorCode.NOT_IMPLEMENTED);
        }
        if (marker != null) {
            String realMarker;
            if (Quirks.OPAQUE_MARKERS.contains(blobStoreType) && (realMarker = (String)this.lastKeyToMarker.getIfPresent((Object)Maps.immutableEntry((Object)containerName, (Object)marker))) != null) {
                marker = realMarker;
            }
            options.afterMarker(marker);
        }
        boolean fetchOwner = !isListV2 || "true".equals(request.getParameter("fetch-owner"));
        int maxKeys = 1000;
        String maxKeysString = request.getParameter("max-keys");
        if (maxKeysString != null) {
            try {
                maxKeys = Integer.parseInt(maxKeysString);
            }
            catch (NumberFormatException nfe) {
                throw new S3Exception(S3ErrorCode.INVALID_ARGUMENT, (Throwable)nfe);
            }
            if (maxKeys > 1000) {
                maxKeys = 1000;
            }
        }
        options.maxResults(maxKeys);
        PageSet set = blobStore.list(containerName, options);
        this.addCorsResponseHeader(request, response);
        response.setCharacterEncoding(UTF_8);
        try (PrintWriter writer = response.getWriter();){
            String nextMarker;
            response.setContentType(XML_CONTENT_TYPE);
            XMLStreamWriter xml = this.xmlOutputFactory.createXMLStreamWriter(writer);
            xml.writeStartDocument();
            xml.writeStartElement("ListBucketResult");
            xml.writeDefaultNamespace(AWS_XMLNS);
            S3ProxyHandler.writeSimpleElement(xml, "Name", containerName);
            if (prefix == null) {
                xml.writeEmptyElement("Prefix");
            } else {
                S3ProxyHandler.writeSimpleElement(xml, "Prefix", S3ProxyHandler.encodeBlob(encodingType, prefix));
            }
            if (isListV2) {
                S3ProxyHandler.writeSimpleElement(xml, "KeyCount", String.valueOf(set.size()));
            }
            S3ProxyHandler.writeSimpleElement(xml, "MaxKeys", String.valueOf(maxKeys));
            if (!isListV2) {
                if (marker == null) {
                    xml.writeEmptyElement("Marker");
                } else {
                    S3ProxyHandler.writeSimpleElement(xml, "Marker", S3ProxyHandler.encodeBlob(encodingType, marker));
                }
            } else {
                if (continuationToken == null) {
                    xml.writeEmptyElement("ContinuationToken");
                } else {
                    S3ProxyHandler.writeSimpleElement(xml, "ContinuationToken", S3ProxyHandler.encodeBlob(encodingType, continuationToken));
                }
                if (startAfter == null) {
                    xml.writeEmptyElement("StartAfter");
                } else {
                    S3ProxyHandler.writeSimpleElement(xml, "StartAfter", S3ProxyHandler.encodeBlob(encodingType, startAfter));
                }
            }
            if (!Strings.isNullOrEmpty((String)delimiter)) {
                S3ProxyHandler.writeSimpleElement(xml, "Delimiter", S3ProxyHandler.encodeBlob(encodingType, delimiter));
            }
            if (encodingType != null && encodingType.equals("url")) {
                S3ProxyHandler.writeSimpleElement(xml, "EncodingType", encodingType);
            }
            if ((nextMarker = set.getNextMarker()) != null) {
                StorageMetadata sm;
                S3ProxyHandler.writeSimpleElement(xml, "IsTruncated", "true");
                S3ProxyHandler.writeSimpleElement(xml, isListV2 ? "NextContinuationToken" : "NextMarker", S3ProxyHandler.encodeBlob(encodingType, nextMarker));
                if (Quirks.OPAQUE_MARKERS.contains(blobStoreType) && (sm = (StorageMetadata)Streams.findLast((Stream)set.stream()).orElse(null)) != null) {
                    this.lastKeyToMarker.put((Object)Maps.immutableEntry((Object)containerName, (Object)sm.getName()), (Object)nextMarker);
                }
            } else {
                S3ProxyHandler.writeSimpleElement(xml, "IsTruncated", "false");
            }
            TreeSet<String> commonPrefixes = new TreeSet<String>();
            block12: for (StorageMetadata metadata : set) {
                String eTag;
                switch (metadata.getType()) {
                    case FOLDER: 
                    case RELATIVE_PATH: {
                        commonPrefixes.add(metadata.getName());
                        continue block12;
                    }
                }
                xml.writeStartElement("Contents");
                S3ProxyHandler.writeSimpleElement(xml, "Key", S3ProxyHandler.encodeBlob(encodingType, metadata.getName()));
                Date lastModified = metadata.getLastModified();
                if (lastModified != null) {
                    S3ProxyHandler.writeSimpleElement(xml, "LastModified", S3ProxyHandler.formatDate(lastModified));
                }
                if ((eTag = metadata.getETag()) != null) {
                    S3ProxyHandler.writeSimpleElement(xml, "ETag", S3ProxyHandler.maybeQuoteETag(eTag));
                }
                S3ProxyHandler.writeSimpleElement(xml, "Size", String.valueOf(metadata.getSize()));
                S3ProxyHandler.writeSimpleElement(xml, "StorageClass", ObjectMetadata.StorageClass.fromTier((Tier)metadata.getTier()).toString());
                if (fetchOwner) {
                    S3ProxyHandler.writeOwnerStanza(xml);
                }
                xml.writeEndElement();
            }
            for (String commonPrefix : commonPrefixes) {
                xml.writeStartElement("CommonPrefixes");
                S3ProxyHandler.writeSimpleElement(xml, "Prefix", S3ProxyHandler.encodeBlob(encodingType, commonPrefix));
                xml.writeEndElement();
            }
            xml.writeEndElement();
            xml.flush();
        }
        catch (XMLStreamException xse) {
            throw new IOException(xse);
        }
    }

    private static void handleBlobRemove(HttpServletResponse response, BlobStore blobStore, String containerName, String blobName) throws IOException, S3Exception {
        blobStore.removeBlob(containerName, blobName);
        response.sendError(204);
    }

    private void handleMultiBlobRemove(HttpServletResponse response, InputStream is, BlobStore blobStore, String containerName) throws IOException, S3Exception {
        DeleteMultipleObjectsRequest dmor = (DeleteMultipleObjectsRequest)this.mapper.readValue(is, DeleteMultipleObjectsRequest.class);
        if (dmor.objects == null) {
            throw new S3Exception(S3ErrorCode.MALFORMED_X_M_L);
        }
        ArrayList<String> blobNames = new ArrayList<String>();
        for (DeleteMultipleObjectsRequest.S3Object s3Object : dmor.objects) {
            blobNames.add(s3Object.key);
        }
        blobStore.removeBlobs(containerName, blobNames);
        response.setCharacterEncoding(UTF_8);
        try (PrintWriter writer = response.getWriter();){
            response.setContentType(XML_CONTENT_TYPE);
            XMLStreamWriter xml = this.xmlOutputFactory.createXMLStreamWriter(writer);
            xml.writeStartDocument();
            xml.writeStartElement("DeleteResult");
            xml.writeDefaultNamespace(AWS_XMLNS);
            if (!dmor.quiet) {
                for (String blobName : blobNames) {
                    xml.writeStartElement("Deleted");
                    S3ProxyHandler.writeSimpleElement(xml, "Key", blobName);
                    xml.writeEndElement();
                }
            }
            xml.writeEndElement();
            xml.flush();
        }
        catch (XMLStreamException xse) {
            throw new IOException(xse);
        }
    }

    private static void handleBlobMetadata(HttpServletRequest request, HttpServletResponse response, BlobStore blobStore, String containerName, String blobName) throws IOException, S3Exception {
        Date lastModified;
        BlobMetadata metadata = blobStore.blobMetadata(containerName, blobName);
        if (metadata == null) {
            throw new S3Exception(S3ErrorCode.NO_SUCH_KEY);
        }
        String ifMatch = request.getHeader("If-Match");
        String ifNoneMatch = request.getHeader("If-None-Match");
        long ifModifiedSince = request.getDateHeader("If-Modified-Since");
        long ifUnmodifiedSince = request.getDateHeader("If-Unmodified-Since");
        String eTag = metadata.getETag();
        if (eTag != null) {
            eTag = S3ProxyHandler.maybeQuoteETag(eTag);
            if (ifMatch != null && !ifMatch.equals(eTag)) {
                throw new S3Exception(S3ErrorCode.PRECONDITION_FAILED);
            }
            if (ifNoneMatch != null && ifNoneMatch.equals(eTag)) {
                response.setStatus(304);
                return;
            }
        }
        if ((lastModified = metadata.getLastModified()) != null) {
            if (ifModifiedSince != -1L && lastModified.compareTo(new Date(ifModifiedSince)) <= 0) {
                throw new S3Exception(S3ErrorCode.PRECONDITION_FAILED);
            }
            if (ifUnmodifiedSince != -1L && lastModified.compareTo(new Date(ifUnmodifiedSince)) >= 0) {
                response.setStatus(304);
                return;
            }
        }
        response.setStatus(200);
        S3ProxyHandler.addMetadataToResponse(request, response, metadata);
    }

    private void handleOptionsBlob(HttpServletRequest request, HttpServletResponse response, BlobStore blobStore, String containerName) throws IOException, S3Exception {
        if (!blobStore.containerExists(containerName)) {
            throw new S3Exception(S3ErrorCode.ACCESS_DENIED);
        }
        String corsOrigin = request.getHeader("Origin");
        if (Strings.isNullOrEmpty((String)corsOrigin)) {
            throw new S3Exception(S3ErrorCode.INVALID_CORS_ORIGIN);
        }
        if (!this.corsRules.isOriginAllowed(corsOrigin)) {
            throw new S3Exception(S3ErrorCode.ACCESS_DENIED);
        }
        String corsMethod = request.getHeader("Access-Control-Request-Method");
        if (!this.corsRules.isMethodAllowed(corsMethod)) {
            throw new S3Exception(S3ErrorCode.INVALID_CORS_METHOD);
        }
        String corsHeaders = request.getHeader("Access-Control-Request-Headers");
        if (!Strings.isNullOrEmpty((String)corsHeaders)) {
            if (this.corsRules.isEveryHeaderAllowed(corsHeaders)) {
                response.addHeader("Access-Control-Allow-Headers", corsHeaders);
            } else {
                throw new S3Exception(S3ErrorCode.ACCESS_DENIED);
            }
        }
        response.addHeader("Vary", "Origin");
        response.addHeader("Access-Control-Allow-Origin", this.corsRules.getAllowedOrigin(corsOrigin));
        response.addHeader("Access-Control-Allow-Methods", this.corsRules.getAllowedMethods());
        response.setStatus(200);
    }

    private void handleGetBlob(HttpServletRequest request, HttpServletResponse response, BlobStore blobStore, String containerName, String blobName) throws IOException, S3Exception {
        Blob blob;
        String range;
        long ifUnmodifiedSince;
        long ifModifiedSince;
        String ifNoneMatch;
        int status = 200;
        GetOptions options = new GetOptions();
        String ifMatch = request.getHeader("If-Match");
        if (ifMatch != null) {
            options.ifETagMatches(ifMatch);
        }
        if ((ifNoneMatch = request.getHeader("If-None-Match")) != null) {
            options.ifETagDoesntMatch(ifNoneMatch);
        }
        if ((ifModifiedSince = request.getDateHeader("If-Modified-Since")) != -1L) {
            options.ifModifiedSince(new Date(ifModifiedSince));
        }
        if ((ifUnmodifiedSince = request.getDateHeader("If-Unmodified-Since")) != -1L) {
            options.ifUnmodifiedSince(new Date(ifUnmodifiedSince));
        }
        if ((range = request.getHeader("Range")) != null && range.startsWith("bytes=") && range.indexOf(44) == -1) {
            String[] ranges = (range = range.substring("bytes=".length())).split("-", 2);
            if (ranges[0].isEmpty()) {
                options.tail(Long.parseLong(ranges[1]));
            } else if (ranges[1].isEmpty()) {
                options.startAt(Long.parseLong(ranges[0]));
            } else {
                options.range(Long.parseLong(ranges[0]), Long.parseLong(ranges[1]));
            }
            status = 206;
        }
        if ((blob = blobStore.getBlob(containerName, blobName, options)) == null) {
            throw new S3Exception(S3ErrorCode.NO_SUCH_KEY);
        }
        response.setStatus(status);
        this.addCorsResponseHeader(request, response);
        S3ProxyHandler.addMetadataToResponse(request, response, (BlobMetadata)blob.getMetadata());
        Collection contentRanges = blob.getAllHeaders().get((Object)"Content-Range");
        if (!contentRanges.isEmpty()) {
            response.addHeader("Content-Range", (String)contentRanges.iterator().next());
            response.addHeader("Accept-Ranges", "bytes");
        }
        try (InputStream is = blob.getPayload().openStream();
             ServletOutputStream os = response.getOutputStream();){
            ByteStreams.copy((InputStream)is, (OutputStream)os);
            os.flush();
        }
    }

    private void handleCopyBlob(HttpServletRequest request, HttpServletResponse response, InputStream is, BlobStore blobStore, String destContainerName, String destBlobName) throws IOException, S3Exception {
        String eTag;
        long ifUnmodifiedSince;
        long ifModifiedSince;
        String ifNoneMatch;
        String[] path;
        String copySourceHeader = request.getHeader("x-amz-copy-source");
        if ((copySourceHeader = URLDecoder.decode(copySourceHeader, UTF_8)).startsWith("/")) {
            copySourceHeader = copySourceHeader.substring(1);
        }
        if ((path = copySourceHeader.split("/", 2)).length != 2) {
            throw new S3Exception(S3ErrorCode.INVALID_REQUEST);
        }
        String sourceContainerName = path[0];
        String sourceBlobName = path[1];
        boolean replaceMetadata = "REPLACE".equalsIgnoreCase(request.getHeader("x-amz-metadata-directive"));
        if (sourceContainerName.equals(destContainerName) && sourceBlobName.equals(destBlobName) && !replaceMetadata) {
            throw new S3Exception(S3ErrorCode.INVALID_REQUEST);
        }
        CopyOptions.Builder options = CopyOptions.builder();
        String ifMatch = request.getHeader("x-amz-copy-source-if-match");
        if (ifMatch != null) {
            options.ifMatch(ifMatch);
        }
        if ((ifNoneMatch = request.getHeader("x-amz-copy-source-if-none-match")) != null) {
            options.ifNoneMatch(ifNoneMatch);
        }
        if ((ifModifiedSince = request.getDateHeader("x-amz-copy-source-if-modified-since")) != -1L) {
            options.ifModifiedSince(new Date(ifModifiedSince));
        }
        if ((ifUnmodifiedSince = request.getDateHeader("x-amz-copy-source-if-unmodified-since")) != -1L) {
            options.ifUnmodifiedSince(new Date(ifUnmodifiedSince));
        }
        if (replaceMetadata) {
            ContentMetadataBuilder contentMetadata = ContentMetadataBuilder.create();
            ImmutableMap.Builder userMetadata = ImmutableMap.builder();
            for (String headerName : Collections.list(request.getHeaderNames())) {
                String headerValue = Strings.nullToEmpty((String)request.getHeader(headerName));
                if (headerName.equalsIgnoreCase("Cache-Control")) {
                    contentMetadata.cacheControl(headerValue);
                    continue;
                }
                if (headerName.equalsIgnoreCase("Content-Disposition")) {
                    contentMetadata.contentDisposition(headerValue);
                    continue;
                }
                if (headerName.equalsIgnoreCase("Content-Encoding")) {
                    contentMetadata.contentEncoding(headerValue);
                    continue;
                }
                if (headerName.equalsIgnoreCase("Content-Language")) {
                    contentMetadata.contentLanguage(headerValue);
                    continue;
                }
                if (headerName.equalsIgnoreCase("Content-Type")) {
                    contentMetadata.contentType(headerValue);
                    continue;
                }
                if (!S3ProxyHandler.startsWithIgnoreCase(headerName, USER_METADATA_PREFIX)) continue;
                userMetadata.put((Object)headerName.substring(USER_METADATA_PREFIX.length()), (Object)headerValue);
            }
            options.contentMetadata(contentMetadata.build());
            options.userMetadata((Map)userMetadata.build());
        }
        try {
            eTag = blobStore.copyBlob(sourceContainerName, sourceBlobName, destContainerName, destBlobName, options.build());
        }
        catch (KeyNotFoundException knfe) {
            throw new S3Exception(S3ErrorCode.NO_SUCH_KEY, (Throwable)knfe);
        }
        String cannedAcl = request.getHeader("x-amz-acl");
        if (cannedAcl != null && !cannedAcl.equalsIgnoreCase("private")) {
            this.handleSetBlobAcl(request, response, is, blobStore, destContainerName, destBlobName);
        }
        BlobMetadata blobMetadata = blobStore.blobMetadata(destContainerName, destBlobName);
        response.setCharacterEncoding(UTF_8);
        try (PrintWriter writer = response.getWriter();){
            response.setContentType(XML_CONTENT_TYPE);
            XMLStreamWriter xml = this.xmlOutputFactory.createXMLStreamWriter(writer);
            xml.writeStartDocument();
            xml.writeStartElement("CopyObjectResult");
            xml.writeDefaultNamespace(AWS_XMLNS);
            S3ProxyHandler.writeSimpleElement(xml, "LastModified", S3ProxyHandler.formatDate(blobMetadata.getLastModified()));
            S3ProxyHandler.writeSimpleElement(xml, "ETag", S3ProxyHandler.maybeQuoteETag(eTag));
            xml.writeEndElement();
            xml.flush();
        }
        catch (XMLStreamException xse) {
            throw new IOException(xse);
        }
    }

    private void handlePutBlob(HttpServletRequest request, HttpServletResponse response, InputStream is, BlobStore blobStore, String containerName, String blobName) throws IOException, S3Exception {
        BlobAccess access;
        long contentLength;
        String contentLengthString = null;
        String decodedContentLengthString = null;
        String contentMD5String = null;
        for (String headerName : Collections.list(request.getHeaderNames())) {
            String headerValue = Strings.nullToEmpty((String)request.getHeader(headerName));
            if (headerName.equalsIgnoreCase("Content-Length")) {
                contentLengthString = headerValue;
                continue;
            }
            if (headerName.equalsIgnoreCase("x-amz-decoded-content-length")) {
                decodedContentLengthString = headerValue;
                continue;
            }
            if (!headerName.equalsIgnoreCase("Content-MD5")) continue;
            contentMD5String = headerValue;
        }
        if (decodedContentLengthString != null) {
            contentLengthString = decodedContentLengthString;
        }
        HashCode contentMD5 = null;
        if (contentMD5String != null) {
            try {
                contentMD5 = HashCode.fromBytes((byte[])Base64.getDecoder().decode(contentMD5String));
            }
            catch (IllegalArgumentException iae) {
                throw new S3Exception(S3ErrorCode.INVALID_DIGEST, (Throwable)iae);
            }
            if (contentMD5.bits() != MD5.bits()) {
                throw new S3Exception(S3ErrorCode.INVALID_DIGEST);
            }
        }
        if (contentLengthString == null) {
            throw new S3Exception(S3ErrorCode.MISSING_CONTENT_LENGTH);
        }
        try {
            contentLength = Long.parseLong(contentLengthString);
        }
        catch (NumberFormatException nfe) {
            throw new S3Exception(S3ErrorCode.INVALID_ARGUMENT, (Throwable)nfe);
        }
        if (contentLength < 0L) {
            throw new S3Exception(S3ErrorCode.INVALID_ARGUMENT);
        }
        if (contentLength > this.maxSinglePartObjectSize) {
            throw new S3Exception(S3ErrorCode.ENTITY_TOO_LARGE);
        }
        String cannedAcl = request.getHeader("x-amz-acl");
        if (cannedAcl == null || cannedAcl.equalsIgnoreCase("private")) {
            access = BlobAccess.PRIVATE;
        } else if (cannedAcl.equalsIgnoreCase("public-read")) {
            access = BlobAccess.PUBLIC_READ;
        } else {
            if (CANNED_ACLS.contains(cannedAcl)) {
                throw new S3Exception(S3ErrorCode.NOT_IMPLEMENTED);
            }
            response.sendError(400);
            return;
        }
        PutOptions options = new PutOptions().setBlobAccess(access);
        String blobStoreType = S3ProxyHandler.getBlobStoreType(blobStore);
        if (blobStoreType.equals("azureblob") && contentLength > 0x10000000L) {
            options.multipart(true);
        }
        BlobBuilder.PayloadBlobBuilder builder = blobStore.blobBuilder(blobName).payload(is).contentLength(contentLength);
        String storageClass = request.getHeader("x-amz-storage-class");
        if (storageClass != null && !storageClass.equalsIgnoreCase("STANDARD")) {
            builder.tier(ObjectMetadata.StorageClass.valueOf((String)storageClass).toTier());
        }
        S3ProxyHandler.addContentMetdataFromHttpRequest(builder, request);
        if (contentMD5 != null) {
            builder = builder.contentMD5(contentMD5);
        }
        String eTag = blobStore.putBlob(containerName, builder.build(), options);
        this.addCorsResponseHeader(request, response);
        response.addHeader("ETag", S3ProxyHandler.maybeQuoteETag(eTag));
    }

    private void handlePostBlob(HttpServletRequest request, HttpServletResponse response, InputStream is, BlobStore blobStore, String containerName) throws IOException, S3Exception {
        boolean signatureVersion4;
        String boundaryHeader = request.getHeader("Content-Type");
        if (boundaryHeader == null || !boundaryHeader.startsWith("multipart/form-data; boundary=")) {
            response.setStatus(400);
            return;
        }
        String boundary = boundaryHeader.substring(boundaryHeader.indexOf(61) + 1);
        String blobName = null;
        String contentType = null;
        String identity = null;
        byte[] policy = null;
        String signature = null;
        String algorithm = null;
        byte[] payload = null;
        MultipartStream multipartStream = new MultipartStream(is, boundary.getBytes(StandardCharsets.UTF_8), 4096, null);
        boolean nextPart = multipartStream.skipPreamble();
        while (nextPart) {
            String header = multipartStream.readHeaders();
            try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
                multipartStream.readBodyData((OutputStream)baos);
                if (S3ProxyHandler.isField(header, "acl")) {
                } else if (S3ProxyHandler.isField(header, "AWSAccessKeyId") || S3ProxyHandler.isField(header, "X-Amz-Credential")) {
                    identity = new String(baos.toByteArray());
                } else if (S3ProxyHandler.isField(header, "Content-Type")) {
                    contentType = new String(baos.toByteArray());
                } else if (S3ProxyHandler.isField(header, "file")) {
                    payload = baos.toByteArray();
                } else if (S3ProxyHandler.isField(header, "key")) {
                    blobName = new String(baos.toByteArray());
                } else if (S3ProxyHandler.isField(header, "policy")) {
                    policy = baos.toByteArray();
                } else if (S3ProxyHandler.isField(header, "signature") || S3ProxyHandler.isField(header, "X-Amz-Signature")) {
                    signature = new String(baos.toByteArray());
                } else if (S3ProxyHandler.isField(header, "X-Amz-Algorithm")) {
                    algorithm = new String(baos.toByteArray());
                }
            }
            nextPart = multipartStream.readBoundary();
        }
        if (blobName == null || policy == null) {
            response.setStatus(400);
            return;
        }
        String headerAuthorization = null;
        S3AuthorizationHeader authHeader = null;
        if (algorithm == null) {
            if (identity == null || signature == null) {
                throw new S3Exception(S3ErrorCode.ACCESS_DENIED);
            }
            signatureVersion4 = false;
            headerAuthorization = "AWS " + identity + ":" + signature;
        } else if (algorithm.equals("AWS4-HMAC-SHA256")) {
            if (identity == null || signature == null) {
                throw new S3Exception(S3ErrorCode.ACCESS_DENIED);
            }
            signatureVersion4 = true;
            headerAuthorization = "AWS4-HMAC-SHA256 Credential=" + identity + ", Signature=" + signature;
        } else {
            response.setStatus(400);
            return;
        }
        try {
            authHeader = new S3AuthorizationHeader(headerAuthorization);
        }
        catch (IllegalArgumentException iae) {
            throw new S3Exception(S3ErrorCode.INVALID_ARGUMENT, (Throwable)iae);
        }
        block3 : switch (authHeader.getAuthenticationType()) {
            case AWS_V2: {
                switch (this.authenticationType) {
                    case AWS_V2: 
                    case AWS_V2_OR_V4: 
                    case NONE: {
                        break block3;
                    }
                }
                throw new S3Exception(S3ErrorCode.ACCESS_DENIED);
            }
            case AWS_V4: {
                switch (this.authenticationType) {
                    case AWS_V2_OR_V4: 
                    case NONE: 
                    case AWS_V4: {
                        break block3;
                    }
                }
                throw new S3Exception(S3ErrorCode.ACCESS_DENIED);
            }
            case NONE: {
                break;
            }
            default: {
                throw new IllegalArgumentException("Unhandled type: " + (Object)((Object)authHeader.getAuthenticationType()));
            }
        }
        Map.Entry<String, BlobStore> provider = this.blobStoreLocator.locateBlobStore(authHeader.getIdentity(), null, null);
        if (provider == null) {
            response.setStatus(403);
            return;
        }
        String credential = provider.getKey();
        if (signatureVersion4) {
            byte[] kSecret = ("AWS4" + credential).getBytes(StandardCharsets.UTF_8);
            byte[] kDate = S3ProxyHandler.hmac("HmacSHA256", authHeader.getDate().getBytes(StandardCharsets.UTF_8), kSecret);
            byte[] kRegion = S3ProxyHandler.hmac("HmacSHA256", authHeader.getRegion().getBytes(StandardCharsets.UTF_8), kDate);
            byte[] kService = S3ProxyHandler.hmac("HmacSHA256", authHeader.getService().getBytes(StandardCharsets.UTF_8), kRegion);
            byte[] kSigning = S3ProxyHandler.hmac("HmacSHA256", "aws4_request".getBytes(StandardCharsets.UTF_8), kService);
            String expectedSignature = BaseEncoding.base16().lowerCase().encode(S3ProxyHandler.hmac("HmacSHA256", policy, kSigning));
            if (!S3ProxyHandler.constantTimeEquals(signature, expectedSignature)) {
                response.setStatus(403);
                return;
            }
        } else {
            String expectedSignature = Base64.getEncoder().encodeToString(S3ProxyHandler.hmac("HmacSHA1", policy, credential.getBytes(StandardCharsets.UTF_8)));
            if (!S3ProxyHandler.constantTimeEquals(signature, expectedSignature)) {
                response.setStatus(403);
                return;
            }
        }
        BlobBuilder.PayloadBlobBuilder builder = blobStore.blobBuilder(blobName).payload(payload);
        if (contentType != null) {
            builder.contentType(contentType);
        }
        Blob blob = builder.build();
        blobStore.putBlob(containerName, blob);
        response.setStatus(204);
        this.addCorsResponseHeader(request, response);
    }

    private void handleInitiateMultipartUpload(HttpServletRequest request, HttpServletResponse response, BlobStore blobStore, String containerName, String blobName) throws IOException, S3Exception {
        BlobAccess access;
        String cannedAcl;
        ByteSource payload = ByteSource.empty();
        BlobBuilder.PayloadBlobBuilder builder = blobStore.blobBuilder(blobName).payload(payload);
        S3ProxyHandler.addContentMetdataFromHttpRequest(builder, request);
        builder.contentLength(payload.size());
        String storageClass = request.getHeader("x-amz-storage-class");
        if (storageClass != null && !storageClass.equalsIgnoreCase("STANDARD")) {
            builder.tier(ObjectMetadata.StorageClass.valueOf((String)storageClass).toTier());
        }
        if ((cannedAcl = request.getHeader("x-amz-acl")) == null || cannedAcl.equalsIgnoreCase("private")) {
            access = BlobAccess.PRIVATE;
        } else if (cannedAcl.equalsIgnoreCase("public-read")) {
            access = BlobAccess.PUBLIC_READ;
        } else {
            if (CANNED_ACLS.contains(cannedAcl)) {
                throw new S3Exception(S3ErrorCode.NOT_IMPLEMENTED);
            }
            response.sendError(400);
            return;
        }
        PutOptions options = new PutOptions().setBlobAccess(access);
        MultipartUpload mpu = blobStore.initiateMultipartUpload(containerName, (BlobMetadata)builder.build().getMetadata(), options);
        if (Quirks.MULTIPART_REQUIRES_STUB.contains(S3ProxyHandler.getBlobStoreType(blobStore))) {
            blobStore.putBlob(containerName, builder.name(mpu.id()).build(), options);
        }
        response.setCharacterEncoding(UTF_8);
        try (PrintWriter writer = response.getWriter();){
            response.setContentType(XML_CONTENT_TYPE);
            XMLStreamWriter xml = this.xmlOutputFactory.createXMLStreamWriter(writer);
            xml.writeStartDocument();
            xml.writeStartElement("InitiateMultipartUploadResult");
            xml.writeDefaultNamespace(AWS_XMLNS);
            S3ProxyHandler.writeSimpleElement(xml, "Bucket", containerName);
            S3ProxyHandler.writeSimpleElement(xml, "Key", blobName);
            S3ProxyHandler.writeSimpleElement(xml, "UploadId", mpu.id());
            xml.writeEndElement();
            xml.flush();
        }
        catch (XMLStreamException xse) {
            throw new IOException(xse);
        }
        this.addCorsResponseHeader(request, response);
    }

    private void handleCompleteMultipartUpload(HttpServletRequest request, HttpServletResponse response, InputStream is, final BlobStore blobStore, String containerName, String blobName, String uploadId) throws IOException, S3Exception {
        PutOptions options;
        MutableBlobMetadataImpl metadata;
        if (Quirks.MULTIPART_REQUIRES_STUB.contains(S3ProxyHandler.getBlobStoreType(blobStore))) {
            metadata = blobStore.getBlob(containerName, uploadId).getMetadata();
            BlobAccess access = blobStore.getBlobAccess(containerName, uploadId);
            options = new PutOptions().setBlobAccess(access);
        } else {
            metadata = new MutableBlobMetadataImpl();
            options = new PutOptions();
        }
        final MultipartUpload mpu = MultipartUpload.create((String)containerName, (String)blobName, (String)uploadId, (BlobMetadata)metadata, (PutOptions)options);
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (MultipartPart part : blobStore.listMultipartUpload(mpu)) {
            builder.put((Object)part.partNumber(), (Object)part);
        }
        final ArrayList<MultipartPart> parts = new ArrayList<MultipartPart>();
        String blobStoreType = S3ProxyHandler.getBlobStoreType(blobStore);
        if (blobStoreType.equals("azureblob")) {
            for (MultipartPart part : blobStore.listMultipartUpload(mpu)) {
                parts.add(part);
            }
        } else if (blobStoreType.equals("google-cloud-storage")) {
            MultipartUpload mpu2;
            Object subParts;
            int partNumber = 1;
            while (!(subParts = blobStore.listMultipartUpload(mpu2 = MultipartUpload.create((String)containerName, (String)String.format("%s_%08d", mpu.id(), partNumber), (String)String.format("%s_%08d", mpu.id(), partNumber), (BlobMetadata)metadata, (PutOptions)options))).isEmpty()) {
                long partSize = 0L;
                Iterator iterator = subParts.iterator();
                while (iterator.hasNext()) {
                    MultipartPart part = (MultipartPart)iterator.next();
                    partSize += part.partSize();
                }
                String eTag = blobStore.completeMultipartUpload(mpu2, (List)subParts);
                parts.add(MultipartPart.create((int)partNumber, (long)partSize, (String)eTag, null));
                ++partNumber;
            }
        } else {
            CompleteMultipartUploadRequest cmu;
            try {
                cmu = (CompleteMultipartUploadRequest)this.mapper.readValue(is, CompleteMultipartUploadRequest.class);
            }
            catch (JsonParseException jpe) {
                throw new S3Exception(S3ErrorCode.MALFORMED_X_M_L, (Throwable)jpe);
            }
            TreeMap<Integer, String> requestParts = new TreeMap<Integer, String>();
            if (cmu.parts != null) {
                for (CompleteMultipartUploadRequest.Part part : cmu.parts) {
                    requestParts.put(part.partNumber, part.eTag);
                }
            }
            ImmutableMap partsByListing = builder.build();
            Iterator it = requestParts.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry entry = it.next();
                MultipartPart part = (MultipartPart)partsByListing.get(entry.getKey());
                if (part == null) {
                    throw new S3Exception(S3ErrorCode.INVALID_PART);
                }
                long partSize = part.partSize();
                if (it.hasNext() && partSize != -1L && (partSize < 0x500000L || partSize < blobStore.getMinimumMultipartPartSize())) {
                    throw new S3Exception(S3ErrorCode.ENTITY_TOO_SMALL);
                }
                if (part.partETag() != null && !S3ProxyHandler.equalsIgnoringSurroundingQuotes(part.partETag(), (String)entry.getValue())) {
                    throw new S3Exception(S3ErrorCode.INVALID_PART);
                }
                parts.add(MultipartPart.create((int)((Integer)entry.getKey()), (long)partSize, (String)part.partETag(), (Date)part.lastModified()));
            }
        }
        if (parts.isEmpty()) {
            throw new S3Exception(S3ErrorCode.MALFORMED_X_M_L);
        }
        response.setCharacterEncoding(UTF_8);
        try (PrintWriter writer = response.getWriter();){
            response.setStatus(200);
            response.setContentType(XML_CONTENT_TYPE);
            final AtomicReference eTag = new AtomicReference();
            final AtomicReference exception = new AtomicReference();
            Thread thread = new Thread(){

                @Override
                public void run() {
                    try {
                        eTag.set(blobStore.completeMultipartUpload(mpu, parts));
                    }
                    catch (RuntimeException re) {
                        exception.set(re);
                    }
                }
            };
            thread.start();
            XMLStreamWriter xml = this.xmlOutputFactory.createXMLStreamWriter(writer);
            xml.writeStartDocument();
            xml.writeStartElement("CompleteMultipartUploadResult");
            xml.writeDefaultNamespace(AWS_XMLNS);
            xml.flush();
            while (thread.isAlive()) {
                try {
                    thread.join(1000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                writer.write("\n");
                writer.flush();
            }
            if (exception.get() != null) {
                throw (RuntimeException)exception.get();
            }
            if (Quirks.MULTIPART_REQUIRES_STUB.contains(S3ProxyHandler.getBlobStoreType(blobStore))) {
                blobStore.removeBlob(containerName, uploadId);
            }
            S3ProxyHandler.writeSimpleElement(xml, "Location", "http://Example-Bucket.s3.amazonaws.com/" + blobName);
            S3ProxyHandler.writeSimpleElement(xml, "Bucket", containerName);
            S3ProxyHandler.writeSimpleElement(xml, "Key", blobName);
            if (eTag.get() != null) {
                S3ProxyHandler.writeSimpleElement(xml, "ETag", S3ProxyHandler.maybeQuoteETag((String)eTag.get()));
            }
            xml.writeEndElement();
            xml.flush();
        }
        catch (XMLStreamException xse) {
            throw new IOException(xse);
        }
        this.addCorsResponseHeader(request, response);
    }

    private void handleAbortMultipartUpload(HttpServletRequest request, HttpServletResponse response, BlobStore blobStore, String containerName, String blobName, String uploadId) throws IOException, S3Exception {
        if (Quirks.MULTIPART_REQUIRES_STUB.contains(S3ProxyHandler.getBlobStoreType(blobStore))) {
            if (!blobStore.blobExists(containerName, uploadId)) {
                throw new S3Exception(S3ErrorCode.NO_SUCH_UPLOAD);
            }
            blobStore.removeBlob(containerName, uploadId);
        }
        this.addCorsResponseHeader(request, response);
        MultipartUpload mpu = MultipartUpload.create((String)containerName, (String)blobName, (String)uploadId, (BlobMetadata)S3ProxyHandler.createFakeBlobMetadata(blobStore), (PutOptions)new PutOptions());
        blobStore.abortMultipartUpload(mpu);
        response.sendError(204);
    }

    private void handleListParts(HttpServletRequest request, HttpServletResponse response, BlobStore blobStore, String containerName, String blobName, String uploadId) throws IOException, S3Exception {
        ArrayList<MultipartPart> parts;
        String partNumberMarker = request.getParameter("part-number-marker");
        if (partNumberMarker != null && !partNumberMarker.equals("0")) {
            throw new S3Exception(S3ErrorCode.NOT_IMPLEMENTED);
        }
        MultipartUpload mpu = MultipartUpload.create((String)containerName, (String)blobName, (String)uploadId, (BlobMetadata)S3ProxyHandler.createFakeBlobMetadata(blobStore), (PutOptions)new PutOptions());
        if (S3ProxyHandler.getBlobStoreType(blobStore).equals("azureblob")) {
            TreeMap<Integer, Long> map = new TreeMap<Integer, Long>();
            for (MultipartPart multipartPart : blobStore.listMultipartUpload(mpu)) {
                int virtualPartNumber = multipartPart.partNumber() / 10000;
                Long size = (Long)map.get(virtualPartNumber);
                map.put(virtualPartNumber, (size == null ? 0L : size) + multipartPart.partSize());
            }
            parts = new ArrayList<MultipartPart>();
            for (Map.Entry entry : map.entrySet()) {
                String eTag = "";
                Date lastModified = null;
                parts.add(MultipartPart.create((int)((Integer)entry.getKey()), (long)((Long)entry.getValue()), (String)eTag, lastModified));
            }
        } else {
            parts = blobStore.listMultipartUpload(mpu);
        }
        String encodingType = request.getParameter("encoding-type");
        response.setCharacterEncoding(UTF_8);
        try (PrintWriter writer = response.getWriter();){
            response.setContentType(XML_CONTENT_TYPE);
            XMLStreamWriter xMLStreamWriter = this.xmlOutputFactory.createXMLStreamWriter(writer);
            xMLStreamWriter.writeStartDocument();
            xMLStreamWriter.writeStartElement("ListPartsResult");
            xMLStreamWriter.writeDefaultNamespace(AWS_XMLNS);
            if (encodingType != null && encodingType.equals("url")) {
                S3ProxyHandler.writeSimpleElement(xMLStreamWriter, "EncodingType", encodingType);
            }
            S3ProxyHandler.writeSimpleElement(xMLStreamWriter, "Bucket", containerName);
            S3ProxyHandler.writeSimpleElement(xMLStreamWriter, "Key", S3ProxyHandler.encodeBlob(encodingType, blobName));
            S3ProxyHandler.writeSimpleElement(xMLStreamWriter, "UploadId", uploadId);
            S3ProxyHandler.writeInitiatorStanza(xMLStreamWriter);
            S3ProxyHandler.writeOwnerStanza(xMLStreamWriter);
            S3ProxyHandler.writeSimpleElement(xMLStreamWriter, "StorageClass", "STANDARD");
            for (MultipartPart part : parts) {
                String eTag;
                xMLStreamWriter.writeStartElement("Part");
                S3ProxyHandler.writeSimpleElement(xMLStreamWriter, "PartNumber", String.valueOf(part.partNumber()));
                Date lastModified = part.lastModified();
                if (lastModified != null) {
                    S3ProxyHandler.writeSimpleElement(xMLStreamWriter, "LastModified", S3ProxyHandler.formatDate(lastModified));
                }
                if ((eTag = part.partETag()) != null) {
                    S3ProxyHandler.writeSimpleElement(xMLStreamWriter, "ETag", S3ProxyHandler.maybeQuoteETag(eTag));
                }
                S3ProxyHandler.writeSimpleElement(xMLStreamWriter, "Size", String.valueOf(part.partSize()));
                xMLStreamWriter.writeEndElement();
            }
            xMLStreamWriter.writeEndElement();
            xMLStreamWriter.flush();
        }
        catch (XMLStreamException xse) {
            throw new IOException(xse);
        }
        this.addCorsResponseHeader(request, response);
    }

    private void handleCopyPart(HttpServletRequest request, HttpServletResponse response, BlobStore blobStore, String containerName, String blobName, String uploadId) throws IOException, S3Exception {
        Date lastModified;
        int partNumber;
        String partNumberString;
        String[] path;
        String copySourceHeader = request.getHeader("x-amz-copy-source");
        if ((copySourceHeader = URLDecoder.decode(copySourceHeader, UTF_8)).startsWith("/")) {
            copySourceHeader = copySourceHeader.substring(1);
        }
        if ((path = copySourceHeader.split("/", 2)).length != 2) {
            throw new S3Exception(S3ErrorCode.INVALID_REQUEST);
        }
        String sourceContainerName = path[0];
        String sourceBlobName = path[1];
        GetOptions options = new GetOptions();
        String range = request.getHeader("x-amz-copy-source-range");
        long expectedSize = -1L;
        if (range != null) {
            if (!range.startsWith("bytes=") || range.indexOf(44) != -1 || range.indexOf(45) == -1) {
                throw new S3Exception(S3ErrorCode.INVALID_ARGUMENT, "The x-amz-copy-source-range value must be of the form bytes=first-last where first and last are the zero-based offsets of the first and last bytes to copy");
            }
            try {
                range = range.substring("bytes=".length());
                String[] ranges = range.split("-", 2);
                if (ranges[0].isEmpty()) {
                    options.tail(Long.parseLong(ranges[1]));
                } else if (ranges[1].isEmpty()) {
                    options.startAt(Long.parseLong(ranges[0]));
                } else {
                    long start = Long.parseLong(ranges[0]);
                    long end = Long.parseLong(ranges[1]);
                    expectedSize = end - start + 1L;
                    if (expectedSize > 0x140000000L) {
                        throw new S3Exception(S3ErrorCode.INVALID_REQUEST, "The specified copy source is larger than the maximum allowable size for a copy source: 5368709120");
                    }
                    options.range(start, end);
                }
            }
            catch (NumberFormatException nfe) {
                throw new S3Exception(S3ErrorCode.INVALID_ARGUMENT, "The x-amz-copy-source-range value must be of the form bytes=first-last where first and last are the zero-based offsets of the first and last bytes to copy", nfe);
            }
        }
        if ((partNumberString = request.getParameter("partNumber")) == null) {
            throw new S3Exception(S3ErrorCode.INVALID_ARGUMENT);
        }
        try {
            partNumber = Integer.parseInt(partNumberString);
        }
        catch (NumberFormatException nfe) {
            throw new S3Exception(S3ErrorCode.INVALID_ARGUMENT, "Part number must be an integer between 1 and 10000, inclusive", nfe, (Map<String, String>)ImmutableMap.of((Object)"ArgumentName", (Object)"partNumber", (Object)"ArgumentValue", (Object)partNumberString));
        }
        if (partNumber < 1 || partNumber > 10000) {
            throw new S3Exception(S3ErrorCode.INVALID_ARGUMENT, "Part number must be an integer between 1 and 10000, inclusive", null, (Map<String, String>)ImmutableMap.of((Object)"ArgumentName", (Object)"partNumber", (Object)"ArgumentValue", (Object)partNumberString));
        }
        String blobStoreType = S3ProxyHandler.getBlobStoreType(blobStore);
        if (blobStoreType.equals("google-cloud-storage")) {
            uploadId = String.format("%s_%08d", uploadId, (partNumber - 1) / 32 + 1);
            partNumber = (partNumber - 1) % 32 + 1;
        }
        MultipartUpload mpu = MultipartUpload.create((String)containerName, (String)blobName, (String)uploadId, (BlobMetadata)S3ProxyHandler.createFakeBlobMetadata(blobStore), (PutOptions)new PutOptions());
        Blob blob = blobStore.getBlob(sourceContainerName, sourceBlobName, options);
        if (blob == null) {
            throw new S3Exception(S3ErrorCode.NO_SUCH_KEY);
        }
        MutableBlobMetadata blobMetadata = blob.getMetadata();
        if (expectedSize != -1L && blobMetadata.getSize() < expectedSize) {
            throw new S3Exception(S3ErrorCode.INVALID_RANGE);
        }
        String ifMatch = request.getHeader("x-amz-copy-source-if-match");
        String ifNoneMatch = request.getHeader("x-amz-copy-source-if-none-match");
        long ifModifiedSince = request.getDateHeader("x-amz-copy-source-if-modified-since");
        long ifUnmodifiedSince = request.getDateHeader("x-amz-copy-source-if-unmodified-since");
        String eTag = blobMetadata.getETag();
        if (eTag != null) {
            eTag = S3ProxyHandler.maybeQuoteETag(eTag);
            if (ifMatch != null && !ifMatch.equals(eTag)) {
                throw new S3Exception(S3ErrorCode.PRECONDITION_FAILED);
            }
            if (ifNoneMatch != null && ifNoneMatch.equals(eTag)) {
                throw new S3Exception(S3ErrorCode.PRECONDITION_FAILED);
            }
        }
        if ((lastModified = blobMetadata.getLastModified()) != null) {
            if (ifModifiedSince != -1L && lastModified.compareTo(new Date(ifModifiedSince)) <= 0) {
                throw new S3Exception(S3ErrorCode.PRECONDITION_FAILED);
            }
            if (ifUnmodifiedSince != -1L && lastModified.compareTo(new Date(ifUnmodifiedSince)) >= 0) {
                throw new S3Exception(S3ErrorCode.PRECONDITION_FAILED);
            }
        }
        long contentLength = blobMetadata.getContentMetadata().getContentLength();
        try (InputStream is = blob.getPayload().openStream();){
            if (blobStoreType.equals("azureblob")) {
                long azureMaximumMultipartPartSize = blobStore.getMaximumMultipartPartSize();
                HashingInputStream his = new HashingInputStream(MD5, is);
                int subPartNumber = 0;
                long offset = 0L;
                while (offset < contentLength) {
                    InputStreamPayload payload = Payloads.newInputStreamPayload((InputStream)new UncloseableInputStream(ByteStreams.limit((InputStream)his, (long)azureMaximumMultipartPartSize)));
                    payload.getContentMetadata().setContentLength(Long.valueOf(Math.min(azureMaximumMultipartPartSize, contentLength - offset)));
                    blobStore.uploadMultipartPart(mpu, 10000 * partNumber + subPartNumber, (Payload)payload);
                    offset += azureMaximumMultipartPartSize;
                    ++subPartNumber;
                }
                eTag = BaseEncoding.base16().lowerCase().encode(his.hash().asBytes());
            } else {
                InputStreamPayload payload = Payloads.newInputStreamPayload((InputStream)is);
                payload.getContentMetadata().setContentLength(Long.valueOf(contentLength));
                MultipartPart part = blobStore.uploadMultipartPart(mpu, partNumber, (Payload)payload);
                eTag = part.partETag();
            }
        }
        response.setCharacterEncoding(UTF_8);
        try (PrintWriter writer = response.getWriter();){
            response.setContentType(XML_CONTENT_TYPE);
            XMLStreamWriter xml = this.xmlOutputFactory.createXMLStreamWriter(writer);
            xml.writeStartDocument();
            xml.writeStartElement("CopyObjectResult");
            xml.writeDefaultNamespace(AWS_XMLNS);
            S3ProxyHandler.writeSimpleElement(xml, "LastModified", S3ProxyHandler.formatDate(lastModified));
            if (eTag != null) {
                S3ProxyHandler.writeSimpleElement(xml, "ETag", S3ProxyHandler.maybeQuoteETag(eTag));
            }
            xml.writeEndElement();
            xml.flush();
        }
        catch (XMLStreamException xse) {
            throw new IOException(xse);
        }
        this.addCorsResponseHeader(request, response);
    }

    private void handleUploadPart(HttpServletRequest request, HttpServletResponse response, InputStream is, BlobStore blobStore, String containerName, String blobName, String uploadId) throws IOException, S3Exception {
        int partNumber;
        long contentLength;
        String contentLengthString = null;
        String decodedContentLengthString = null;
        String contentMD5String = null;
        for (String headerName : Collections.list(request.getHeaderNames())) {
            String headerValue = Strings.nullToEmpty((String)request.getHeader(headerName));
            if (headerName.equalsIgnoreCase("Content-Length")) {
                contentLengthString = headerValue;
                continue;
            }
            if (headerName.equalsIgnoreCase("x-amz-decoded-content-length")) {
                decodedContentLengthString = headerValue;
                continue;
            }
            if (!headerName.equalsIgnoreCase("Content-MD5")) continue;
            contentMD5String = headerValue;
        }
        if (decodedContentLengthString != null) {
            contentLengthString = decodedContentLengthString;
        }
        HashCode contentMD5 = null;
        if (contentMD5String != null) {
            try {
                contentMD5 = HashCode.fromBytes((byte[])Base64.getDecoder().decode(contentMD5String));
            }
            catch (IllegalArgumentException iae) {
                throw new S3Exception(S3ErrorCode.INVALID_DIGEST, (Throwable)iae);
            }
            if (contentMD5.bits() != MD5.bits()) {
                throw new S3Exception(S3ErrorCode.INVALID_DIGEST);
            }
        }
        if (contentLengthString == null) {
            throw new S3Exception(S3ErrorCode.MISSING_CONTENT_LENGTH);
        }
        try {
            contentLength = Long.parseLong(contentLengthString);
        }
        catch (NumberFormatException nfe) {
            throw new S3Exception(S3ErrorCode.INVALID_ARGUMENT, (Throwable)nfe);
        }
        if (contentLength < 0L) {
            throw new S3Exception(S3ErrorCode.INVALID_ARGUMENT);
        }
        String partNumberString = request.getParameter("partNumber");
        if (partNumberString == null) {
            throw new S3Exception(S3ErrorCode.INVALID_ARGUMENT);
        }
        try {
            partNumber = Integer.parseInt(partNumberString);
        }
        catch (NumberFormatException nfe) {
            throw new S3Exception(S3ErrorCode.INVALID_ARGUMENT, "Part number must be an integer between 1 and 10000, inclusive", nfe, (Map<String, String>)ImmutableMap.of((Object)"ArgumentName", (Object)"partNumber", (Object)"ArgumentValue", (Object)partNumberString));
        }
        if (partNumber < 1 || partNumber > 10000) {
            throw new S3Exception(S3ErrorCode.INVALID_ARGUMENT, "Part number must be an integer between 1 and 10000, inclusive", null, (Map<String, String>)ImmutableMap.of((Object)"ArgumentName", (Object)"partNumber", (Object)"ArgumentValue", (Object)partNumberString));
        }
        String blobStoreType = S3ProxyHandler.getBlobStoreType(blobStore);
        if (blobStoreType.equals("google-cloud-storage")) {
            uploadId = String.format("%s_%08d", uploadId, (partNumber - 1) / 32 + 1);
            partNumber = (partNumber - 1) % 32 + 1;
        }
        BlobMetadata blobMetadata = Quirks.MULTIPART_REQUIRES_STUB.contains(S3ProxyHandler.getBlobStoreType(blobStore)) ? blobStore.blobMetadata(containerName, uploadId) : S3ProxyHandler.createFakeBlobMetadata(blobStore);
        MultipartUpload mpu = MultipartUpload.create((String)containerName, (String)blobName, (String)uploadId, (BlobMetadata)blobMetadata, (PutOptions)new PutOptions());
        if (S3ProxyHandler.getBlobStoreType(blobStore).equals("azureblob")) {
            long azureMaximumMultipartPartSize = blobStore.getMaximumMultipartPartSize();
            HashingInputStream his = new HashingInputStream(MD5, is);
            int subPartNumber = 0;
            long offset = 0L;
            while (offset < contentLength) {
                InputStreamPayload payload = Payloads.newInputStreamPayload((InputStream)ByteStreams.limit((InputStream)his, (long)azureMaximumMultipartPartSize));
                payload.getContentMetadata().setContentLength(Long.valueOf(Math.min(azureMaximumMultipartPartSize, contentLength - offset)));
                blobStore.uploadMultipartPart(mpu, 10000 * partNumber + subPartNumber, (Payload)payload);
                offset += azureMaximumMultipartPartSize;
                ++subPartNumber;
            }
            response.addHeader("ETag", S3ProxyHandler.maybeQuoteETag(BaseEncoding.base16().lowerCase().encode(his.hash().asBytes())));
        } else {
            MultipartPart part;
            InputStreamPayload payload = Payloads.newInputStreamPayload((InputStream)is);
            payload.getContentMetadata().setContentLength(Long.valueOf(contentLength));
            if (contentMD5 != null) {
                payload.getContentMetadata().setContentMD5(contentMD5);
            }
            if ((part = blobStore.uploadMultipartPart(mpu, partNumber, (Payload)payload)).partETag() != null) {
                response.addHeader("ETag", S3ProxyHandler.maybeQuoteETag(part.partETag()));
            }
        }
        this.addCorsResponseHeader(request, response);
    }

    private static void addResponseHeaderWithOverride(HttpServletRequest request, HttpServletResponse response, String headerName, String overrideHeaderName, String value) {
        String override = request.getParameter(overrideHeaderName);
        String string = override = override != null ? override : value;
        if (override != null) {
            response.addHeader(headerName, override);
        }
    }

    private static void addMetadataToResponse(HttpServletRequest request, HttpServletResponse response, BlobMetadata metadata) {
        String overrideExpires;
        String overrideContentType;
        ContentMetadata contentMetadata = metadata.getContentMetadata();
        S3ProxyHandler.addResponseHeaderWithOverride(request, response, "Cache-Control", "response-cache-control", contentMetadata.getCacheControl());
        S3ProxyHandler.addResponseHeaderWithOverride(request, response, "Content-Encoding", "response-content-encoding", contentMetadata.getContentEncoding());
        S3ProxyHandler.addResponseHeaderWithOverride(request, response, "Content-Language", "response-content-language", contentMetadata.getContentLanguage());
        S3ProxyHandler.addResponseHeaderWithOverride(request, response, "Content-Disposition", "response-content-disposition", contentMetadata.getContentDisposition());
        Long contentLength = contentMetadata.getContentLength();
        if (contentLength != null) {
            response.addHeader("Content-Length", contentLength.toString());
        }
        response.setContentType((overrideContentType = request.getParameter("response-content-type")) != null ? overrideContentType : contentMetadata.getContentType());
        String eTag = metadata.getETag();
        if (eTag != null) {
            response.addHeader("ETag", S3ProxyHandler.maybeQuoteETag(eTag));
        }
        if ((overrideExpires = request.getParameter("response-expires")) != null) {
            response.addHeader("Expires", overrideExpires);
        } else {
            Date expires = contentMetadata.getExpires();
            if (expires != null) {
                response.addDateHeader("Expires", expires.getTime());
            }
        }
        response.addDateHeader("Last-Modified", metadata.getLastModified().getTime());
        Tier tier = metadata.getTier();
        if (tier != null) {
            response.addHeader("x-amz-storage-class", ObjectMetadata.StorageClass.fromTier((Tier)tier).toString());
        }
        for (Map.Entry entry : metadata.getUserMetadata().entrySet()) {
            response.addHeader(USER_METADATA_PREFIX + (String)entry.getKey(), (String)entry.getValue());
        }
    }

    private static long parseIso8601(String date) {
        SimpleDateFormat formatter = new SimpleDateFormat("yyyyMMdd'T'HHmmss'Z'");
        formatter.setTimeZone(TimeZone.getTimeZone("UTC"));
        try {
            return formatter.parse(date).getTime() / 1000L;
        }
        catch (ParseException pe) {
            throw new IllegalArgumentException(pe);
        }
    }

    private void isTimeSkewed(long date) throws S3Exception {
        if (date < 0L) {
            throw new S3Exception(S3ErrorCode.ACCESS_DENIED);
        }
        long now = System.currentTimeMillis() / 1000L;
        if (now + (long)this.maximumTimeSkew < date || now - (long)this.maximumTimeSkew > date) {
            logger.debug("time skewed {} {}", (Object)date, (Object)now);
            throw new S3Exception(S3ErrorCode.REQUEST_TIME_TOO_SKEWED);
        }
    }

    private static String formatDate(Date date) {
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
        formatter.setTimeZone(TimeZone.getTimeZone("GMT"));
        return formatter.format(date);
    }

    protected final void sendSimpleErrorResponse(HttpServletRequest request, HttpServletResponse response, S3ErrorCode code, String message, Map<String, String> elements) throws IOException {
        logger.debug("sendSimpleErrorResponse: {} {}", (Object)code, elements);
        if (response.isCommitted()) {
            return;
        }
        response.setStatus(code.getHttpStatusCode());
        if (request.getMethod().equals("HEAD")) {
            return;
        }
        response.setCharacterEncoding(UTF_8);
        try (PrintWriter writer = response.getWriter();){
            response.setContentType(XML_CONTENT_TYPE);
            XMLStreamWriter xml = this.xmlOutputFactory.createXMLStreamWriter(writer);
            xml.writeStartDocument();
            xml.writeStartElement("Error");
            S3ProxyHandler.writeSimpleElement(xml, "Code", code.getErrorCode());
            S3ProxyHandler.writeSimpleElement(xml, "Message", message);
            for (Map.Entry<String, String> entry : elements.entrySet()) {
                S3ProxyHandler.writeSimpleElement(xml, entry.getKey(), entry.getValue());
            }
            S3ProxyHandler.writeSimpleElement(xml, "RequestId", FAKE_REQUEST_ID);
            xml.writeEndElement();
            xml.flush();
        }
        catch (XMLStreamException xse) {
            throw new IOException(xse);
        }
    }

    private void addCorsResponseHeader(HttpServletRequest request, HttpServletResponse response) {
        String corsOrigin = request.getHeader("Origin");
        if (!Strings.isNullOrEmpty((String)corsOrigin) && this.corsRules.isOriginAllowed(corsOrigin)) {
            response.addHeader("Access-Control-Allow-Origin", this.corsRules.getAllowedOrigin(corsOrigin));
            response.addHeader("Access-Control-Allow-Methods", this.corsRules.getAllowedMethods());
        }
    }

    private static void addContentMetdataFromHttpRequest(BlobBuilder.PayloadBlobBuilder builder, HttpServletRequest request) {
        long expires;
        ImmutableMap.Builder userMetadata = ImmutableMap.builder();
        for (String headerName : Collections.list(request.getHeaderNames())) {
            if (!S3ProxyHandler.startsWithIgnoreCase(headerName, USER_METADATA_PREFIX)) continue;
            userMetadata.put((Object)headerName.substring(USER_METADATA_PREFIX.length()), (Object)Strings.nullToEmpty((String)request.getHeader(headerName)));
        }
        builder.cacheControl(request.getHeader("Cache-Control")).contentDisposition(request.getHeader("Content-Disposition")).contentEncoding(request.getHeader("Content-Encoding")).contentLanguage(request.getHeader("Content-Language")).userMetadata((Map)userMetadata.build());
        String contentType = request.getContentType();
        if (contentType != null) {
            builder.contentType(contentType);
        }
        if ((expires = request.getDateHeader("Expires")) != -1L) {
            builder.expires(new Date(expires));
        }
    }

    private static void writeInitiatorStanza(XMLStreamWriter xml) throws XMLStreamException {
        xml.writeStartElement("Initiator");
        S3ProxyHandler.writeSimpleElement(xml, "ID", FAKE_INITIATOR_ID);
        S3ProxyHandler.writeSimpleElement(xml, "DisplayName", FAKE_INITIATOR_DISPLAY_NAME);
        xml.writeEndElement();
    }

    private static void writeOwnerStanza(XMLStreamWriter xml) throws XMLStreamException {
        xml.writeStartElement("Owner");
        S3ProxyHandler.writeSimpleElement(xml, "ID", FAKE_OWNER_ID);
        S3ProxyHandler.writeSimpleElement(xml, "DisplayName", FAKE_OWNER_DISPLAY_NAME);
        xml.writeEndElement();
    }

    private static void writeSimpleElement(XMLStreamWriter xml, String elementName, String characters) throws XMLStreamException {
        xml.writeStartElement(elementName);
        xml.writeCharacters(characters);
        xml.writeEndElement();
    }

    private static BlobMetadata createFakeBlobMetadata(BlobStore blobStore) {
        return blobStore.blobBuilder("fake-name").build().getMetadata();
    }

    private static boolean equalsIgnoringSurroundingQuotes(String s1, String s2) {
        if (s1.length() >= 2 && s1.startsWith("\"") && s1.endsWith("\"")) {
            s1 = s1.substring(1, s1.length() - 1);
        }
        if (s2.length() >= 2 && s2.startsWith("\"") && s2.endsWith("\"")) {
            s2 = s2.substring(1, s2.length() - 1);
        }
        return s1.equals(s2);
    }

    private static String maybeQuoteETag(String eTag) {
        if (!eTag.startsWith("\"") && !eTag.endsWith("\"")) {
            eTag = "\"" + eTag + "\"";
        }
        return eTag;
    }

    private static boolean startsWithIgnoreCase(String string, String prefix) {
        return string.toLowerCase().startsWith(prefix.toLowerCase());
    }

    private static boolean isField(String string, String field) {
        return S3ProxyHandler.startsWithIgnoreCase(string, "Content-Disposition: form-data; name=\"" + field + "\"");
    }

    private static byte[] hmac(String algorithm, byte[] data, byte[] key) {
        try {
            Mac mac = Mac.getInstance(algorithm);
            mac.init(new SecretKeySpec(key, algorithm));
            return mac.doFinal(data);
        }
        catch (InvalidKeyException | NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }

    private static String encodeBlob(String encodingType, String blobName) {
        if (encodingType != null && encodingType.equals("url")) {
            return urlEscaper.escape(blobName);
        }
        return blobName;
    }

    public final BlobStoreLocator getBlobStoreLocator() {
        return this.blobStoreLocator;
    }

    public final void setBlobStoreLocator(BlobStoreLocator locator) {
        this.blobStoreLocator = locator;
    }

    private static boolean validateIpAddress(String string) {
        List parts = Splitter.on((char)'.').splitToList((CharSequence)string);
        if (parts.size() != 4) {
            return false;
        }
        for (String part : parts) {
            try {
                int num = Integer.parseInt(part);
                if (num >= 0 && num <= 255) continue;
                return false;
            }
            catch (NumberFormatException nfe) {
                return false;
            }
        }
        return true;
    }

    private static boolean constantTimeEquals(String x, String y) {
        return MessageDigest.isEqual(x.getBytes(StandardCharsets.UTF_8), y.getBytes(StandardCharsets.UTF_8));
    }

    private static final class UncloseableInputStream
    extends FilterInputStream {
        UncloseableInputStream(InputStream is) {
            super(is);
        }

        @Override
        public void close() throws IOException {
        }
    }
}

