/*
 * Decompiled with CFR 0.152.
 */
package org.gaul.s3proxy;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Sets;
import com.google.common.hash.HashCode;
import com.google.common.hash.HashFunction;
import com.google.common.hash.Hashing;
import java.io.File;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.jclouds.blobstore.BlobStore;
import org.jclouds.blobstore.ContainerNotFoundException;
import org.jclouds.blobstore.domain.Blob;
import org.jclouds.blobstore.domain.BlobAccess;
import org.jclouds.blobstore.domain.BlobMetadata;
import org.jclouds.blobstore.domain.ContainerAccess;
import org.jclouds.blobstore.domain.MultipartPart;
import org.jclouds.blobstore.domain.MultipartUpload;
import org.jclouds.blobstore.domain.PageSet;
import org.jclouds.blobstore.domain.StorageMetadata;
import org.jclouds.blobstore.domain.internal.MutableStorageMetadataImpl;
import org.jclouds.blobstore.domain.internal.PageSetImpl;
import org.jclouds.blobstore.options.CopyOptions;
import org.jclouds.blobstore.options.CreateContainerOptions;
import org.jclouds.blobstore.options.GetOptions;
import org.jclouds.blobstore.options.ListContainerOptions;
import org.jclouds.blobstore.options.PutOptions;
import org.jclouds.blobstore.util.ForwardingBlobStore;
import org.jclouds.domain.Location;
import org.jclouds.io.Payload;

final class ShardedBlobStore
extends ForwardingBlobStore {
    public static final Pattern PROPERTIES_PREFIX_RE = Pattern.compile("s3proxy.sharded-blobstore\\.(?<bucket>.*)\\.prefix$");
    private static final Pattern PROPERTIES_SHARDS_RE = Pattern.compile("s3proxy.sharded-blobstore\\.(?<bucket>.*)\\.shards$");
    private static final Pattern SHARD_RE = Pattern.compile("(?<prefix>.*)-(?<shard>[0-9]+)$");
    private static final HashFunction SHARD_HASH = Hashing.murmur3_128();
    private static final int MAX_SHARD_THREADS = 10;
    private static final String SUPERBLOCK_VERSION = "1.0";
    private static final String SUPERBLOCK_BLOB_NAME = ".s3proxy-sharded-superblock";
    private static final int MAX_SHARDS = 1000;
    private final ImmutableMap<String, ShardedBucket> buckets;
    private final ImmutableMap<String, String> prefixMap;

    private ShardedBlobStore(BlobStore blobStore, ImmutableMap<String, Integer> shards, ImmutableMap<String, String> prefixes) {
        super(blobStore);
        Sets.SetView missingShards = Sets.difference((Set)prefixes.keySet(), (Set)shards.keySet());
        if (!missingShards.isEmpty()) {
            String allMissingShards = missingShards.stream().collect(Collectors.joining(", "));
            throw new IllegalArgumentException(String.format("Number of shards unset for sharded buckets: %s", allMissingShards));
        }
        ImmutableMap.Builder bucketsBuilder = new ImmutableMap.Builder();
        for (String bucket : shards.keySet()) {
            String prefix = (String)prefixes.get((Object)bucket);
            if (prefix == null) {
                prefix = bucket;
            }
            bucketsBuilder.put((Object)bucket, (Object)new ShardedBucket(prefix, (Integer)shards.get((Object)bucket)));
        }
        this.buckets = bucketsBuilder.build();
        ImmutableMap.Builder prefixMapBuilder = new ImmutableMap.Builder();
        for (String virtualBucket : this.buckets.keySet()) {
            String prefix = ((ShardedBucket)this.buckets.get((Object)virtualBucket)).prefix;
            prefixMapBuilder.put((Object)prefix, (Object)virtualBucket);
        }
        this.prefixMap = prefixMapBuilder.build();
    }

    public static ImmutableMap<String, Integer> parseBucketShards(Properties properties) {
        ImmutableMap.Builder shardsMap = new ImmutableMap.Builder();
        for (String key : properties.stringPropertyNames()) {
            Matcher matcher = PROPERTIES_SHARDS_RE.matcher(key);
            if (!matcher.matches()) continue;
            String bucket = matcher.group("bucket");
            int shards = Integer.parseInt(properties.getProperty(key));
            Preconditions.checkArgument((shards > 0 && shards < 1000 ? 1 : 0) != 0, (String)"number of shards must be between 1 and 1000 for %s", (Object)bucket);
            shardsMap.put((Object)bucket, (Object)shards);
        }
        return shardsMap.build();
    }

    public static ImmutableMap<String, String> parsePrefixes(Properties properties) {
        ImmutableMap.Builder prefixesMap = new ImmutableMap.Builder();
        for (String key : properties.stringPropertyNames()) {
            Matcher matcher = PROPERTIES_PREFIX_RE.matcher(key);
            if (!matcher.matches()) continue;
            prefixesMap.put((Object)matcher.group("bucket"), (Object)properties.getProperty(key));
        }
        return prefixesMap.build();
    }

    static ShardedBlobStore newShardedBlobStore(BlobStore blobStore, ImmutableMap<String, Integer> shards, ImmutableMap<String, String> prefixes) {
        return new ShardedBlobStore(blobStore, shards, prefixes);
    }

    private Map<String, String> createSuperblockMeta(ShardedBucket bucket) {
        ImmutableMap.Builder meta = new ImmutableMap.Builder();
        meta.put((Object)"s3proxy-sharded-superblock-version", (Object)SUPERBLOCK_VERSION);
        meta.put((Object)"s3proxy-sharded-superblock-prefix", (Object)bucket.prefix);
        meta.put((Object)"s3proxy-sharded-superblock-shards", (Object)Integer.toString(bucket.shards));
        return meta.build();
    }

    private static String getShardContainer(ShardedBucket bucket, int shard) {
        return String.format("%s-%d", bucket.prefix, shard);
    }

    private String getShard(String containerName, String blob) {
        ShardedBucket bucket = (ShardedBucket)this.buckets.get((Object)containerName);
        if (bucket == null) {
            return containerName;
        }
        HashCode hash = SHARD_HASH.hashString((CharSequence)blob, StandardCharsets.UTF_8);
        return ShardedBlobStore.getShardContainer(bucket, Hashing.consistentHash((HashCode)hash, (int)bucket.shards));
    }

    private void checkSuperBlock(Blob blob, Map<String, String> expectedMeta, String container) {
        Map currentSuperblockMeta = blob.getMetadata().getUserMetadata();
        for (Map.Entry<String, String> entry : expectedMeta.entrySet()) {
            String current = (String)currentSuperblockMeta.get(entry.getKey());
            String expected = entry.getValue();
            if (expected.equalsIgnoreCase(current)) continue;
            throw new RuntimeException(String.format("Superblock block for %s does not match: %s, %s", container, expected, current));
        }
    }

    private boolean createShards(ShardedBucket bucket, Location location, CreateContainerOptions options) {
        ImmutableList.Builder futuresBuilder = new ImmutableList.Builder();
        ExecutorService executor = Executors.newFixedThreadPool(Math.min(bucket.shards, 10));
        BlobStore blobStore = this.delegate();
        for (int n = 0; n < bucket.shards; ++n) {
            String shardContainer = ShardedBlobStore.getShardContainer(bucket, n);
            futuresBuilder.add(executor.submit(() -> blobStore.createContainerInLocation(location, shardContainer, options)));
        }
        ImmutableList futures = futuresBuilder.build();
        executor.shutdown();
        boolean ret = true;
        for (Future future : futures) {
            try {
                ret &= ((Boolean)future.get()).booleanValue();
            }
            catch (InterruptedException | ExecutionException e) {
                throw new RuntimeException("Failed to create some shards", e);
            }
        }
        return ret;
    }

    public boolean createContainerInLocation(Location location, String container) {
        return this.createContainerInLocation(location, container, (CreateContainerOptions)CreateContainerOptions.NONE);
    }

    public boolean createContainerInLocation(Location location, String container, CreateContainerOptions createContainerOptions) {
        ShardedBucket bucket = (ShardedBucket)this.buckets.get((Object)container);
        if (bucket == null) {
            return this.delegate().createContainerInLocation(location, container, createContainerOptions);
        }
        Map<String, String> superblockMeta = this.createSuperblockMeta(bucket);
        Blob superblockBlob = null;
        try {
            superblockBlob = this.delegate().getBlob(ShardedBlobStore.getShardContainer(bucket, 0), SUPERBLOCK_BLOB_NAME);
        }
        catch (ContainerNotFoundException containerNotFoundException) {
            // empty catch block
        }
        if (superblockBlob != null) {
            this.checkSuperBlock(superblockBlob, superblockMeta, container);
        }
        boolean ret = this.createShards(bucket, location, createContainerOptions);
        if (superblockBlob == null) {
            superblockBlob = this.delegate().blobBuilder(SUPERBLOCK_BLOB_NAME).payload("").userMetadata(superblockMeta).build();
            this.delegate().putBlob(ShardedBlobStore.getShardContainer(bucket, 0), superblockBlob);
        }
        return ret;
    }

    public PageSet<? extends StorageMetadata> list() {
        PageSet upstream = this.delegate().list();
        ImmutableList.Builder results = new ImmutableList.Builder();
        HashSet<String> virtualBuckets = new HashSet<String>();
        for (StorageMetadata sm : upstream) {
            Matcher matcher = SHARD_RE.matcher(sm.getName());
            if (!matcher.matches()) {
                results.add((Object)sm);
                continue;
            }
            String prefix = matcher.group("prefix");
            String virtualBucketName = (String)this.prefixMap.get((Object)prefix);
            if (virtualBucketName == null) {
                results.add((Object)sm);
                continue;
            }
            if (virtualBuckets.contains(prefix)) continue;
            virtualBuckets.add(prefix);
            MutableStorageMetadataImpl virtualBucket = new MutableStorageMetadataImpl();
            virtualBucket.setCreationDate(sm.getCreationDate());
            virtualBucket.setETag(sm.getETag());
            virtualBucket.setId(sm.getProviderId());
            virtualBucket.setLastModified(sm.getLastModified());
            virtualBucket.setLocation(sm.getLocation());
            virtualBucket.setName(virtualBucketName);
            virtualBucket.setSize(sm.getSize());
            virtualBucket.setTier(sm.getTier());
            virtualBucket.setType((Enum)sm.getType());
            virtualBucket.setUri(sm.getUri());
            virtualBucket.setUserMetadata(sm.getUserMetadata());
            results.add((Object)virtualBucket);
        }
        return new PageSetImpl((Iterable)results.build(), upstream.getNextMarker());
    }

    public PageSet<? extends StorageMetadata> list(String container) {
        if (!this.buckets.containsKey((Object)container)) {
            return this.delegate().list(container);
        }
        throw new UnsupportedOperationException("sharded bucket");
    }

    public PageSet<? extends StorageMetadata> list(String container, ListContainerOptions options) {
        if (!this.buckets.containsKey((Object)container)) {
            return this.delegate().list(container, options);
        }
        throw new UnsupportedOperationException("sharded bucket");
    }

    public boolean containerExists(String container) {
        if (!this.buckets.containsKey((Object)container)) {
            return this.delegate().containerExists(container);
        }
        return true;
    }

    public ContainerAccess getContainerAccess(String container) {
        if (!this.buckets.containsKey((Object)container)) {
            return this.delegate().getContainerAccess(container);
        }
        throw new UnsupportedOperationException("sharded bucket");
    }

    public void setContainerAccess(String container, ContainerAccess containerAccess) {
        if (!this.buckets.containsKey((Object)container)) {
            this.delegate().setContainerAccess(container, containerAccess);
        }
        throw new UnsupportedOperationException("sharded bucket");
    }

    public void clearContainer(String container) {
        this.clearContainer(container, new ListContainerOptions());
    }

    public void clearContainer(String container, ListContainerOptions options) {
        throw new UnsupportedOperationException("sharded bucket");
    }

    public void deleteContainer(String container) {
        throw new UnsupportedOperationException("sharded bucket");
    }

    private boolean deleteShards(ShardedBucket bucket) {
        ImmutableList.Builder futuresBuilder = new ImmutableList.Builder();
        ExecutorService executor = Executors.newFixedThreadPool(Math.min(bucket.shards, 10));
        for (int n = 0; n < bucket.shards; ++n) {
            String shard = ShardedBlobStore.getShardContainer(bucket, n);
            futuresBuilder.add(executor.submit(() -> this.delegate().deleteContainerIfEmpty(shard)));
        }
        executor.shutdown();
        ImmutableList futures = futuresBuilder.build();
        boolean ret = true;
        for (Future future : futures) {
            try {
                ret &= ((Boolean)future.get()).booleanValue();
            }
            catch (InterruptedException | ExecutionException e) {
                throw new RuntimeException("Failed to delete shards", e);
            }
        }
        return ret;
    }

    public boolean deleteContainerIfEmpty(String container) {
        ShardedBucket bucket = (ShardedBucket)this.buckets.get((Object)container);
        if (bucket == null) {
            return this.delegate().deleteContainerIfEmpty(container);
        }
        String zeroShardContainer = ShardedBlobStore.getShardContainer(bucket, 0);
        PageSet listing = this.delegate().list(zeroShardContainer);
        if (listing.size() > 1) {
            return false;
        }
        StorageMetadata sm = (StorageMetadata)listing.iterator().next();
        if (!sm.getName().equals(SUPERBLOCK_BLOB_NAME)) {
            return false;
        }
        this.delegate().removeBlob(zeroShardContainer, SUPERBLOCK_BLOB_NAME);
        return this.deleteShards(bucket);
    }

    public boolean directoryExists(String container, String directory) {
        throw new UnsupportedOperationException("sharded bucket");
    }

    public void createDirectory(String container, String directory) {
        throw new UnsupportedOperationException("sharded bucket");
    }

    public void deleteDirectory(String container, String directory) {
        throw new UnsupportedOperationException("sharded bucket");
    }

    public boolean blobExists(String container, String name) {
        return this.delegate().blobExists(this.getShard(container, name), name);
    }

    public String putBlob(String containerName, Blob blob) {
        return this.delegate().putBlob(this.getShard(containerName, blob.getMetadata().getName()), blob);
    }

    public String putBlob(String containerName, Blob blob, PutOptions putOptions) {
        return this.delegate().putBlob(this.getShard(containerName, blob.getMetadata().getName()), blob, putOptions);
    }

    public String copyBlob(String fromContainer, String fromName, String toContainer, String toName, CopyOptions options) {
        String srcShard = this.getShard(fromContainer, fromName);
        String dstShard = this.getShard(toContainer, toName);
        return this.delegate().copyBlob(srcShard, fromName, dstShard, toName, options);
    }

    public BlobMetadata blobMetadata(String container, String name) {
        return this.delegate().blobMetadata(this.getShard(container, name), name);
    }

    public Blob getBlob(String containerName, String blobName) {
        return this.delegate().getBlob(this.getShard(containerName, blobName), blobName);
    }

    public Blob getBlob(String containerName, String blobName, GetOptions getOptions) {
        return this.delegate().getBlob(this.getShard(containerName, blobName), blobName, getOptions);
    }

    public void removeBlob(String container, String name) {
        this.delegate().removeBlob(this.getShard(container, name), name);
    }

    public void removeBlobs(String container, Iterable<String> iterable) {
        if (!this.buckets.containsKey((Object)container)) {
            this.delegate().removeBlobs(container, iterable);
        }
        HashMap<String, List> shardMap = new HashMap<String, List>();
        for (String string : iterable) {
            List shardBlobs = shardMap.computeIfAbsent(this.getShard(container, string), k -> new ArrayList());
            shardBlobs.add(string);
        }
        for (Map.Entry entry : shardMap.entrySet()) {
            this.delegate().removeBlobs((String)entry.getKey(), (Iterable)entry.getValue());
        }
    }

    public BlobAccess getBlobAccess(String container, String name) {
        return this.delegate().getBlobAccess(this.getShard(container, name), name);
    }

    public void setBlobAccess(String container, String name, BlobAccess access) {
        this.delegate().setBlobAccess(this.getShard(container, name), name, access);
    }

    public long countBlobs(String container) {
        if (!this.buckets.containsKey((Object)container)) {
            return this.delegate().countBlobs(container);
        }
        throw new UnsupportedOperationException("sharded bucket");
    }

    public long countBlobs(String container, ListContainerOptions options) {
        if (!this.buckets.containsKey((Object)container)) {
            return this.delegate().countBlobs(container, options);
        }
        throw new UnsupportedOperationException("sharded bucket");
    }

    public MultipartUpload initiateMultipartUpload(String container, BlobMetadata blobMetadata, PutOptions options) {
        if (!this.buckets.containsKey((Object)container)) {
            return this.delegate().initiateMultipartUpload(container, blobMetadata, options);
        }
        throw new UnsupportedOperationException("sharded bucket");
    }

    public void abortMultipartUpload(MultipartUpload mpu) {
        if (!this.buckets.containsKey((Object)mpu.containerName())) {
            this.delegate().abortMultipartUpload(mpu);
        }
        throw new UnsupportedOperationException("sharded bucket");
    }

    public String completeMultipartUpload(MultipartUpload mpu, List<MultipartPart> parts) {
        if (!this.buckets.containsKey((Object)mpu.containerName())) {
            return this.delegate().completeMultipartUpload(mpu, parts);
        }
        throw new UnsupportedOperationException("sharded bucket");
    }

    public MultipartPart uploadMultipartPart(MultipartUpload mpu, int partNumber, Payload payload) {
        if (!this.buckets.containsKey((Object)mpu.containerName())) {
            return this.delegate().uploadMultipartPart(mpu, partNumber, payload);
        }
        throw new UnsupportedOperationException("sharded bucket");
    }

    public List<MultipartPart> listMultipartUpload(MultipartUpload mpu) {
        if (!this.buckets.containsKey((Object)mpu.containerName())) {
            return this.delegate().listMultipartUpload(mpu);
        }
        throw new UnsupportedOperationException("sharded bucket");
    }

    public List<MultipartUpload> listMultipartUploads(String container) {
        if (!this.buckets.containsKey((Object)container)) {
            return this.delegate().listMultipartUploads(container);
        }
        throw new UnsupportedOperationException("sharded bucket");
    }

    public void downloadBlob(String container, String name, File destination) {
        this.delegate().downloadBlob(this.getShard(container, name), name, destination);
    }

    public void downloadBlob(String container, String name, File destination, ExecutorService executor) {
        this.delegate().downloadBlob(this.getShard(container, name), name, destination, executor);
    }

    public InputStream streamBlob(String container, String name) {
        return this.delegate().streamBlob(this.getShard(container, name), name);
    }

    public InputStream streamBlob(String container, String name, ExecutorService executor) {
        return this.delegate().streamBlob(this.getShard(container, name), name, executor);
    }

    private static final class ShardedBucket {
        private final String prefix;
        private final int shards;

        private ShardedBucket(String name, int shards) {
            this.prefix = Objects.requireNonNull(name);
            this.shards = shards;
        }
    }
}

