/*
 * Decompiled with CFR 0.152.
 */
package org.gaul.s3proxy.crypto;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Map;
import java.util.TreeMap;
import javax.annotation.concurrent.ThreadSafe;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.input.BoundedInputStream;
import org.gaul.s3proxy.crypto.Constants;
import org.gaul.s3proxy.crypto.DecryptionInputStream;
import org.gaul.s3proxy.crypto.PartPadding;
import org.jclouds.blobstore.BlobStore;
import org.jclouds.blobstore.domain.Blob;
import org.jclouds.blobstore.domain.BlobMetadata;
import org.jclouds.blobstore.options.GetOptions;

@ThreadSafe
public class Decryption {
    private final SecretKey encryptionKey;
    private TreeMap<Integer, PartPadding> partList;
    private long outputOffset;
    private long outputLength;
    private boolean skipFirstBlock;
    private long unencryptedSize;
    private long encryptedSize;
    private long startAt;
    private int skipParts;
    private long skipPartBytes;
    private boolean isEncrypted;

    public Decryption(SecretKeySpec key, BlobStore blobStore, BlobMetadata meta, long offset, long length) throws IOException {
        this.encryptionKey = key;
        this.outputLength = length;
        this.isEncrypted = true;
        if (meta == null || meta.getSize() <= 64L) {
            this.blobIsNotEncrypted(offset);
            return;
        }
        GetOptions options = new GetOptions();
        options.range(meta.getSize() - 64L, meta.getSize().longValue());
        Blob blob = blobStore.getBlob(meta.getContainer(), meta.getName(), options);
        PartPadding lastPartPadding = PartPadding.readPartPaddingFromBlob(blob);
        if (!Arrays.equals(lastPartPadding.getDelimiter().getBytes(StandardCharsets.UTF_8), Constants.DELIMITER)) {
            this.blobIsNotEncrypted(offset);
            return;
        }
        this.partList = new TreeMap();
        if (lastPartPadding.getPart() > 1 && meta.getSize() > lastPartPadding.getSize() + 64L) {
            this.unencryptedSize = lastPartPadding.getSize();
            this.encryptedSize = lastPartPadding.getSize() + 64L;
            int part = 1;
            this.partList.put(part, lastPartPadding);
            while (this.encryptedSize < meta.getSize()) {
                options = new GetOptions();
                long startAt = meta.getSize() - this.encryptedSize - 64L;
                long endAt = meta.getSize() - this.encryptedSize - 1L;
                options.range(startAt, endAt);
                blob = blobStore.getBlob(meta.getContainer(), meta.getName(), options);
                PartPadding partPadding = PartPadding.readPartPaddingFromBlob(blob);
                this.partList.put(++part, partPadding);
                this.encryptedSize += partPadding.getSize() + 64L;
                this.unencryptedSize += partPadding.getSize();
            }
        } else {
            this.partList.put(1, lastPartPadding);
            this.unencryptedSize = meta.getSize() - 64L;
            this.encryptedSize = meta.getSize();
        }
        this.calculateOffset(offset);
        if (offset > 0L && length == 0L) {
            this.outputLength = this.unencryptedSize - offset;
        }
    }

    private void blobIsNotEncrypted(long offset) {
        this.isEncrypted = false;
        this.startAt = offset;
    }

    public final long calculateTail() {
        long offset = this.unencryptedSize - this.outputLength;
        this.calculateOffset(offset);
        return this.startAt;
    }

    public final long getEncryptedSize() {
        return this.encryptedSize;
    }

    public final long calculateEndAt(long endAt) {
        ++endAt;
        if (this.partList.size() > 1) {
            long plaintextSize = 0L;
            int partCounter = 1;
            for (Map.Entry part : this.partList.descendingMap().entrySet()) {
                if (endAt <= (plaintextSize += ((PartPadding)part.getValue()).getSize())) break;
                ++partCounter;
            }
            endAt += 64L * (long)partCounter;
        } else {
            long rest = endAt % 16L;
            if (rest > 0L) {
                endAt += 16L;
            }
        }
        return endAt;
    }

    public final InputStream openStream(InputStream is) throws IOException {
        if (!this.isEncrypted) {
            return is;
        }
        DecryptionInputStream dis = new DecryptionInputStream(is, this.encryptionKey, this.partList, this.skipParts, this.skipPartBytes);
        long offset = this.outputOffset;
        if (this.skipFirstBlock) {
            offset += 16L;
        }
        IOUtils.skipFully((InputStream)dis, (long)offset);
        return new BoundedInputStream((InputStream)dis, this.outputLength);
    }

    private void calculateOffset(long offset) {
        this.startAt = 0L;
        this.skipParts = 0;
        if (this.partList.size() > 1) {
            long plaintextSize = 0L;
            long encryptedSize = 0L;
            long partStartAt = 0L;
            for (Map.Entry part : this.partList.descendingMap().entrySet()) {
                if (offset > (plaintextSize += ((PartPadding)part.getValue()).getSize())) {
                    encryptedSize = encryptedSize + ((PartPadding)part.getValue()).getSize() + 64L;
                    long partOffset = offset - plaintextSize;
                    this.skipFirstBlock = partOffset >= 16L;
                    this.outputOffset = partOffset % 16L;
                    ++this.skipParts;
                    if (partOffset > 16L) {
                        long rest = partOffset % 16L;
                        partStartAt = partOffset - 16L - rest;
                        continue;
                    }
                    partStartAt = 0L;
                    continue;
                }
                this.startAt = encryptedSize + partStartAt;
                this.skipPartBytes = partStartAt;
                break;
            }
        }
        if (this.skipParts == 0) {
            this.skipFirstBlock = offset >= 16L;
            this.outputOffset = offset % 16L;
            if (offset > 16L) {
                long rest = offset % 16L;
                this.startAt = offset - 16L - rest;
            }
            this.skipPartBytes = this.startAt;
        }
    }

    public final long getStartAt() {
        return this.startAt;
    }

    public final boolean isEncrypted() {
        return this.isEncrypted;
    }

    public final long getContentLength() {
        if (this.outputLength > 0L) {
            return this.outputLength;
        }
        return this.unencryptedSize;
    }
}

