/*
 * Decompiled with CFR 0.152.
 */
package org.gaul.s3proxy.crypto;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.Key;
import java.util.TreeMap;
import javax.annotation.concurrent.ThreadSafe;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.ShortBufferException;
import org.apache.commons.io.IOUtils;
import org.gaul.s3proxy.crypto.PartPadding;

@ThreadSafe
public class DecryptionInputStream
extends FilterInputStream {
    private final Cipher cipher;
    private final SecretKey key;
    private final TreeMap<Integer, PartPadding> parts;
    private final byte[] ibuffer = new byte[4096];
    private boolean done;
    private byte[] obuffer;
    private int ostart;
    private int ofinish;
    private boolean closed;
    private int part;
    private long partBytesRemain;

    public DecryptionInputStream(InputStream is, SecretKey key, TreeMap<Integer, PartPadding> parts, int skipParts, long skipPartBytes) throws IOException {
        super(is);
        this.in = is;
        this.parts = parts;
        this.key = key;
        PartPadding partPadding = parts.get(parts.size() - skipParts);
        try {
            this.cipher = Cipher.getInstance("AES/CFB/NoPadding");
            this.cipher.init(2, (Key)key, partPadding.getIv());
        }
        catch (Exception e) {
            throw new IOException(e);
        }
        this.part = parts.size() - skipParts;
        this.partBytesRemain = parts.get(this.part).getSize() - skipPartBytes;
    }

    private void ensureCapacity(int inLen) {
        int minLen = this.cipher.getOutputSize(inLen);
        if (this.obuffer == null || this.obuffer.length < minLen) {
            this.obuffer = new byte[minLen];
        }
        this.ostart = 0;
        this.ofinish = 0;
    }

    private int getMoreData() throws IOException {
        int readin;
        if (this.done) {
            return -1;
        }
        int readLimit = this.ibuffer.length;
        if (this.partBytesRemain < (long)this.ibuffer.length) {
            readLimit = (int)this.partBytesRemain;
        }
        if ((readin = this.partBytesRemain == 0L ? -1 : this.in.read(this.ibuffer, 0, readLimit)) == -1) {
            this.ensureCapacity(0);
            try {
                this.ofinish = this.cipher.doFinal(this.obuffer, 0);
            }
            catch (Exception e) {
                throw new IOException(e);
            }
            int nextPart = this.part - 1;
            if (this.parts.containsKey(nextPart)) {
                PartPadding partPadding = this.parts.get(nextPart);
                try {
                    this.cipher.init(2, (Key)this.key, partPadding.getIv());
                }
                catch (Exception e) {
                    throw new IOException(e);
                }
                this.part = nextPart;
                this.partBytesRemain = this.parts.get(nextPart).getSize();
                IOUtils.skip((InputStream)this.in, (long)64L);
                return this.ofinish;
            }
            this.done = true;
            if (this.ofinish == 0) {
                return -1;
            }
            return this.ofinish;
        }
        this.ensureCapacity(readin);
        try {
            this.ofinish = this.cipher.update(this.ibuffer, 0, readin, this.obuffer, this.ostart);
        }
        catch (ShortBufferException e) {
            throw new IOException(e);
        }
        this.partBytesRemain -= (long)readin;
        return this.ofinish;
    }

    @Override
    public final int read() throws IOException {
        if (this.ostart >= this.ofinish) {
            int i = 0;
            while (i == 0) {
                i = this.getMoreData();
            }
            if (i == -1) {
                return -1;
            }
        }
        return this.obuffer[this.ostart++] & 0xFF;
    }

    @Override
    public final int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    @Override
    public final int read(byte[] b, int off, int len) throws IOException {
        if (this.ostart >= this.ofinish) {
            int i = 0;
            while (i == 0) {
                i = this.getMoreData();
            }
            if (i == -1) {
                return -1;
            }
        }
        if (len <= 0) {
            return 0;
        }
        int available = this.ofinish - this.ostart;
        if (len < available) {
            available = len;
        }
        if (b != null) {
            System.arraycopy(this.obuffer, this.ostart, b, off, available);
        }
        this.ostart += available;
        return available;
    }

    @Override
    public final long skip(long n) throws IOException {
        int available = this.ofinish - this.ostart;
        if (n > (long)available) {
            n = available;
        }
        if (n < 0L) {
            return 0L;
        }
        this.ostart = (int)((long)this.ostart + n);
        return n;
    }

    @Override
    public final int available() {
        return this.ofinish - this.ostart;
    }

    @Override
    public final void close() throws IOException {
        if (this.closed) {
            return;
        }
        this.closed = true;
        this.in.close();
        if (!this.done) {
            this.ensureCapacity(0);
            try {
                this.cipher.doFinal(this.obuffer, 0);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.obuffer = null;
    }

    @Override
    public final boolean markSupported() {
        return false;
    }
}

