/*
 * Decompiled with CFR 0.152.
 */
package org.gaul.s3proxy.crypto;

import java.io.IOException;
import java.io.InputStream;
import java.security.Key;
import java.security.SecureRandom;
import javax.annotation.concurrent.ThreadSafe;
import javax.crypto.Cipher;
import javax.crypto.CipherInputStream;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.gaul.s3proxy.crypto.EncryptionInputStream;

@ThreadSafe
public class Encryption {
    private final InputStream cis;
    private final IvParameterSpec iv = this.generateIV();
    private final int part;

    public Encryption(SecretKeySpec key, InputStream isRaw, int partNumber) throws Exception {
        Cipher cipher = Cipher.getInstance("AES/CFB/NoPadding");
        cipher.init(1, (Key)key, this.iv);
        this.cis = new CipherInputStream(isRaw, cipher);
        this.part = partNumber;
    }

    public final InputStream openStream() throws IOException {
        return new EncryptionInputStream(this.cis, this.part, this.iv);
    }

    private IvParameterSpec generateIV() {
        byte[] iv = new byte[16];
        SecureRandom randomSecureRandom = new SecureRandom();
        randomSecureRandom.nextBytes(iv);
        return new IvParameterSpec(iv);
    }
}

