/*
 * Decompiled with CFR 0.152.
 */
package org.gaul.s3proxy.crypto;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import javax.crypto.spec.IvParameterSpec;
import org.gaul.s3proxy.crypto.Constants;

public class EncryptionInputStream
extends InputStream {
    private final int part;
    private final IvParameterSpec iv;
    private boolean hasPadding;
    private long size;
    private InputStream in;

    public EncryptionInputStream(InputStream in, int part, IvParameterSpec iv) {
        this.part = part;
        this.iv = iv;
        this.in = in;
    }

    final void padding() throws IOException {
        if (this.in != null) {
            this.in.close();
        }
        if (!this.hasPadding) {
            ByteBuffer bb = ByteBuffer.allocate(64);
            bb.put(Constants.DELIMITER);
            bb.put(this.iv.getIV());
            bb.putInt(this.part);
            bb.putLong(this.size);
            bb.putShort((short)1);
            this.in = new ByteArrayInputStream(bb.array());
            this.hasPadding = true;
        } else {
            this.in = null;
        }
    }

    @Override
    public final int available() throws IOException {
        if (this.in == null) {
            return 0;
        }
        return this.in.available();
    }

    @Override
    public final int read() throws IOException {
        while (this.in != null) {
            int c = this.in.read();
            if (c != -1) {
                ++this.size;
                return c;
            }
            this.padding();
        }
        return -1;
    }

    @Override
    public final int read(byte[] b, int off, int len) throws IOException {
        if (this.in == null) {
            return -1;
        }
        if (b == null) {
            throw new NullPointerException();
        }
        if (off < 0 || len < 0 || len > b.length - off) {
            throw new IndexOutOfBoundsException();
        }
        if (len == 0) {
            return 0;
        }
        do {
            int n;
            if ((n = this.in.read(b, off, len)) > 0) {
                this.size += (long)n;
                return n;
            }
            this.padding();
        } while (this.in != null);
        return -1;
    }

    @Override
    public final void close() throws IOException {
        IOException ioe = null;
        while (this.in != null) {
            try {
                this.in.close();
            }
            catch (IOException e) {
                if (ioe == null) {
                    ioe = e;
                }
                ioe.addSuppressed(e);
            }
            this.padding();
        }
        if (ioe != null) {
            throw ioe;
        }
    }
}

