/*
 * Decompiled with CFR 0.152.
 */
package org.gaul.s3proxy.junit;

import java.net.URI;
import org.gaul.s3proxy.AuthenticationType;
import org.gaul.s3proxy.junit.S3ProxyJunitCore;
import org.junit.jupiter.api.extension.AfterEachCallback;
import org.junit.jupiter.api.extension.BeforeEachCallback;
import org.junit.jupiter.api.extension.ExtensionContext;

public final class S3ProxyExtension
implements AfterEachCallback,
BeforeEachCallback {
    private final S3ProxyJunitCore core;

    private S3ProxyExtension(Builder builder) {
        this.core = new S3ProxyJunitCore(builder.builder);
    }

    public static Builder builder() {
        return new Builder();
    }

    public void beforeEach(ExtensionContext extensionContext) throws Exception {
        this.core.beforeEach();
    }

    public void afterEach(ExtensionContext extensionContext) {
        this.core.afterEach();
    }

    public URI getUri() {
        return this.core.getUri();
    }

    public String getAccessKey() {
        return this.core.getAccessKey();
    }

    public String getSecretKey() {
        return this.core.getSecretKey();
    }

    public static final class Builder {
        private final S3ProxyJunitCore.Builder builder = new S3ProxyJunitCore.Builder();

        private Builder() {
        }

        public Builder withCredentials(AuthenticationType authType, String accessKey, String secretKey) {
            this.builder.withCredentials(authType, accessKey, secretKey);
            return this;
        }

        public Builder withCredentials(String accessKey, String secretKey) {
            this.builder.withCredentials(accessKey, secretKey);
            return this;
        }

        public Builder withSecretStore(String path, String password) {
            this.builder.withSecretStore(path, password);
            return this;
        }

        public Builder withPort(int port) {
            this.builder.withPort(port);
            return this;
        }

        public Builder withBlobStoreProvider(String blobStoreProvider) {
            this.builder.withBlobStoreProvider(blobStoreProvider);
            return this;
        }

        public Builder ignoreUnknownHeaders() {
            this.builder.ignoreUnknownHeaders();
            return this;
        }

        public S3ProxyExtension build() {
            return new S3ProxyExtension(this);
        }
    }
}

