/*
 * Decompiled with CFR 0.152.
 */
package org.gaul.s3proxy.junit;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.Properties;
import org.apache.commons.io.FileUtils;
import org.gaul.s3proxy.AuthenticationType;
import org.gaul.s3proxy.S3Proxy;
import org.jclouds.ContextBuilder;
import org.jclouds.blobstore.BlobStore;
import org.jclouds.blobstore.BlobStoreContext;
import org.jclouds.blobstore.domain.StorageMetadata;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class S3ProxyJunitCore {
    private static final Logger logger = LoggerFactory.getLogger(S3ProxyJunitCore.class);
    private static final String LOCALHOST = "127.0.0.1";
    private final String accessKey;
    private final String secretKey;
    private final String endpointFormat;
    private final S3Proxy s3Proxy;
    private final BlobStoreContext blobStoreContext;
    private URI endpointUri;
    private final File blobStoreLocation;

    S3ProxyJunitCore(Builder builder) {
        this.accessKey = builder.accessKey;
        this.secretKey = builder.secretKey;
        Properties properties = new Properties();
        try {
            this.blobStoreLocation = Files.createTempDirectory("S3Proxy", new FileAttribute[0]).toFile();
            properties.setProperty("jclouds.filesystem.basedir", this.blobStoreLocation.getCanonicalPath());
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to initialize Blob Store", e);
        }
        ContextBuilder blobStoreContextBuilder = ContextBuilder.newBuilder((String)builder.blobStoreProvider).overrides(properties);
        if (!AuthenticationType.NONE.equals((Object)builder.authType)) {
            blobStoreContextBuilder = blobStoreContextBuilder.credentials(this.accessKey, this.secretKey);
        }
        this.blobStoreContext = (BlobStoreContext)blobStoreContextBuilder.build(BlobStoreContext.class);
        S3Proxy.Builder s3ProxyBuilder = S3Proxy.builder().blobStore(this.blobStoreContext.getBlobStore()).awsAuthentication(builder.authType, this.accessKey, this.secretKey).ignoreUnknownHeaders(builder.ignoreUnknownHeaders);
        if (builder.secretStorePath != null || builder.secretStorePassword != null) {
            s3ProxyBuilder.keyStore(builder.secretStorePath, builder.secretStorePassword);
        }
        int port = Math.max(builder.port, 0);
        this.endpointFormat = "http://%s:%d";
        String endpoint = String.format(this.endpointFormat, LOCALHOST, port);
        s3ProxyBuilder.endpoint(URI.create(endpoint));
        this.s3Proxy = s3ProxyBuilder.build();
    }

    public final void beforeEach() throws Exception {
        logger.debug("S3 proxy is starting");
        this.s3Proxy.start();
        while (!this.s3Proxy.getState().equals("STARTED")) {
            Thread.sleep(10L);
        }
        this.endpointUri = URI.create(String.format(this.endpointFormat, LOCALHOST, this.s3Proxy.getPort()));
        logger.debug("S3 proxy is running");
    }

    public final void afterEach() {
        logger.debug("S3 proxy is stopping");
        try {
            this.s3Proxy.stop();
            BlobStore blobStore = this.blobStoreContext.getBlobStore();
            for (StorageMetadata metadata : blobStore.list()) {
                blobStore.deleteContainer(metadata.getName());
            }
            this.blobStoreContext.close();
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to stop S3 proxy", e);
        }
        FileUtils.deleteQuietly((File)this.blobStoreLocation);
        logger.debug("S3 proxy has stopped");
    }

    public final URI getUri() {
        return this.endpointUri;
    }

    public final String getAccessKey() {
        return this.accessKey;
    }

    public final String getSecretKey() {
        return this.secretKey;
    }

    public static final class Builder {
        private AuthenticationType authType = AuthenticationType.NONE;
        private String accessKey;
        private String secretKey;
        private String secretStorePath;
        private String secretStorePassword;
        private int port = -1;
        private boolean ignoreUnknownHeaders;
        private String blobStoreProvider = "filesystem";

        public Builder withCredentials(AuthenticationType authType, String accessKey, String secretKey) {
            this.authType = authType;
            this.accessKey = accessKey;
            this.secretKey = secretKey;
            return this;
        }

        public Builder withCredentials(String accessKey, String secretKey) {
            return this.withCredentials(AuthenticationType.AWS_V2_OR_V4, accessKey, secretKey);
        }

        public Builder withSecretStore(String path, String password) {
            this.secretStorePath = path;
            this.secretStorePassword = password;
            return this;
        }

        public Builder withPort(int port) {
            this.port = port;
            return this;
        }

        public Builder withBlobStoreProvider(String blobStoreProvider) {
            this.blobStoreProvider = blobStoreProvider;
            return this;
        }

        public Builder ignoreUnknownHeaders() {
            this.ignoreUnknownHeaders = true;
            return this;
        }

        public S3ProxyJunitCore build() {
            return new S3ProxyJunitCore(this);
        }
    }
}

