/*
 * Decompiled with CFR 0.152.
 */
package org.gaul.s3proxy;

import com.google.common.io.ByteStreams;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

final class ChunkedInputStream
extends FilterInputStream {
    private byte[] chunk;
    private int currentIndex;
    private int currentLength;
    @SuppressFBWarnings(value={"URF_UNREAD_FIELD"}, justification="https://github.com/gaul/s3proxy/issues/205")
    private String currentSignature;

    ChunkedInputStream(InputStream is) {
        super(is);
    }

    @Override
    public int read() throws IOException {
        while (this.currentIndex == this.currentLength) {
            String line = ChunkedInputStream.readLine(this.in);
            if (line.equals("")) {
                return -1;
            }
            String[] parts = line.split(";", 2);
            this.currentLength = Integer.parseInt(parts[0], 16);
            this.currentSignature = parts[1];
            this.chunk = new byte[this.currentLength];
            this.currentIndex = 0;
            ByteStreams.readFully((InputStream)this.in, (byte[])this.chunk);
            if (this.currentLength == 0) {
                return -1;
            }
            ChunkedInputStream.readLine(this.in);
        }
        return this.chunk[this.currentIndex++] & 0xFF;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int ch;
        int i;
        for (i = 0; i < len && (ch = this.read()) != -1; ++i) {
            b[off + i] = (byte)ch;
        }
        if (i == 0) {
            return -1;
        }
        return i;
    }

    private static String readLine(InputStream is) throws IOException {
        StringBuilder builder = new StringBuilder();
        while (true) {
            int ch;
            if ((ch = is.read()) == 13) {
                ch = is.read();
                if (ch == 10) break;
                throw new IOException("unexpected char after \\r: " + ch);
            }
            if (ch == -1) {
                if (builder.length() <= 0) break;
                throw new IOException("unexpected end of stream");
            }
            builder.append((char)ch);
        }
        return builder.toString();
    }
}

