/*
 * Decompiled with CFR 0.152.
 */
package org.gaul.s3proxy;

import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CrossOriginResourceSharing {
    protected static final List<String> SUPPORTED_METHODS = List.of("GET", "HEAD", "PUT", "POST", "DELETE");
    private static final String HEADER_VALUE_SEPARATOR = ", ";
    private static final String ALLOW_ANY_ORIGIN = "*";
    private static final String ALLOW_ANY_HEADER = "*";
    private static final String EXPOSE_ALL_HEADERS = "*";
    private static final String ALLOW_CREDENTIALS = "true";
    private static final Logger logger = LoggerFactory.getLogger(CrossOriginResourceSharing.class);
    private final String allowedMethodsRaw;
    private final String allowedHeadersRaw;
    private final String exposedHeadersRaw;
    private final boolean anyOriginAllowed;
    private final List<Pattern> allowedOrigins;
    private final List<String> allowedMethods;
    private final List<String> allowedHeaders;
    private final List<String> exposedHeaders;
    private final String allowCredentials;

    public CrossOriginResourceSharing() {
        this(List.of("*"), SUPPORTED_METHODS, List.of("*"), List.of("*"), "");
    }

    public CrossOriginResourceSharing(List<String> allowedOrigins, List<String> allowedMethods, List<String> allowedHeaders, List<String> exposedHeaders, String allowCredentials) {
        HashSet<Pattern> allowedPattern = new HashSet<Pattern>();
        boolean anyOriginAllowed = false;
        if (allowedOrigins != null) {
            if (allowedOrigins.contains("*")) {
                anyOriginAllowed = true;
            } else {
                for (String origin : allowedOrigins) {
                    allowedPattern.add(Pattern.compile(origin, 2));
                }
            }
        }
        this.anyOriginAllowed = anyOriginAllowed;
        this.allowedOrigins = List.copyOf(allowedPattern);
        this.allowedMethods = allowedMethods == null ? List.of() : List.copyOf(allowedMethods);
        this.allowedMethodsRaw = Joiner.on((String)HEADER_VALUE_SEPARATOR).join(this.allowedMethods);
        this.allowedHeaders = allowedHeaders == null ? List.of() : List.copyOf(allowedHeaders);
        this.allowedHeadersRaw = Joiner.on((String)HEADER_VALUE_SEPARATOR).join(this.allowedHeaders);
        this.exposedHeaders = exposedHeaders == null ? List.of() : List.copyOf(exposedHeaders);
        this.exposedHeadersRaw = Joiner.on((String)HEADER_VALUE_SEPARATOR).join(this.exposedHeaders);
        this.allowCredentials = allowCredentials;
        logger.info("CORS allowed origins: {}", allowedOrigins);
        logger.info("CORS allowed methods: {}", allowedMethods);
        logger.info("CORS allowed headers: {}", allowedHeaders);
        logger.info("CORS exposed headers: {}", exposedHeaders);
        logger.info("CORS allow credentials: {}", (Object)allowCredentials);
    }

    public String getAllowedMethods() {
        return this.allowedMethodsRaw;
    }

    public String getExposedHeaders() {
        return this.exposedHeadersRaw;
    }

    public String getAllowedOrigin(String origin) {
        if (this.anyOriginAllowed) {
            return "*";
        }
        return origin;
    }

    public boolean isOriginAllowed(String origin) {
        if (!Strings.isNullOrEmpty((String)origin)) {
            if (this.anyOriginAllowed) {
                logger.debug("CORS origin allowed: {}", (Object)origin);
                return true;
            }
            for (Pattern pattern : this.allowedOrigins) {
                Matcher matcher = pattern.matcher(origin);
                if (!matcher.matches()) continue;
                logger.debug("CORS origin allowed: {}", (Object)origin);
                return true;
            }
        }
        logger.debug("CORS origin not allowed: {}", (Object)origin);
        return false;
    }

    public boolean isMethodAllowed(String method) {
        if (!Strings.isNullOrEmpty((String)method) && this.allowedMethods.contains(method)) {
            logger.debug("CORS method allowed: {}", (Object)method);
            return true;
        }
        logger.debug("CORS method not allowed: {}", (Object)method);
        return false;
    }

    public boolean isEveryHeaderAllowed(String headers) {
        boolean result = false;
        if (!Strings.isNullOrEmpty((String)headers)) {
            if (this.allowedHeadersRaw.equals("*")) {
                result = true;
            } else {
                String header;
                Iterator iterator = Splitter.on((String)HEADER_VALUE_SEPARATOR).split((CharSequence)headers).iterator();
                while (iterator.hasNext() && (result = this.allowedHeaders.contains(header = (String)iterator.next()))) {
                }
            }
        }
        if (result) {
            logger.debug("CORS headers allowed: {}", (Object)headers);
        } else {
            logger.debug("CORS headers not allowed: {}", (Object)headers);
        }
        return result;
    }

    public boolean isAllowCredentials() {
        return ALLOW_CREDENTIALS.equals(this.allowCredentials);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || !(object instanceof CrossOriginResourceSharing)) {
            return false;
        }
        CrossOriginResourceSharing that = (CrossOriginResourceSharing)object;
        return this.allowedOrigins.equals(that.allowedOrigins) && this.allowedMethodsRaw.equals(that.allowedMethodsRaw) && this.allowedHeadersRaw.equals(that.allowedHeadersRaw);
    }

    public int hashCode() {
        return Objects.hash(this.allowedOrigins, this.allowedMethodsRaw, this.allowedHeadersRaw);
    }
}

