/*
 * Decompiled with CFR 0.152.
 */
package org.gaul.s3proxy;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableSet;
import com.google.common.hash.HashCode;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Matcher;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.codec.digest.DigestUtils;
import org.gaul.s3proxy.Quirks;
import org.gaul.s3proxy.crypto.Constants;
import org.gaul.s3proxy.crypto.Decryption;
import org.gaul.s3proxy.crypto.Encryption;
import org.jclouds.blobstore.BlobStore;
import org.jclouds.blobstore.domain.Blob;
import org.jclouds.blobstore.domain.BlobAccess;
import org.jclouds.blobstore.domain.BlobBuilder;
import org.jclouds.blobstore.domain.BlobMetadata;
import org.jclouds.blobstore.domain.MultipartPart;
import org.jclouds.blobstore.domain.MultipartUpload;
import org.jclouds.blobstore.domain.MutableBlobMetadata;
import org.jclouds.blobstore.domain.PageSet;
import org.jclouds.blobstore.domain.StorageMetadata;
import org.jclouds.blobstore.domain.internal.MutableBlobMetadataImpl;
import org.jclouds.blobstore.domain.internal.PageSetImpl;
import org.jclouds.blobstore.options.CopyOptions;
import org.jclouds.blobstore.options.GetOptions;
import org.jclouds.blobstore.options.ListContainerOptions;
import org.jclouds.blobstore.options.PutOptions;
import org.jclouds.blobstore.util.ForwardingBlobStore;
import org.jclouds.io.MutableContentMetadata;
import org.jclouds.io.Payload;
import org.jclouds.io.Payloads;
import org.jclouds.io.payloads.InputStreamPayload;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class EncryptedBlobStore
extends ForwardingBlobStore {
    private final Logger logger = LoggerFactory.getLogger(EncryptedBlobStore.class);
    private SecretKeySpec secretKey;

    private EncryptedBlobStore(BlobStore blobStore, Properties properties) throws IllegalArgumentException {
        super(blobStore);
        String password = properties.getProperty("s3proxy.encrypted-blobstore-password");
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)password) ? 1 : 0) != 0, (Object)"Password for encrypted blobstore is not set");
        String salt = properties.getProperty("s3proxy.encrypted-blobstore-salt");
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)salt) ? 1 : 0) != 0, (Object)"Salt for encrypted blobstore is not set");
        this.initStore(password, salt);
    }

    static BlobStore newEncryptedBlobStore(BlobStore blobStore, Properties properties) throws IOException {
        return new EncryptedBlobStore(blobStore, properties);
    }

    private void initStore(String password, String salt) throws IllegalArgumentException {
        try {
            SecretKeyFactory factory = SecretKeyFactory.getInstance("PBKDF2WithHmacSHA256");
            PBEKeySpec spec = new PBEKeySpec(password.toCharArray(), salt.getBytes(), 65536, 128);
            SecretKey tmp = factory.generateSecret(spec);
            this.secretKey = new SecretKeySpec(tmp.getEncoded(), "AES");
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e);
        }
    }

    private Blob cipheredBlob(String container, Blob blob, InputStream payload, long contentLength, boolean addEncryptedMetadata) {
        MutableBlobMetadata blobMeta = blob.getMetadata();
        MutableContentMetadata contentMeta = blob.getMetadata().getContentMetadata();
        Map userMetadata = blobMeta.getUserMetadata();
        String contentType = contentMeta.getContentType();
        if (addEncryptedMetadata) {
            blobMeta = this.setEncryptedSuffix((BlobMetadata)blobMeta);
        } else if (!blobMeta.getUserMetadata().containsKey("s3proxy_encryption_multipart")) {
            blobMeta = this.removeEncryptedSuffix((BlobMetadata)blobMeta);
        }
        Blob cipheredBlob = this.blobBuilder(container).name(blobMeta.getName()).type(blobMeta.getType()).tier(blobMeta.getTier()).userMetadata(userMetadata).payload(payload).cacheControl(contentMeta.getCacheControl()).contentDisposition(contentMeta.getContentDisposition()).contentEncoding(contentMeta.getContentEncoding()).contentLanguage(contentMeta.getContentLanguage()).contentLength(contentLength).contentType(contentType).build();
        cipheredBlob.getMetadata().setUri(blobMeta.getUri());
        cipheredBlob.getMetadata().setETag(blobMeta.getETag());
        cipheredBlob.getMetadata().setLastModified(blobMeta.getLastModified());
        cipheredBlob.getMetadata().setSize(blobMeta.getSize());
        cipheredBlob.getMetadata().setPublicUri(blobMeta.getPublicUri());
        cipheredBlob.getMetadata().setContainer(blobMeta.getContainer());
        return cipheredBlob;
    }

    private Blob encryptBlob(String container, Blob blob) {
        try {
            InputStream isRaw = blob.getPayload().openStream();
            Encryption encryption = new Encryption(this.secretKey, isRaw, 1);
            InputStream is = encryption.openStream();
            long contentLength = blob.getMetadata().getContentMetadata().getContentLength() + 64L;
            return this.cipheredBlob(container, blob, is, contentLength, true);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private Payload encryptPayload(Payload payload, int partNumber) {
        try {
            InputStream isRaw = payload.openStream();
            Encryption encryption = new Encryption(this.secretKey, isRaw, partNumber);
            InputStream is = encryption.openStream();
            InputStreamPayload cipheredPayload = Payloads.newInputStreamPayload((InputStream)is);
            MutableContentMetadata contentMetadata = payload.getContentMetadata();
            HashCode md5 = null;
            contentMetadata.setContentMD5(md5);
            cipheredPayload.setContentMetadata(payload.getContentMetadata());
            cipheredPayload.setSensitive(payload.isSensitive());
            long contentLength = payload.getContentMetadata().getContentLength() + 64L;
            cipheredPayload.getContentMetadata().setContentLength(Long.valueOf(contentLength));
            return cipheredPayload;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private Blob decryptBlob(Decryption decryption, String container, Blob blob) {
        try {
            if (blob == null) {
                return null;
            }
            InputStream isRaw = blob.getPayload().openStream();
            InputStream is = decryption.openStream(isRaw);
            long contentLength = blob.getMetadata().getContentMetadata().getContentLength();
            if (decryption.isEncrypted()) {
                contentLength = decryption.getContentLength();
            }
            return this.cipheredBlob(container, blob, is, contentLength, false);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private PageSet<? extends StorageMetadata> filteredList(PageSet<? extends StorageMetadata> pageSet) {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        for (StorageMetadata sm : pageSet) {
            if (sm instanceof BlobMetadata) {
                MutableBlobMetadataImpl mbm = new MutableBlobMetadataImpl((BlobMetadata)sm);
                if (this.isEncrypted((BlobMetadata)mbm)) {
                    mbm = this.removeEncryptedSuffix((BlobMetadata)sm);
                    mbm = this.calculateBlobSize((BlobMetadata)mbm);
                }
                builder.add((Object)mbm);
                continue;
            }
            builder.add((Object)sm);
        }
        String marker = pageSet.getNextMarker();
        if (marker != null && this.isEncrypted(marker)) {
            marker = this.removeEncryptedSuffix(marker);
        }
        return new PageSetImpl((Iterable)builder.build(), marker);
    }

    private boolean isEncrypted(BlobMetadata blobMeta) {
        return this.isEncrypted(blobMeta.getName());
    }

    private boolean isEncrypted(String blobName) {
        return blobName.endsWith(".s3enc");
    }

    private MutableBlobMetadata setEncryptedSuffix(BlobMetadata blobMeta) {
        MutableBlobMetadataImpl bm = new MutableBlobMetadataImpl(blobMeta);
        if (blobMeta.getName() != null && !this.isEncrypted(blobMeta.getName())) {
            bm.setName(this.blobNameWithSuffix(blobMeta.getName()));
        }
        return bm;
    }

    private String removeEncryptedSuffix(String blobName) {
        return blobName.substring(0, blobName.length() - ".s3enc".length());
    }

    private MutableBlobMetadata removeEncryptedSuffix(BlobMetadata blobMeta) {
        MutableBlobMetadataImpl bm = new MutableBlobMetadataImpl(blobMeta);
        if (this.isEncrypted(bm.getName())) {
            String blobName = bm.getName();
            bm.setName(this.removeEncryptedSuffix(blobName));
        }
        return bm;
    }

    private MutableBlobMetadata calculateBlobSize(BlobMetadata blobMeta) {
        MutableBlobMetadata mbm = this.removeEncryptedSuffix(blobMeta);
        if (mbm.getUserMetadata().containsKey("s3proxy_encryption_parts")) {
            int parts = Integer.parseInt((String)mbm.getUserMetadata().get("s3proxy_encryption_parts"));
            int partPaddingSizes = 64 * parts;
            long size = blobMeta.getSize() - (long)partPaddingSizes;
            mbm.setSize(Long.valueOf(size));
            mbm.getContentMetadata().setContentLength(Long.valueOf(size));
        } else {
            Matcher matcher = Constants.MPU_ETAG_SUFFIX_PATTERN.matcher(blobMeta.getETag());
            if (matcher.find()) {
                int parts = Integer.parseInt(matcher.group(1));
                int partPaddingSizes = 64 * parts;
                long size = blobMeta.getSize() - (long)partPaddingSizes;
                mbm.setSize(Long.valueOf(size));
                mbm.getContentMetadata().setContentLength(Long.valueOf(size));
            } else {
                long size = blobMeta.getSize() - 64L;
                mbm.setSize(Long.valueOf(size));
                mbm.getContentMetadata().setContentLength(Long.valueOf(size));
            }
        }
        return mbm;
    }

    private boolean multipartRequiresStub() {
        String blobStoreType = this.getBlobStoreType();
        return Quirks.MULTIPART_REQUIRES_STUB.contains(blobStoreType);
    }

    private String blobNameWithSuffix(String container, String name) {
        String nameWithSuffix = this.blobNameWithSuffix(name);
        if (this.delegate().blobExists(container, nameWithSuffix)) {
            name = nameWithSuffix;
        }
        return name;
    }

    private String blobNameWithSuffix(String name) {
        return name + ".s3enc";
    }

    private String getBlobStoreType() {
        return this.delegate().getContext().unwrap().getProviderMetadata().getId();
    }

    private String generateUploadId(String container, String blobName) {
        String path = container + "/" + blobName;
        return DigestUtils.sha256Hex((String)path);
    }

    public Blob getBlob(String containerName, String blobName) {
        return this.getBlob(containerName, blobName, new GetOptions());
    }

    public Blob getBlob(String containerName, String blobName, GetOptions getOptions) {
        blobName = this.blobNameWithSuffix(blobName);
        BlobMetadata meta = this.delegate().blobMetadata(containerName, blobName);
        try {
            if (meta != null) {
                Decryption decryption;
                long offset = 0L;
                long end = 0L;
                long length = -1L;
                if (getOptions.getRanges().size() > 0) {
                    String range = (String)getOptions.getRanges().get(0);
                    String[] ranges = range.split("-", 2);
                    if (ranges[0].isEmpty()) {
                        length = end = Long.parseLong(ranges[1]);
                    } else if (ranges[1].isEmpty()) {
                        offset = Long.parseLong(ranges[0]);
                    } else {
                        offset = Long.parseLong(ranges[0]);
                        end = Long.parseLong(ranges[1]);
                        length = end - offset + 1L;
                    }
                }
                if ((decryption = new Decryption(this.secretKey, this.delegate(), meta, offset, length)).isEncrypted() && getOptions.getRanges().size() > 0) {
                    getOptions.getRanges().clear();
                    long startAt = decryption.getStartAt();
                    long endAt = decryption.getEncryptedSize();
                    if (offset == 0L && end > 0L && length == end) {
                        startAt = decryption.calculateTail();
                    } else if (offset > 0L && end > 0L) {
                        endAt = decryption.calculateEndAt(end);
                    }
                    getOptions.range(startAt, endAt);
                }
                Blob blob = this.delegate().getBlob(containerName, blobName, getOptions);
                return this.decryptBlob(decryption, containerName, blob);
            }
            blobName = this.removeEncryptedSuffix(blobName);
            return this.delegate().getBlob(containerName, blobName, getOptions);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public String putBlob(String containerName, Blob blob) {
        return this.delegate().putBlob(containerName, this.encryptBlob(containerName, blob));
    }

    public String putBlob(String containerName, Blob blob, PutOptions putOptions) {
        return this.delegate().putBlob(containerName, this.encryptBlob(containerName, blob), putOptions);
    }

    public String copyBlob(String fromContainer, String fromName, String toContainer, String toName, CopyOptions options) {
        String blobName = this.blobNameWithSuffix(fromName);
        if (this.delegate().blobExists(fromContainer, blobName)) {
            fromName = blobName;
            toName = this.blobNameWithSuffix(toName);
        }
        return this.delegate().copyBlob(fromContainer, fromName, toContainer, toName, options);
    }

    public void removeBlob(String container, String name) {
        name = this.blobNameWithSuffix(container, name);
        this.delegate().removeBlob(container, name);
    }

    public void removeBlobs(String container, Iterable<String> names) {
        ArrayList<String> filteredNames = new ArrayList<String>();
        for (String name : names) {
            name = this.blobNameWithSuffix(container, name);
            filteredNames.add(name);
        }
        this.delegate().removeBlobs(container, filteredNames);
    }

    public BlobAccess getBlobAccess(String container, String name) {
        name = this.blobNameWithSuffix(container, name);
        return this.delegate().getBlobAccess(container, name);
    }

    public boolean blobExists(String container, String name) {
        name = this.blobNameWithSuffix(container, name);
        return this.delegate().blobExists(container, name);
    }

    public void setBlobAccess(String container, String name, BlobAccess access) {
        name = this.blobNameWithSuffix(container, name);
        this.delegate().setBlobAccess(container, name, access);
    }

    public PageSet<? extends StorageMetadata> list() {
        PageSet pageSet = this.delegate().list();
        return this.filteredList((PageSet<? extends StorageMetadata>)pageSet);
    }

    public PageSet<? extends StorageMetadata> list(String container) {
        PageSet pageSet = this.delegate().list(container);
        return this.filteredList((PageSet<? extends StorageMetadata>)pageSet);
    }

    public PageSet<? extends StorageMetadata> list(String container, ListContainerOptions options) {
        PageSet pageSet = this.delegate().list(container, options);
        return this.filteredList((PageSet<? extends StorageMetadata>)pageSet);
    }

    public MultipartUpload initiateMultipartUpload(String container, BlobMetadata blobMetadata, PutOptions options) {
        MutableBlobMetadataImpl mbm = new MutableBlobMetadataImpl(blobMetadata);
        mbm = this.setEncryptedSuffix((BlobMetadata)mbm);
        MultipartUpload mpu = this.delegate().initiateMultipartUpload(container, (BlobMetadata)mbm, options);
        if (this.multipartRequiresStub()) {
            mbm.getUserMetadata().put("s3proxy_encryption_multipart", "true");
            if (this.getBlobStoreType().equals("azureblob")) {
                this.delegate().uploadMultipartPart(mpu, 0, (Payload)Payloads.newStringPayload((String)"dummy"));
                String uploadId = this.generateUploadId(container, mbm.getName());
                mpu = MultipartUpload.create((String)mpu.containerName(), (String)mpu.blobName(), (String)uploadId, (BlobMetadata)mpu.blobMetadata(), (PutOptions)options);
            } else if (this.getBlobStoreType().equals("google-cloud-storage")) {
                mbm.getUserMetadata().put("s3proxy_mpu_key", mbm.getName());
                String uploadId = this.generateUploadId(container, mbm.getName());
                BlobBuilder builder = this.blobBuilder(".mpu/" + uploadId).payload("").userMetadata(mbm.getUserMetadata());
                this.delegate().putBlob(container, builder.build(), options);
                mpu = MultipartUpload.create((String)mpu.containerName(), (String)mpu.blobName(), (String)uploadId, (BlobMetadata)mpu.blobMetadata(), (PutOptions)options);
            }
        }
        return mpu;
    }

    public List<MultipartUpload> listMultipartUploads(String container) {
        List<MultipartUpload> mpus = new ArrayList();
        if (this.getBlobStoreType().equals("google-cloud-storage")) {
            ListContainerOptions options = new ListContainerOptions();
            PageSet mpuList = this.delegate().list(container, options.prefix(".mpu/"));
            for (StorageMetadata blob : mpuList) {
                Map meta = blob.getUserMetadata();
                if (!meta.containsKey("s3proxy_mpu_key")) continue;
                String blobName = (String)meta.get("s3proxy_mpu_key");
                String uploadId = blob.getName().substring(blob.getName().lastIndexOf("/") + 1);
                MultipartUpload mpu = MultipartUpload.create((String)container, (String)blobName, (String)uploadId, null, null);
                mpus.add(mpu);
            }
        } else {
            mpus = this.delegate().listMultipartUploads(container);
        }
        ArrayList<MultipartUpload> filtered = new ArrayList<MultipartUpload>();
        for (MultipartUpload mpu : mpus) {
            String blobName = mpu.blobName();
            if (this.isEncrypted(blobName)) {
                blobName = this.removeEncryptedSuffix(mpu.blobName());
                String uploadId = mpu.id();
                if (this.getBlobStoreType().equals("azureblob")) {
                    uploadId = this.generateUploadId(container, mpu.blobName());
                }
                MultipartUpload mpuWithoutSuffix = MultipartUpload.create((String)mpu.containerName(), (String)blobName, (String)uploadId, (BlobMetadata)mpu.blobMetadata(), (PutOptions)mpu.putOptions());
                filtered.add(mpuWithoutSuffix);
                continue;
            }
            filtered.add(mpu);
        }
        return filtered;
    }

    public List<MultipartPart> listMultipartUpload(MultipartUpload mpu) {
        mpu = this.filterMultipartUpload(mpu);
        List parts = this.delegate().listMultipartUpload(mpu);
        ArrayList<MultipartPart> filteredParts = new ArrayList<MultipartPart>();
        for (MultipartPart part : parts) {
            if (this.getBlobStoreType().equals("azureblob") && part.partNumber() == 0) continue;
            MultipartPart newPart = MultipartPart.create((int)part.partNumber(), (long)(part.partSize() - 64L), (String)part.partETag(), (Date)part.lastModified());
            filteredParts.add(newPart);
        }
        return filteredParts;
    }

    public MultipartPart uploadMultipartPart(MultipartUpload mpu, int partNumber, Payload payload) {
        mpu = this.filterMultipartUpload(mpu);
        return this.delegate().uploadMultipartPart(mpu, partNumber, this.encryptPayload(payload, partNumber));
    }

    private MultipartUpload filterMultipartUpload(MultipartUpload mpu) {
        String blobName;
        MutableBlobMetadataImpl mbm = null;
        if (mpu.blobMetadata() != null) {
            mbm = new MutableBlobMetadataImpl(mpu.blobMetadata());
            mbm = this.setEncryptedSuffix((BlobMetadata)mbm);
        }
        if (!this.isEncrypted(blobName = mpu.blobName())) {
            blobName = this.blobNameWithSuffix(blobName);
        }
        return MultipartUpload.create((String)mpu.containerName(), (String)blobName, (String)mpu.id(), (BlobMetadata)mbm, (PutOptions)mpu.putOptions());
    }

    public String completeMultipartUpload(MultipartUpload mpu, List<MultipartPart> parts) {
        MutableBlobMetadataImpl mbm = new MutableBlobMetadataImpl(mpu.blobMetadata());
        String blobName = mpu.blobName();
        if (this.getBlobStoreType().equals("google-cloud-storage") && mpu.blobName().startsWith(mpu.id())) {
            this.logger.debug("skip suffix on gcp");
        } else {
            mbm = this.setEncryptedSuffix((BlobMetadata)mbm);
            if (!this.isEncrypted(mpu.blobName())) {
                blobName = this.blobNameWithSuffix(blobName);
            }
        }
        MultipartUpload mpuWithSuffix = MultipartUpload.create((String)mpu.containerName(), (String)blobName, (String)mpu.id(), (BlobMetadata)mbm, (PutOptions)mpu.putOptions());
        if (this.multipartRequiresStub()) {
            long partCount = parts.size();
            if (this.getBlobStoreType().equals("google-cloud-storage")) {
                partCount = 0L;
                for (MultipartPart part : parts) {
                    blobName = String.format("%s_%08d", mpu.id(), part.partNumber());
                    BlobMetadata metadata = this.delegate().blobMetadata(mpu.containerName(), blobName);
                    if (metadata != null && metadata.getUserMetadata().containsKey("s3proxy_encryption_parts")) {
                        String partMetaCount = (String)metadata.getUserMetadata().get("s3proxy_encryption_parts");
                        partCount += Long.parseLong(partMetaCount);
                        continue;
                    }
                    ++partCount;
                }
            }
            mpuWithSuffix.blobMetadata().getUserMetadata().put("s3proxy_encryption_parts", String.valueOf(partCount));
            mpuWithSuffix.blobMetadata().getUserMetadata().remove("s3proxy_encryption_multipart");
        }
        String eTag = this.delegate().completeMultipartUpload(mpuWithSuffix, parts);
        if (this.getBlobStoreType().equals("google-cloud-storage")) {
            this.delegate().removeBlob(mpu.containerName(), ".mpu/" + mpu.id());
        }
        return eTag;
    }

    public BlobMetadata blobMetadata(String container, String name) {
        name = this.blobNameWithSuffix(container, name);
        BlobMetadata blobMetadata = this.delegate().blobMetadata(container, name);
        if (blobMetadata != null && this.isEncrypted(blobMetadata) && !blobMetadata.getUserMetadata().containsKey("s3proxy_encryption_multipart")) {
            blobMetadata = this.removeEncryptedSuffix(blobMetadata);
            blobMetadata = this.calculateBlobSize(blobMetadata);
        }
        return blobMetadata;
    }

    public long getMaximumMultipartPartSize() {
        long max = this.delegate().getMaximumMultipartPartSize();
        return max - 64L;
    }
}

