/*
 * Decompiled with CFR 0.152.
 */
package org.gaul.s3proxy;

import com.google.common.collect.Maps;
import java.nio.file.FileSystems;
import java.nio.file.PathMatcher;
import java.util.Map;
import javax.annotation.Nullable;
import org.gaul.s3proxy.BlobStoreLocator;
import org.jclouds.blobstore.BlobStore;

public final class GlobBlobStoreLocator
implements BlobStoreLocator {
    private final Map<String, Map.Entry<String, BlobStore>> locator;
    private final Map<PathMatcher, Map.Entry<String, BlobStore>> globLocator;

    public GlobBlobStoreLocator(Map<String, Map.Entry<String, BlobStore>> locator, Map<PathMatcher, Map.Entry<String, BlobStore>> globLocator) {
        this.locator = locator;
        this.globLocator = globLocator;
    }

    @Override
    public Map.Entry<String, BlobStore> locateBlobStore(@Nullable String identity, String container, String blob) {
        Map.Entry<String, BlobStore> locatorEntry = this.locator.get(identity);
        Map.Entry<String, BlobStore> globEntry = null;
        if (container != null) {
            for (Map.Entry<PathMatcher, Map.Entry<String, BlobStore>> entry : this.globLocator.entrySet()) {
                if (!entry.getKey().matches(FileSystems.getDefault().getPath(container, new String[0]))) continue;
                globEntry = entry.getValue();
            }
        }
        if (globEntry == null) {
            if (identity == null) {
                if (!this.locator.isEmpty()) {
                    return this.locator.entrySet().iterator().next().getValue();
                }
                return Maps.immutableEntry(null, (Object)this.globLocator.entrySet().iterator().next().getValue().getValue());
            }
            return locatorEntry;
        }
        if (identity == null) {
            return Maps.immutableEntry(null, (Object)((BlobStore)globEntry.getValue()));
        }
        if (!((String)globEntry.getKey()).equals(identity)) {
            return null;
        }
        if (locatorEntry == null) {
            return null;
        }
        return Map.entry(locatorEntry.getKey(), (BlobStore)globEntry.getValue());
    }
}

