/*
 * Decompiled with CFR 0.152.
 */
package org.gaul.s3proxy;

import com.google.common.base.Preconditions;
import java.io.File;
import java.io.InputStream;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.concurrent.ExecutorService;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jclouds.blobstore.BlobStore;
import org.jclouds.blobstore.domain.Blob;
import org.jclouds.blobstore.domain.BlobAccess;
import org.jclouds.blobstore.domain.BlobMetadata;
import org.jclouds.blobstore.options.CopyOptions;
import org.jclouds.blobstore.options.PutOptions;
import org.jclouds.blobstore.util.ForwardingBlobStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class RegexBlobStore
extends ForwardingBlobStore {
    private static final Logger logger = LoggerFactory.getLogger(RegexBlobStore.class);
    private final List<Map.Entry<Pattern, String>> regexs;

    private RegexBlobStore(BlobStore blobStore, List<Map.Entry<Pattern, String>> regexs) {
        super(blobStore);
        this.regexs = Objects.requireNonNull(regexs);
    }

    static BlobStore newRegexBlobStore(BlobStore delegate, List<Map.Entry<Pattern, String>> regexs) {
        return new RegexBlobStore(delegate, regexs);
    }

    public static List<Map.Entry<Pattern, String>> parseRegexs(Properties properties) {
        ArrayList<AbstractMap.SimpleEntry<String, String>> configRegex = new ArrayList<AbstractMap.SimpleEntry<String, String>>();
        ArrayList<AbstractMap.SimpleEntry<Pattern, String>> regexs = new ArrayList<AbstractMap.SimpleEntry<Pattern, String>>();
        for (String string : properties.stringPropertyNames()) {
            if (!string.startsWith("s3proxy.regex-blobstore")) continue;
            String propKey = string.substring("s3proxy.regex-blobstore".length() + 1);
            String value = properties.getProperty(string);
            configRegex.add(new AbstractMap.SimpleEntry<String, String>(propKey, value));
        }
        for (Map.Entry entry : configRegex) {
            String key = (String)entry.getKey();
            if (!key.startsWith("match")) continue;
            String regexName = key.substring("match".length() + 1);
            String regex = (String)entry.getValue();
            Pattern pattern = Pattern.compile(regex);
            String replace = properties.getProperty(String.join((CharSequence)".", "s3proxy.regex-blobstore", "replace", regexName));
            Preconditions.checkArgument((replace != null ? 1 : 0) != 0, (String)"Regex %s has no replace property associated", (Object)regexName);
            logger.info("Adding new regex with name {} replaces with {} to {}", new Object[]{regexName, regex, replace});
            regexs.add(new AbstractMap.SimpleEntry<Pattern, String>(pattern, replace));
        }
        return List.copyOf(regexs);
    }

    public boolean directoryExists(String container, String directory) {
        return super.directoryExists(container, this.replaceBlobName(directory));
    }

    public void createDirectory(String container, String directory) {
        super.createDirectory(container, this.replaceBlobName(directory));
    }

    public void deleteDirectory(String container, String directory) {
        super.deleteDirectory(container, this.replaceBlobName(directory));
    }

    public boolean blobExists(String container, String name) {
        return super.blobExists(container, this.replaceBlobName(name));
    }

    public String putBlob(String containerName, Blob blob) {
        String name = blob.getMetadata().getName();
        String newName = this.replaceBlobName(name);
        blob.getMetadata().setName(newName);
        logger.debug("Renaming blob name from {} to {}", (Object)name, (Object)newName);
        return super.putBlob(containerName, blob);
    }

    public String putBlob(String containerName, Blob blob, PutOptions putOptions) {
        String name = blob.getMetadata().getName();
        String newName = this.replaceBlobName(name);
        blob.getMetadata().setName(newName);
        logger.debug("Renaming blob name from {} to {}", (Object)name, (Object)newName);
        return super.putBlob(containerName, blob, putOptions);
    }

    public String copyBlob(String fromContainer, String fromName, String toContainer, String toName, CopyOptions options) {
        return super.copyBlob(fromContainer, this.replaceBlobName(fromName), toContainer, this.replaceBlobName(toName), options);
    }

    public BlobMetadata blobMetadata(String container, String name) {
        return super.blobMetadata(container, this.replaceBlobName(name));
    }

    public Blob getBlob(String containerName, String name) {
        return super.getBlob(containerName, this.replaceBlobName(name));
    }

    public void removeBlob(String container, String name) {
        super.removeBlob(container, this.replaceBlobName(name));
    }

    public void removeBlobs(String container, Iterable<String> iterable) {
        ArrayList<String> blobs = new ArrayList<String>();
        for (String name : iterable) {
            blobs.add(this.replaceBlobName(name));
        }
        super.removeBlobs(container, blobs);
    }

    public BlobAccess getBlobAccess(String container, String name) {
        return super.getBlobAccess(container, this.replaceBlobName(name));
    }

    public void setBlobAccess(String container, String name, BlobAccess access) {
        super.setBlobAccess(container, this.replaceBlobName(name), access);
    }

    public void downloadBlob(String container, String name, File destination) {
        super.downloadBlob(container, this.replaceBlobName(name), destination);
    }

    public void downloadBlob(String container, String name, File destination, ExecutorService executor) {
        super.downloadBlob(container, this.replaceBlobName(name), destination, executor);
    }

    public InputStream streamBlob(String container, String name) {
        return super.streamBlob(container, this.replaceBlobName(name));
    }

    public InputStream streamBlob(String container, String name, ExecutorService executor) {
        return super.streamBlob(container, this.replaceBlobName(name), executor);
    }

    private String replaceBlobName(String name) {
        String newName = name;
        for (Map.Entry<Pattern, String> entry : this.regexs) {
            Pattern pattern = entry.getKey();
            Matcher match = pattern.matcher(name);
            if (!match.find()) continue;
            return match.replaceAll(entry.getValue());
        }
        return newName;
    }
}

