/*
 * Decompiled with CFR 0.152.
 */
package org.gaul.s3proxy;

import org.jclouds.blobstore.BlobStore;
import org.jclouds.blobstore.domain.Blob;
import org.jclouds.blobstore.domain.BlobMetadata;
import org.jclouds.blobstore.domain.MultipartUpload;
import org.jclouds.blobstore.domain.MutableBlobMetadata;
import org.jclouds.blobstore.domain.Tier;
import org.jclouds.blobstore.domain.internal.BlobMetadataImpl;
import org.jclouds.blobstore.options.PutOptions;
import org.jclouds.blobstore.util.ForwardingBlobStore;
import org.jclouds.io.MutableContentMetadata;
import org.jclouds.s3.domain.ObjectMetadata;

public final class StorageClassBlobStore
extends ForwardingBlobStore {
    private final Tier tier;

    private StorageClassBlobStore(BlobStore delegate, String storageClassString) {
        super(delegate);
        ObjectMetadata.StorageClass storageClass;
        try {
            storageClass = ObjectMetadata.StorageClass.valueOf((String)storageClassString.toUpperCase());
        }
        catch (IllegalArgumentException iae) {
            storageClass = ObjectMetadata.StorageClass.STANDARD;
        }
        this.tier = storageClass.toTier();
    }

    static StorageClassBlobStore newStorageClassBlobStore(BlobStore blobStore, String storageClass) {
        return new StorageClassBlobStore(blobStore, storageClass);
    }

    public Tier getTier() {
        return this.tier;
    }

    public String putBlob(String containerName, Blob blob) {
        Blob newBlob = this.replaceTier(containerName, blob);
        return this.delegate().putBlob(containerName, newBlob);
    }

    public String putBlob(String containerName, Blob blob, PutOptions options) {
        Blob newBlob = this.replaceTier(containerName, blob);
        return this.delegate().putBlob(containerName, newBlob, options);
    }

    public MultipartUpload initiateMultipartUpload(String container, BlobMetadata blobMetadata, PutOptions options) {
        BlobMetadata newBlobMetadata = this.replaceTier(blobMetadata);
        return this.delegate().initiateMultipartUpload(container, newBlobMetadata, options);
    }

    private Blob replaceTier(String containerName, Blob blob) {
        MutableBlobMetadata blobMeta = blob.getMetadata();
        MutableContentMetadata contentMeta = blob.getMetadata().getContentMetadata();
        return this.blobBuilder(containerName).name(blobMeta.getName()).type(blobMeta.getType()).tier(this.tier).userMetadata(blobMeta.getUserMetadata()).payload(blob.getPayload()).cacheControl(contentMeta.getCacheControl()).contentDisposition(contentMeta.getContentDisposition()).contentEncoding(contentMeta.getContentEncoding()).contentLanguage(contentMeta.getContentLanguage()).contentType(contentMeta.getContentType()).build();
    }

    private BlobMetadata replaceTier(BlobMetadata meta) {
        return new BlobMetadataImpl(meta.getProviderId(), meta.getName(), meta.getLocation(), meta.getUri(), meta.getETag(), meta.getCreationDate(), meta.getLastModified(), meta.getUserMetadata(), meta.getPublicUri(), meta.getContainer(), meta.getContentMetadata(), meta.getSize(), this.tier);
    }
}

