/*
 * Decompiled with CFR 0.152.
 */
package org.gaul.s3proxy;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import org.jclouds.blobstore.BlobStore;
import org.jclouds.blobstore.domain.Blob;
import org.jclouds.blobstore.domain.BlobMetadata;
import org.jclouds.blobstore.domain.MultipartUpload;
import org.jclouds.blobstore.domain.MutableBlobMetadata;
import org.jclouds.blobstore.options.GetOptions;
import org.jclouds.blobstore.options.PutOptions;
import org.jclouds.blobstore.util.ForwardingBlobStore;

final class UserMetadataReplacerBlobStore
extends ForwardingBlobStore {
    private final String fromChars;
    private final String toChars;

    private UserMetadataReplacerBlobStore(BlobStore blobStore, String fromChars, String toChars) {
        super(blobStore);
        Preconditions.checkArgument((fromChars.length() == toChars.length() ? 1 : 0) != 0);
        this.fromChars = fromChars;
        this.toChars = toChars;
    }

    public static BlobStore newUserMetadataReplacerBlobStore(BlobStore blobStore, String fromChars, String toChars) {
        return new UserMetadataReplacerBlobStore(blobStore, fromChars, toChars);
    }

    public String putBlob(String containerName, Blob blob) {
        return this.putBlob(containerName, blob, new PutOptions());
    }

    public String putBlob(String containerName, Blob blob, PutOptions putOptions) {
        ImmutableMap.Builder metadata = ImmutableMap.builder();
        for (Map.Entry entry : blob.getMetadata().getUserMetadata().entrySet()) {
            metadata.put((Object)UserMetadataReplacerBlobStore.replaceChars((String)entry.getKey(), this.fromChars, this.toChars), (Object)UserMetadataReplacerBlobStore.replaceChars((String)entry.getValue(), this.fromChars, this.toChars));
        }
        blob.getMetadata().setUserMetadata((Map)metadata.build());
        return super.putBlob(containerName, blob, putOptions);
    }

    public BlobMetadata blobMetadata(String container, String name) {
        BlobMetadata blobMetadata = super.blobMetadata(container, name);
        if (blobMetadata == null) {
            return null;
        }
        ImmutableMap.Builder metadata = ImmutableMap.builder();
        for (Map.Entry entry : blobMetadata.getUserMetadata().entrySet()) {
            metadata.put((Object)UserMetadataReplacerBlobStore.replaceChars((String)entry.getKey(), this.toChars, this.fromChars), (Object)UserMetadataReplacerBlobStore.replaceChars((String)entry.getValue(), this.toChars, this.fromChars));
        }
        ((MutableBlobMetadata)blobMetadata).setUserMetadata((Map)metadata.build());
        return blobMetadata;
    }

    public Blob getBlob(String containerName, String name) {
        return this.getBlob(containerName, name, new GetOptions());
    }

    public Blob getBlob(String containerName, String name, GetOptions getOptions) {
        Blob blob = super.getBlob(containerName, name, getOptions);
        if (blob == null) {
            return null;
        }
        ImmutableMap.Builder metadata = ImmutableMap.builder();
        for (Map.Entry entry : blob.getMetadata().getUserMetadata().entrySet()) {
            metadata.put((Object)UserMetadataReplacerBlobStore.replaceChars((String)entry.getKey(), this.toChars, this.fromChars), (Object)UserMetadataReplacerBlobStore.replaceChars((String)entry.getValue(), this.toChars, this.fromChars));
        }
        blob.getMetadata().setUserMetadata((Map)metadata.build());
        return blob;
    }

    public MultipartUpload initiateMultipartUpload(String container, BlobMetadata blobMetadata, PutOptions overrides) {
        ImmutableMap.Builder metadata = ImmutableMap.builder();
        for (Map.Entry entry : blobMetadata.getUserMetadata().entrySet()) {
            metadata.put((Object)UserMetadataReplacerBlobStore.replaceChars((String)entry.getKey(), this.fromChars, this.toChars), (Object)UserMetadataReplacerBlobStore.replaceChars((String)entry.getValue(), this.fromChars, this.toChars));
        }
        ((MutableBlobMetadata)blobMetadata).setUserMetadata((Map)metadata.build());
        return super.initiateMultipartUpload(container, blobMetadata, overrides);
    }

    private static String replaceChars(String value, String fromChars, String toChars) {
        StringBuilder builder = new StringBuilder(value.length());
        for (int i = 0; i < value.length(); ++i) {
            for (int j = 0; j < fromChars.length(); ++j) {
                builder.append(value.charAt(i) == fromChars.charAt(j) ? toChars.charAt(j) : value.charAt(i));
            }
        }
        return builder.toString();
    }
}

