/*
 * Decompiled with CFR 0.152.
 */
package org.gaul.s3proxy.azureblob;

import com.google.auto.service.AutoService;
import java.net.URI;
import java.util.Properties;
import org.gaul.s3proxy.azureblob.AzureBlobApiMetadata;
import org.jclouds.apis.ApiMetadata;
import org.jclouds.oauth.v2.config.CredentialType;
import org.jclouds.providers.ProviderMetadata;
import org.jclouds.providers.internal.BaseProviderMetadata;

@AutoService(value={ProviderMetadata.class})
public final class AzureBlobProviderMetadata
extends BaseProviderMetadata {
    public AzureBlobProviderMetadata() {
        super((BaseProviderMetadata.Builder)AzureBlobProviderMetadata.builder());
    }

    public AzureBlobProviderMetadata(Builder builder) {
        super((BaseProviderMetadata.Builder)builder);
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return AzureBlobProviderMetadata.builder().fromProviderMetadata((ProviderMetadata)this);
    }

    public static Properties defaultProperties() {
        Properties properties = new Properties();
        properties.put("oauth.endpoint", "https://login.microsoft.com/${jclouds.azureblob.tenantId}/oauth2/token");
        properties.put("jclouds.oauth.resource", "https://storage.azure.com");
        properties.put("jclouds.oauth.credential-type", CredentialType.CLIENT_CREDENTIALS_SECRET.toString());
        properties.put("jclouds.azureblob.account", "${jclouds.identity}");
        return properties;
    }

    public static final class Builder
    extends BaseProviderMetadata.Builder {
        protected Builder() {
            this.id("azureblob-sdk").name("Microsoft Azure Blob Service").apiMetadata((ApiMetadata)new AzureBlobApiMetadata()).endpoint("https://${jclouds.azureblob.account}.blob.core.windows.net").homepage(URI.create("http://www.microsoft.com/windowsazure/storage/")).console(URI.create("https://windows.azure.com/default.aspx")).linkedServices(new String[]{"azureblob", "azurequeue", "azuretable"}).iso3166Codes(new String[]{"US-TX", "US-IL", "IE-D", "SG", "NL-NH", "HK"}).defaultProperties(AzureBlobProviderMetadata.defaultProperties());
        }

        public AzureBlobProviderMetadata build() {
            return new AzureBlobProviderMetadata(this);
        }

        public Builder fromProviderMetadata(ProviderMetadata in) {
            super.fromProviderMetadata(in);
            return this;
        }
    }
}

