/*
 * Decompiled with CFR 0.152.
 */
package org.gaul.s3proxy.azureblob;

import com.azure.core.credential.AzureNamedKeyCredential;
import com.azure.core.credential.TokenCredential;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.Response;
import com.azure.identity.DefaultAzureCredentialBuilder;
import com.azure.storage.blob.BlobClient;
import com.azure.storage.blob.BlobContainerClient;
import com.azure.storage.blob.BlobServiceClient;
import com.azure.storage.blob.BlobServiceClientBuilder;
import com.azure.storage.blob.models.AccessTier;
import com.azure.storage.blob.models.BlobContainerItem;
import com.azure.storage.blob.models.BlobErrorCode;
import com.azure.storage.blob.models.BlobHttpHeaders;
import com.azure.storage.blob.models.BlobItem;
import com.azure.storage.blob.models.BlobItemProperties;
import com.azure.storage.blob.models.BlobListDetails;
import com.azure.storage.blob.models.BlobProperties;
import com.azure.storage.blob.models.BlobRange;
import com.azure.storage.blob.models.BlobRequestConditions;
import com.azure.storage.blob.models.BlobStorageException;
import com.azure.storage.blob.models.Block;
import com.azure.storage.blob.models.BlockBlobItem;
import com.azure.storage.blob.models.BlockList;
import com.azure.storage.blob.models.BlockListType;
import com.azure.storage.blob.models.ListBlobsOptions;
import com.azure.storage.blob.models.PublicAccessType;
import com.azure.storage.blob.options.BlobContainerCreateOptions;
import com.azure.storage.blob.options.BlobUploadFromUrlOptions;
import com.azure.storage.blob.options.BlockBlobOutputStreamOptions;
import com.azure.storage.blob.sas.BlobSasPermission;
import com.azure.storage.blob.sas.BlobServiceSasSignatureValues;
import com.azure.storage.blob.specialized.BlobInputStream;
import com.azure.storage.blob.specialized.BlobOutputStream;
import com.azure.storage.blob.specialized.BlockBlobClient;
import com.azure.storage.common.policy.RequestRetryOptions;
import com.azure.storage.common.policy.RetryPolicyType;
import com.google.common.base.Supplier;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.primitives.Ints;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import jakarta.ws.rs.core.Response;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.util.Base64;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Nullable;
import org.jclouds.blobstore.BlobStoreContext;
import org.jclouds.blobstore.ContainerNotFoundException;
import org.jclouds.blobstore.KeyNotFoundException;
import org.jclouds.blobstore.domain.Blob;
import org.jclouds.blobstore.domain.BlobAccess;
import org.jclouds.blobstore.domain.BlobMetadata;
import org.jclouds.blobstore.domain.ContainerAccess;
import org.jclouds.blobstore.domain.MultipartPart;
import org.jclouds.blobstore.domain.MultipartUpload;
import org.jclouds.blobstore.domain.MutableBlobMetadata;
import org.jclouds.blobstore.domain.PageSet;
import org.jclouds.blobstore.domain.StorageMetadata;
import org.jclouds.blobstore.domain.StorageType;
import org.jclouds.blobstore.domain.Tier;
import org.jclouds.blobstore.domain.internal.BlobBuilderImpl;
import org.jclouds.blobstore.domain.internal.BlobMetadataImpl;
import org.jclouds.blobstore.domain.internal.PageSetImpl;
import org.jclouds.blobstore.domain.internal.StorageMetadataImpl;
import org.jclouds.blobstore.internal.BaseBlobStore;
import org.jclouds.blobstore.options.CopyOptions;
import org.jclouds.blobstore.options.CreateContainerOptions;
import org.jclouds.blobstore.options.GetOptions;
import org.jclouds.blobstore.options.ListContainerOptions;
import org.jclouds.blobstore.options.PutOptions;
import org.jclouds.blobstore.util.BlobUtils;
import org.jclouds.collect.Memoized;
import org.jclouds.domain.Credentials;
import org.jclouds.domain.Location;
import org.jclouds.http.HttpCommand;
import org.jclouds.http.HttpRequest;
import org.jclouds.http.HttpResponse;
import org.jclouds.http.HttpResponseException;
import org.jclouds.io.ContentMetadata;
import org.jclouds.io.ContentMetadataBuilder;
import org.jclouds.io.MutableContentMetadata;
import org.jclouds.io.Payload;
import org.jclouds.io.PayloadSlicer;
import org.jclouds.location.Provider;
import org.jclouds.providers.ProviderMetadata;

@Singleton
public final class AzureBlobStore
extends BaseBlobStore {
    private final BlobServiceClient blobServiceClient;
    private final String endpoint;

    @Inject
    AzureBlobStore(BlobStoreContext context, BlobUtils blobUtils, Supplier<Location> defaultLocation, @Memoized Supplier<Set<? extends Location>> locations, PayloadSlicer slicer, @Provider Supplier<Credentials> creds, ProviderMetadata provider) {
        super(context, blobUtils, defaultLocation, locations, slicer);
        this.endpoint = provider.getEndpoint();
        Credentials cred = (Credentials)creds.get();
        RequestRetryOptions retryOptions = new RequestRetryOptions(RetryPolicyType.FIXED, Integer.valueOf(1), (Integer)null, null, null, null);
        BlobServiceClientBuilder blobServiceClientBuilder = new BlobServiceClientBuilder();
        if (!cred.identity.isEmpty() && !cred.credential.isEmpty()) {
            blobServiceClientBuilder.credential(new AzureNamedKeyCredential(cred.identity, cred.credential));
        } else {
            blobServiceClientBuilder.credential((TokenCredential)new DefaultAzureCredentialBuilder().build());
        }
        this.blobServiceClient = blobServiceClientBuilder.endpoint(this.endpoint).retryOptions(retryOptions).buildClient();
    }

    public PageSet<? extends StorageMetadata> list() {
        ImmutableSet.Builder set = ImmutableSet.builder();
        for (BlobContainerItem container : this.blobServiceClient.listBlobContainers()) {
            set.add((Object)new StorageMetadataImpl(StorageType.CONTAINER, null, container.getName(), null, null, null, null, AzureBlobStore.toDate(container.getProperties().getLastModified()), Map.of(), null, Tier.STANDARD));
        }
        return new PageSetImpl((Iterable)set.build(), null);
    }

    public PageSet<? extends StorageMetadata> list(String container, ListContainerOptions options) {
        PagedResponse page;
        BlobContainerClient client = this.blobServiceClient.getBlobContainerClient(container);
        ListBlobsOptions azureOptions = new ListBlobsOptions();
        azureOptions.setPrefix(options.getPrefix());
        azureOptions.setMaxResultsPerPage(options.getMaxResults());
        String marker = options.getMarker() != null ? URLDecoder.decode(options.getMarker(), StandardCharsets.UTF_8) : null;
        ImmutableSet.Builder set = ImmutableSet.builder();
        try {
            page = (PagedResponse)client.listBlobsByHierarchy(options.getDelimiter(), azureOptions, null).iterableByPage((Object)marker).iterator().next();
        }
        catch (BlobStorageException bse) {
            this.translateAndRethrowException(bse, container, null);
            throw bse;
        }
        for (BlobItem blob : page.getValue()) {
            BlobItemProperties properties = blob.getProperties();
            if (blob.isPrefix().booleanValue()) {
                set.add((Object)new StorageMetadataImpl(StorageType.RELATIVE_PATH, null, blob.getName(), null, null, null, null, null, Map.of(), null, Tier.STANDARD));
                continue;
            }
            set.add((Object)new StorageMetadataImpl(StorageType.BLOB, null, blob.getName(), null, null, properties.getETag(), AzureBlobStore.toDate(properties.getCreationTime()), AzureBlobStore.toDate(properties.getLastModified()), Map.of(), properties.getContentLength(), AzureBlobStore.toTier(properties.getAccessTier())));
        }
        return new PageSetImpl((Iterable)set.build(), (String)page.getContinuationToken());
    }

    public boolean containerExists(String container) {
        BlobContainerClient client = this.blobServiceClient.getBlobContainerClient(container);
        return client.exists();
    }

    public boolean createContainerInLocation(Location location, String container) {
        return this.createContainerInLocation(location, container, new CreateContainerOptions());
    }

    public boolean createContainerInLocation(Location location, String container, CreateContainerOptions options) {
        BlobContainerCreateOptions azureOptions = new BlobContainerCreateOptions();
        if (options.isPublicRead()) {
            azureOptions.setPublicAccessType(PublicAccessType.CONTAINER);
        }
        try {
            Response response = this.blobServiceClient.createBlobContainerIfNotExistsWithResponse(container, azureOptions, null);
            switch (response.getStatusCode()) {
                case 201: {
                    return true;
                }
                case 409: {
                    return false;
                }
            }
            return false;
        }
        catch (BlobStorageException bse) {
            this.translateAndRethrowException(bse, container, null);
            throw bse;
        }
    }

    public void deleteContainer(String container) {
        block2: {
            try {
                this.blobServiceClient.deleteBlobContainer(container);
            }
            catch (BlobStorageException bse) {
                if (bse.getErrorCode() == BlobErrorCode.CONTAINER_NOT_FOUND) break block2;
                throw bse;
            }
        }
    }

    public boolean deleteContainerIfEmpty(String container) {
        BlobContainerClient client = this.blobServiceClient.getBlobContainerClient(container);
        try {
            PagedResponse page = (PagedResponse)client.listBlobsByHierarchy(null, null, null).iterableByPage().iterator().next();
            if (!page.getValue().isEmpty()) {
                return false;
            }
            this.blobServiceClient.deleteBlobContainer(container);
            return true;
        }
        catch (BlobStorageException bse) {
            if (bse.getErrorCode() == BlobErrorCode.CONTAINER_NOT_FOUND) {
                return true;
            }
            throw bse;
        }
    }

    public boolean blobExists(String container, String key) {
        BlobClient client = this.blobServiceClient.getBlobContainerClient(container).getBlobClient(key);
        return client.exists();
    }

    public Blob getBlob(String container, String key, GetOptions options) {
        BlobInputStream blobStream;
        BlobClient client = this.blobServiceClient.getBlobContainerClient(container).getBlobClient(key);
        BlobRange azureRange = null;
        if (!options.getRanges().isEmpty()) {
            long offset;
            String[] ranges = ((String)options.getRanges().get(0)).split("-", 2);
            if (ranges[0].isEmpty()) {
                long end;
                long offset2 = 0L;
                long length = end = Long.parseLong(ranges[1]);
                azureRange = new BlobRange(offset2, Long.valueOf(length));
                throw new UnsupportedOperationException("trailing ranges unsupported");
            }
            if (ranges[1].isEmpty()) {
                offset = Long.parseLong(ranges[0]);
                azureRange = new BlobRange(offset);
            } else {
                offset = Long.parseLong(ranges[0]);
                long end = Long.parseLong(ranges[1]);
                long length = end - offset + 1L;
                azureRange = new BlobRange(offset, Long.valueOf(length));
            }
        }
        BlobRequestConditions conditions = new BlobRequestConditions().setIfMatch(options.getIfMatch()).setIfModifiedSince(AzureBlobStore.toOffsetDateTime(options.getIfModifiedSince())).setIfNoneMatch(options.getIfNoneMatch()).setIfUnmodifiedSince(AzureBlobStore.toOffsetDateTime(options.getIfUnmodifiedSince()));
        try {
            blobStream = client.openInputStream(azureRange, conditions);
        }
        catch (BlobStorageException bse) {
            this.translateAndRethrowException(bse, container, key);
            if (bse.getStatusCode() == Response.Status.REQUESTED_RANGE_NOT_SATISFIABLE.getStatusCode()) {
                throw new HttpResponseException("illegal range: " + String.valueOf(azureRange), null, HttpResponse.builder().statusCode(Response.Status.REQUESTED_RANGE_NOT_SATISFIABLE.getStatusCode()).build());
            }
            throw bse;
        }
        BlobProperties properties = blobStream.getProperties();
        OffsetDateTime expires = properties.getExpiresOn();
        long contentLength = azureRange == null ? properties.getBlobSize() : (azureRange.getCount() == null ? properties.getBlobSize() - azureRange.getOffset() : azureRange.getCount());
        Blob blob = new BlobBuilderImpl().name(key).userMetadata(properties.getMetadata()).payload((InputStream)blobStream).cacheControl(properties.getCacheControl()).contentDisposition(properties.getContentDisposition()).contentEncoding(properties.getContentEncoding()).contentLanguage(properties.getContentLanguage()).contentLength(contentLength).contentType(properties.getContentType()).expires(expires != null ? AzureBlobStore.toDate(expires) : null).build();
        if (azureRange != null) {
            blob.getAllHeaders().put((Object)"Content-Range", (Object)("bytes " + azureRange.getOffset() + "-" + (azureRange.getOffset() + contentLength - 1L) + "/" + properties.getBlobSize()));
        }
        MutableBlobMetadata metadata = blob.getMetadata();
        metadata.setETag(properties.getETag());
        metadata.setCreationDate(AzureBlobStore.toDate(properties.getCreationTime()));
        metadata.setLastModified(AzureBlobStore.toDate(properties.getLastModified()));
        return blob;
    }

    public String putBlob(String container, Blob blob) {
        return this.putBlob(container, blob, new PutOptions());
    }

    public String putBlob(String container, Blob blob, PutOptions options) {
        String string;
        block17: {
            BlockBlobClient client = this.blobServiceClient.getBlobContainerClient(container).getBlobClient(blob.getMetadata().getName()).getBlockBlobClient();
            InputStream is = blob.getPayload().openStream();
            try {
                BlockBlobOutputStreamOptions azureOptions = new BlockBlobOutputStreamOptions();
                azureOptions.setMetadata(blob.getMetadata().getUserMetadata());
                BlobHttpHeaders blobHttpHeaders = new BlobHttpHeaders();
                MutableContentMetadata contentMetadata = blob.getMetadata().getContentMetadata();
                blobHttpHeaders.setCacheControl(contentMetadata.getCacheControl());
                blobHttpHeaders.setContentDisposition(contentMetadata.getContentDisposition());
                blobHttpHeaders.setContentEncoding(contentMetadata.getContentEncoding());
                blobHttpHeaders.setContentLanguage(contentMetadata.getContentLanguage());
                blobHttpHeaders.setContentMd5(contentMetadata.getContentMD5());
                blobHttpHeaders.setContentType(contentMetadata.getContentType());
                azureOptions.setHeaders(blobHttpHeaders);
                if (blob.getMetadata().getTier() != Tier.STANDARD) {
                    azureOptions.setTier(AzureBlobStore.toAccessTier(blob.getMetadata().getTier()));
                }
                try (BlobOutputStream os = client.getBlobOutputStream(azureOptions, null);){
                    is.transferTo((OutputStream)os);
                }
                string = this.blobServiceClient.getBlobContainerClient(container).getBlobClient(blob.getMetadata().getName()).getProperties().getETag();
                if (is == null) break block17;
            }
            catch (Throwable azureOptions) {
                try {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable) {
                            azureOptions.addSuppressed(throwable);
                        }
                    }
                    throw azureOptions;
                }
                catch (IOException ioe) {
                    Throwable cause = ioe.getCause();
                    if (cause != null && cause instanceof BlobStorageException) {
                        this.translateAndRethrowException((BlobStorageException)cause, container, null);
                    }
                    throw new RuntimeException(ioe);
                }
            }
            is.close();
        }
        return string;
    }

    public String copyBlob(String fromContainer, String fromName, String toContainer, String toName, CopyOptions options) {
        OffsetDateTime expiryTime = OffsetDateTime.now().plusDays(1L);
        BlobSasPermission permission = new BlobSasPermission().setReadPermission(true);
        BlobServiceSasSignatureValues values = new BlobServiceSasSignatureValues(expiryTime, permission).setStartTime(OffsetDateTime.now());
        BlobClient fromClient = this.blobServiceClient.getBlobContainerClient(fromContainer).getBlobClient(fromName);
        String url = fromClient.getBlobUrl();
        String token = fromClient.generateSas(values);
        BlobUploadFromUrlOptions azureOptions = new BlobUploadFromUrlOptions(url + "?" + token);
        BlockBlobClient client = this.blobServiceClient.getBlobContainerClient(toContainer).getBlobClient(toName).getBlockBlobClient();
        BlobHttpHeaders headers = new BlobHttpHeaders();
        ContentMetadata contentMetadata = options.contentMetadata();
        if (contentMetadata != null) {
            String contentType;
            String contentLanguage;
            String contentEncoding;
            String contentDisposition;
            String cacheControl = contentMetadata.getCacheControl();
            if (cacheControl != null) {
                headers.setCacheControl(cacheControl);
            }
            if ((contentDisposition = contentMetadata.getContentDisposition()) != null) {
                headers.setContentDisposition(contentDisposition);
            }
            if ((contentEncoding = contentMetadata.getContentEncoding()) != null) {
                headers.setContentEncoding(contentEncoding);
            }
            if ((contentLanguage = contentMetadata.getContentLanguage()) != null) {
                headers.setContentLanguage(contentLanguage);
            }
            if ((contentType = contentMetadata.getContentType()) != null) {
                headers.setContentType(contentType);
            }
        }
        azureOptions.setHeaders(headers);
        Response response = client.uploadFromUrlWithResponse(azureOptions, null, null);
        Map userMetadata = options.userMetadata();
        if (userMetadata != null) {
            client.setMetadata(userMetadata);
        }
        return ((BlockBlobItem)response.getValue()).getETag();
    }

    public void removeBlob(String container, String key) {
        block2: {
            BlobClient client = this.blobServiceClient.getBlobContainerClient(container).getBlobClient(key);
            try {
                client.delete();
            }
            catch (BlobStorageException bse) {
                if (bse.getErrorCode() == BlobErrorCode.BLOB_NOT_FOUND || bse.getErrorCode() == BlobErrorCode.CONTAINER_NOT_FOUND) break block2;
                throw bse;
            }
        }
    }

    public BlobMetadata blobMetadata(String container, String key) {
        BlobProperties properties;
        BlobClient client = this.blobServiceClient.getBlobContainerClient(container).getBlobClient(key);
        try {
            properties = client.getProperties();
        }
        catch (BlobStorageException bse) {
            this.translateAndRethrowException(bse, container, null);
            throw bse;
        }
        return new BlobMetadataImpl(null, key, null, null, properties.getETag(), AzureBlobStore.toDate(properties.getCreationTime()), AzureBlobStore.toDate(properties.getLastModified()), properties.getMetadata(), null, container, AzureBlobStore.toContentMetadata(properties), Long.valueOf(properties.getBlobSize()), AzureBlobStore.toTier(properties.getAccessTier()));
    }

    protected boolean deleteAndVerifyContainerGone(String container) {
        this.blobServiceClient.deleteBlobContainer(container);
        return true;
    }

    public ContainerAccess getContainerAccess(String container) {
        BlobContainerClient client = this.blobServiceClient.getBlobContainerClient(container);
        try {
            return client.getAccessPolicy().getBlobAccessType() == PublicAccessType.CONTAINER ? ContainerAccess.PUBLIC_READ : ContainerAccess.PRIVATE;
        }
        catch (BlobStorageException bse) {
            this.translateAndRethrowException(bse, container, null);
            throw bse;
        }
    }

    public void setContainerAccess(String container, ContainerAccess access) {
        BlobContainerClient client = this.blobServiceClient.getBlobContainerClient(container);
        PublicAccessType publicAccess = access == ContainerAccess.PUBLIC_READ ? PublicAccessType.CONTAINER : PublicAccessType.BLOB;
        client.setAccessPolicy(publicAccess, List.of());
    }

    public BlobAccess getBlobAccess(String container, String key) {
        return BlobAccess.PRIVATE;
    }

    public void setBlobAccess(String container, String key, BlobAccess access) {
        throw new UnsupportedOperationException("unsupported in Azure");
    }

    public MultipartUpload initiateMultipartUpload(String container, BlobMetadata blobMetadata, PutOptions options) {
        throw new UnsupportedOperationException();
    }

    public void abortMultipartUpload(MultipartUpload mpu) {
    }

    public String completeMultipartUpload(MultipartUpload mpu, List<MultipartPart> parts) {
        BlockBlobClient client = this.blobServiceClient.getBlobContainerClient(mpu.containerName()).getBlobClient(mpu.blobName()).getBlockBlobClient();
        ImmutableList.Builder blocks = ImmutableList.builder();
        for (MultipartPart part : parts) {
            blocks.add((Object)AzureBlobStore.makeBlockId(part.partNumber()));
        }
        BlockBlobItem blockBlobItem = client.commitBlockList((List)blocks.build(), true);
        return blockBlobItem.getETag();
    }

    public MultipartPart uploadMultipartPart(MultipartUpload mpu, int partNumber, Payload payload) {
        BlockBlobClient client = this.blobServiceClient.getBlobContainerClient(mpu.containerName()).getBlobClient(mpu.blobName()).getBlockBlobClient();
        String blockId = AzureBlobStore.makeBlockId(partNumber);
        Long length = payload.getContentMetadata().getContentLength();
        try (InputStream is = payload.openStream();){
            client.stageBlock(blockId, is, length.longValue());
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
        String eTag = "";
        Date lastModified = null;
        return MultipartPart.create((int)partNumber, (long)length, (String)eTag, lastModified);
    }

    public List<MultipartPart> listMultipartUpload(MultipartUpload mpu) {
        BlockBlobClient client = this.blobServiceClient.getBlobContainerClient(mpu.containerName()).getBlobClient(mpu.blobName()).getBlockBlobClient();
        BlockList blockList = client.listBlocks(BlockListType.ALL);
        ImmutableList.Builder parts = ImmutableList.builder();
        for (Block properties : blockList.getUncommittedBlocks()) {
            int partNumber = Ints.fromByteArray((byte[])Base64.getDecoder().decode(properties.getName()));
            String eTag = "";
            Date lastModified = null;
            parts.add((Object)MultipartPart.create((int)partNumber, (long)properties.getSizeLong(), (String)eTag, lastModified));
        }
        return parts.build();
    }

    public List<MultipartUpload> listMultipartUploads(String container) {
        BlobContainerClient client = this.blobServiceClient.getBlobContainerClient(container);
        ListBlobsOptions azureOptions = new ListBlobsOptions();
        BlobListDetails details = new BlobListDetails();
        details.setRetrieveUncommittedBlobs(true);
        azureOptions.setDetails(details);
        ImmutableList.Builder builder = ImmutableList.builder();
        for (BlobItem blob : client.listBlobs(azureOptions, null, null)) {
            BlobItemProperties properties = blob.getProperties();
            if (properties.getETag() != null) continue;
            String uploadId = UUID.randomUUID().toString();
            builder.add((Object)MultipartUpload.create((String)container, (String)blob.getName(), (String)uploadId, null, null));
        }
        return builder.build();
    }

    public long getMinimumMultipartPartSize() {
        return 1L;
    }

    public long getMaximumMultipartPartSize() {
        return 0x6400000L;
    }

    public int getMaximumNumberOfParts() {
        return 50000;
    }

    public InputStream streamBlob(String container, String name) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    private static OffsetDateTime toOffsetDateTime(@Nullable Date date) {
        if (date == null) {
            return null;
        }
        return date.toInstant().atOffset(ZoneOffset.UTC);
    }

    private static Date toDate(OffsetDateTime time) {
        return new Date(time.toInstant().toEpochMilli());
    }

    private static AccessTier toAccessTier(Tier tier) {
        switch (tier) {
            case ARCHIVE: {
                return AccessTier.ARCHIVE;
            }
            case INFREQUENT: {
                return AccessTier.COOL;
            }
        }
        return AccessTier.HOT;
    }

    private static Tier toTier(AccessTier tier) {
        if (tier == null) {
            return Tier.STANDARD;
        }
        if (tier.equals((Object)AccessTier.ARCHIVE)) {
            return Tier.ARCHIVE;
        }
        if (tier.equals((Object)AccessTier.COLD) || tier.equals((Object)AccessTier.COOL)) {
            return Tier.INFREQUENT;
        }
        return Tier.STANDARD;
    }

    private static ContentMetadata toContentMetadata(BlobProperties properties) {
        OffsetDateTime expires = properties.getExpiresOn();
        return ContentMetadataBuilder.create().cacheControl(properties.getCacheControl()).contentDisposition(properties.getContentDisposition()).contentEncoding(properties.getContentEncoding()).contentLanguage(properties.getContentLanguage()).contentLength(Long.valueOf(properties.getBlobSize())).contentType(properties.getContentType()).expires(expires != null ? AzureBlobStore.toDate(expires) : null).build();
    }

    private static String makeBlockId(int partNumber) {
        return Base64.getEncoder().encodeToString(Ints.toByteArray((int)partNumber));
    }

    private void translateAndRethrowException(BlobStorageException bse, String container, @Nullable String key) {
        BlobErrorCode code = bse.getErrorCode();
        if (code == BlobErrorCode.BLOB_NOT_FOUND) {
            KeyNotFoundException exception = new KeyNotFoundException(container, key, "");
            exception.initCause((Throwable)bse);
            throw exception;
        }
        if (code == BlobErrorCode.CONTAINER_NOT_FOUND) {
            ContainerNotFoundException exception = new ContainerNotFoundException(container, "");
            exception.initCause((Throwable)bse);
            throw exception;
        }
        if (code == BlobErrorCode.CONDITION_NOT_MET) {
            HttpRequest request = HttpRequest.builder().method("GET").endpoint(this.endpoint).build();
            HttpResponse response = HttpResponse.builder().statusCode(Response.Status.PRECONDITION_FAILED.getStatusCode()).build();
            throw new HttpResponseException(new HttpCommand(request), response, (Throwable)bse);
        }
        if (code == BlobErrorCode.INVALID_OPERATION) {
            HttpRequest request = HttpRequest.builder().method("GET").endpoint(this.endpoint).build();
            HttpResponse response = HttpResponse.builder().statusCode(Response.Status.BAD_REQUEST.getStatusCode()).build();
            throw new HttpResponseException(new HttpCommand(request), response, (Throwable)bse);
        }
        if (bse.getErrorCode() == BlobErrorCode.INVALID_RESOURCE_NAME) {
            throw new IllegalArgumentException("Invalid container name", bse);
        }
    }
}

